import { IRole } from 'aws-cdk-lib/aws-iam';
import { CfnDeliveryStream } from 'aws-cdk-lib/aws-kinesisfirehose';
import { IKey } from 'aws-cdk-lib/aws-kms';
import { IBucket } from 'aws-cdk-lib/aws-s3';
import { IConstruct } from 'constructs';
import { BackupConfigurationResult, IDeliveryStreamBackupDestination } from '../backup-configuration';
import { BufferingConfiguration } from '../buffering-configuration';
import { CloudWatchLoggingConfiguration } from '../cloudwatch-logging-configuration';
import { DeliveryStreamDestination, DeliveryStreamDestinationConfiguration } from './delivery-stream-destination';
export declare enum S3CompressionFormat {
    GZIP = "GZIP",
    HADOOP_SNAPPY = "HADOOP_SNAPPY",
    SNAPPY = "Snappy",
    UNCOMPRESSED = "UNCOMPRESSED",
    ZIP = "ZIP"
}
export interface S3DestinationOptions {
    readonly buffering?: BufferingConfiguration;
    readonly cloudwatchLoggingConfiguration?: CloudWatchLoggingConfiguration;
    readonly compressionFormat?: S3CompressionFormat;
    readonly encryptionEnabled?: boolean;
    readonly encryptionKey?: IKey;
    readonly errorOutputPrefix?: string;
    readonly keyPrefix?: string;
    readonly role?: IRole;
}
export declare class S3Destination extends DeliveryStreamDestination implements IDeliveryStreamBackupDestination {
    private _role?;
    readonly bucket: IBucket;
    readonly buffering?: BufferingConfiguration;
    readonly cloudwatchLoggingConfiguration?: CloudWatchLoggingConfiguration;
    readonly compressionFormat?: S3CompressionFormat;
    readonly encryptionEnabled?: boolean;
    readonly encryptionKey?: IKey;
    readonly errorOutputPrefix?: string;
    readonly keyPrefix?: string;
    get role(): IRole | undefined;
    constructor(bucket: IBucket, options?: S3DestinationOptions);
    bind(scope: IConstruct): DeliveryStreamDestinationConfiguration;
    protected buildConfiguration(scope: IConstruct): CfnDeliveryStream.S3DestinationConfigurationProperty;
    renderBackupConfiguration(scope: IConstruct, enabled?: boolean): BackupConfigurationResult;
}
