"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaPartitioningSource = exports.JsonPartitioningSource = exports.DynamicPartitioning = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const formatting_1 = require("../../utils/formatting");
const metadata_extraction_query_1 = require("./metadata-extraction-query");
const lambda_processor_1 = require("./processors/lambda-processor");
const metadata_extraction_processor_1 = require("./processors/metadata-extraction-processor");
class DynamicPartitioning {
    constructor(options) {
        this.enabled = options.enabled ?? true;
        this.retryInterval = options.retryInterval;
    }
    // Static methods
    static fromJson(options) {
        return new JsonPartitioningSource(options);
    }
    static fromLambda(options) {
        return new LambdaPartitioningSource(options);
    }
    bind(_scope) {
        return {
            partitioningConfiguration: {
                enabled: this.enabled,
                retryOptions: formatting_1.definedFieldsOrUndefined({
                    durationInSeconds: this.retryInterval?.toSeconds(),
                }),
            },
        };
    }
}
exports.DynamicPartitioning = DynamicPartitioning;
_a = JSII_RTTI_SYMBOL_1;
DynamicPartitioning[_a] = { fqn: "cdk-extensions.kinesis_firehose.DynamicPartitioning", version: "0.0.12" };
class JsonPartitioningSource extends DynamicPartitioning {
    constructor(options) {
        super(options);
        // Internal properties
        this._partitions = {};
        this._query = new metadata_extraction_query_1.JsonQuery();
        Object.keys(options.partitions).forEach((x) => {
            this.addPartition(x, options.partitions[x]);
        });
    }
    addPartition(name, query) {
        this._partitions[name] = query;
        this._query.addField(name, query);
    }
    bind(scope) {
        const innerConfiguration = super.bind(scope);
        return {
            ...innerConfiguration,
            processors: [
                ...(innerConfiguration.processors ?? []),
                new metadata_extraction_processor_1.MetadataExtractionProcessor({
                    engine: metadata_extraction_processor_1.JsonParsingEngine.JQ_1_6,
                    query: this._query,
                }),
            ],
        };
    }
}
exports.JsonPartitioningSource = JsonPartitioningSource;
_b = JSII_RTTI_SYMBOL_1;
JsonPartitioningSource[_b] = { fqn: "cdk-extensions.kinesis_firehose.JsonPartitioningSource", version: "0.0.12" };
class LambdaPartitioningSource extends DynamicPartitioning {
    constructor(options) {
        super(options);
        this.lambdaFunction = options.lambdaFunction;
    }
    bind(scope) {
        const innerConfiguration = super.bind(scope);
        return {
            ...innerConfiguration,
            processors: [
                ...(innerConfiguration.processors ?? []),
                new lambda_processor_1.LambdaProcessor({
                    lambdaFunction: this.lambdaFunction,
                }),
            ],
        };
    }
}
exports.LambdaPartitioningSource = LambdaPartitioningSource;
_c = JSII_RTTI_SYMBOL_1;
LambdaPartitioningSource[_c] = { fqn: "cdk-extensions.kinesis_firehose.LambdaPartitioningSource", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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