import { CfnDeliveryStream } from 'aws-cdk-lib/aws-kinesisfirehose';
import { IConstruct } from 'constructs';
export declare class ProcessorType {
    static readonly APPEND_DELIMITER_TO_RECORD: ProcessorType;
    static readonly LAMBDA: ProcessorType;
    static readonly METADATA_EXTRACTION: ProcessorType;
    static readonly RECORD_DEAGGREGATION: ProcessorType;
    static of(name: string): ProcessorType;
    /**
       * The name of the processor to apply to the delivery stream.
       */
    readonly name: string;
    private constructor();
}
export interface DeliveryStreamProcessorOptions {
    readonly processorType: ProcessorType;
    readonly parameters?: {
        [name: string]: string;
    };
}
export declare class DeliveryStreamProcessor {
    private readonly _parameters;
    readonly processorType: ProcessorType;
    protected constructor(options: DeliveryStreamProcessorOptions);
    protected addProcessorParameter(name: string, value: string): void;
    bind(_scope: IConstruct): CfnDeliveryStream.ProcessorProperty;
}
