"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeliveryStreamProcessor = exports.ProcessorType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
class ProcessorType {
    constructor(name) {
        this.name = name;
    }
    static of(name) {
        return new ProcessorType(name);
    }
}
exports.ProcessorType = ProcessorType;
_a = JSII_RTTI_SYMBOL_1;
ProcessorType[_a] = { fqn: "cdk-extensions.kinesis_firehose.ProcessorType", version: "0.0.12" };
ProcessorType.APPEND_DELIMITER_TO_RECORD = ProcessorType.of('AppendDelimiterToRecord');
ProcessorType.LAMBDA = ProcessorType.of('Lambda');
ProcessorType.METADATA_EXTRACTION = ProcessorType.of('MetadataExtraction');
ProcessorType.RECORD_DEAGGREGATION = ProcessorType.of('RecordDeAggregation');
class DeliveryStreamProcessor {
    constructor(options) {
        // Internal properties
        this._parameters = {};
        this.processorType = options.processorType;
        if (options.parameters) {
            const params = options.parameters;
            Object.keys(params).forEach((x) => {
                this.addProcessorParameter(x, params[x]);
            });
        }
    }
    addProcessorParameter(name, value) {
        this._parameters[name] = value;
    }
    bind(_scope) {
        return {
            type: this.processorType.name,
            parameters: aws_cdk_lib_1.Lazy.any({
                produce: () => {
                    return Object.keys(this._parameters).map((x) => {
                        return {
                            parameterName: x,
                            parameterValue: this._parameters[x],
                        };
                    });
                },
            }),
        };
    }
}
exports.DeliveryStreamProcessor = DeliveryStreamProcessor;
_b = JSII_RTTI_SYMBOL_1;
DeliveryStreamProcessor[_b] = { fqn: "cdk-extensions.kinesis_firehose.DeliveryStreamProcessor", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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