import { Stage } from 'aws-cdk-lib';
import { IRole, IUser } from 'aws-cdk-lib/aws-iam';
import { IConstruct } from 'constructs';
export interface ISharedPrincipal {
    bind(scope: IConstruct): string;
}
export declare class SharedPrincipal implements ISharedPrincipal {
    static fromAccountId(account: string): SharedPrincipal;
    static fromConstruct(construct: IConstruct): SharedPrincipal;
    static fromOrganizationArn(arn: string): SharedPrincipal;
    static fromOrganizationalUnitArn(arn: string): SharedPrincipal;
    static fromRole(role: IRole): SharedPrincipal;
    static fromStage(stage: Stage): SharedPrincipal;
    static fromUser(user: IUser): SharedPrincipal;
    private readonly value;
    private constructor();
    bind(_scope: IConstruct): string;
}
