"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SharedPrincipal = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
class SharedPrincipal {
    constructor(value) {
        this.value = value;
    }
    static fromAccountId(account) {
        return new SharedPrincipal(account);
    }
    static fromConstruct(construct) {
        return new SharedPrincipal(aws_cdk_lib_1.Lazy.uncachedString({
            produce: (context) => {
                const stack = aws_cdk_lib_1.Stack.of(construct);
                if (aws_cdk_lib_1.Token.isUnresolved(stack.account)) {
                    return stack.account;
                }
                else {
                    aws_cdk_lib_1.Annotations.of(context.scope).addError([
                        `Failed to create resource share for stack '${stack.node.path}'. Only`,
                        'stacks with an account specified can be used in a resource share.',
                    ].join('.'));
                    return '<unknown-account>';
                }
            },
        }));
    }
    static fromOrganizationArn(arn) {
        return new SharedPrincipal(arn);
    }
    static fromOrganizationalUnitArn(arn) {
        return new SharedPrincipal(arn);
    }
    static fromRole(role) {
        return new SharedPrincipal(role.roleArn);
    }
    static fromStage(stage) {
        return new SharedPrincipal(aws_cdk_lib_1.Lazy.uncachedString({
            produce: (context) => {
                if (stage.account) {
                    return stage.account;
                }
                else {
                    aws_cdk_lib_1.Annotations.of(context.scope).addError([
                        `Failed to create resource share for stage '${stage.node.path}'. Only`,
                        'stages with an account specified can be used in a resource share.',
                    ].join('.'));
                    return '<unknown-account>';
                }
            },
        }));
    }
    static fromUser(user) {
        return new SharedPrincipal(user.userArn);
    }
    bind(_scope) {
        return this.value;
    }
}
exports.SharedPrincipal = SharedPrincipal;
_a = JSII_RTTI_SYMBOL_1;
SharedPrincipal[_a] = { fqn: "cdk-extensions.ram.SharedPrincipal", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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