"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ForwardResolverRule = void 0;
const resolver_rule_1 = require("./resolver-rule");
class ForwardResolverRule extends resolver_rule_1.ResolverRule {
    /**
       * Creates a new instance of the SystemResolverRule class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, {
            domainName: props.domainName,
            resolverEndpoint: props.resolverEndpoint,
            ruleName: props.ruleName,
            ruleType: resolver_rule_1.ResolverRuleType.FORWARD,
            targetIps: props.targetIps,
        });
    }
}
exports.ForwardResolverRule = ForwardResolverRule;
//# sourceMappingURL=data:application/json;base64,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