import { Resource, ResourceProps } from 'aws-cdk-lib';
import { IVpc } from 'aws-cdk-lib/aws-ec2';
import { CfnResolverRuleAssociation } from 'aws-cdk-lib/aws-route53resolver';
import { Construct } from 'constructs';
import { IResolverRule } from './resolver-rule';
/**
 * Generic configuration for a ResolverRuleAssociation resource
 */
export interface ResolverRuleAssociationProps extends ResourceProps {
    readonly name?: string;
    readonly resolverRule: IResolverRule;
    readonly vpc: IVpc;
}
export declare class ResolverRuleAssociation extends Resource {
    readonly name?: string;
    readonly resolverRule: IResolverRule;
    readonly vpc: IVpc;
    readonly resource: CfnResolverRuleAssociation;
    readonly resolverRuleAssociationId: string;
    readonly resolverRuleAssociationName: string;
    readonly resolverRuleAssociationResolverRuleId: string;
    readonly resolverRuleAssociationVpcId: string;
    /**
       * Creates a new instance of the ResolverRule class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope: Construct, id: string, props: ResolverRuleAssociationProps);
}
