"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SystemResolverRule = void 0;
const resolver_rule_1 = require("./resolver-rule");
class SystemResolverRule extends resolver_rule_1.ResolverRule {
    /**
       * Creates a new instance of the SystemResolverRule class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, {
            domainName: props.domainName,
            ruleName: props.ruleName,
            ruleType: resolver_rule_1.ResolverRuleType.SYSTEM,
        });
    }
}
exports.SystemResolverRule = SystemResolverRule;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3lzdGVtLXJlc29sdmVyLXJ1bGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvcm91dGU1M3Jlc29sdmVyL3N5c3RlbS1yZXNvbHZlci1ydWxlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUVBLG1EQUFpRTtBQVdqRSxNQUFhLGtCQUFtQixTQUFRLDRCQUFZO0lBQ2xEOzs7Ozs7O1NBT0s7SUFDTCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQThCO1FBQ3RFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVO1lBQzVCLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUTtZQUN4QixRQUFRLEVBQUUsZ0NBQWdCLENBQUMsTUFBTTtTQUNsQyxDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0Y7QUFoQkQsZ0RBZ0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgUmVzb3VyY2VQcm9wcyB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgUmVzb2x2ZXJSdWxlLCBSZXNvbHZlclJ1bGVUeXBlIH0gZnJvbSAnLi9yZXNvbHZlci1ydWxlJztcblxuXG4vKipcbiAqIEdlbmVyaWMgY29uZmlndXJhdGlvbiBmb3IgYSBTeXN0ZW1SZXNvbHZlclJ1bGUgcmVzb3VyY2VcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTeXN0ZW1SZXNvbHZlclJ1bGVQcm9wcyBleHRlbmRzIFJlc291cmNlUHJvcHMge1xuICByZWFkb25seSBkb21haW5OYW1lOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHJ1bGVOYW1lPzogc3RyaW5nO1xufVxuXG5leHBvcnQgY2xhc3MgU3lzdGVtUmVzb2x2ZXJSdWxlIGV4dGVuZHMgUmVzb2x2ZXJSdWxlIHtcbiAgLyoqXG4gICAgICogQ3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGUgU3lzdGVtUmVzb2x2ZXJSdWxlIGNsYXNzLlxuICAgICAqXG4gICAgICogQHBhcmFtIHNjb3BlIEEgQ0RLIENvbnN0cnVjdCB0aGF0IHdpbGwgc2VydmUgYXMgdGhpcyBzdGFjaydzIHBhcmVudCBpbiB0aGUgY29uc3RydWN0IHRyZWUuXG4gICAgICogQHBhcmFtIGlkIEEgbmFtZSB0byBiZSBhc3NvY2lhdGVkIHdpdGggdGhlIHN0YWNrIGFuZCB1c2VkIGluIHJlc291cmNlIG5hbWluZy4gTXVzdCBiZSB1bmlxdWVcbiAgICAgKiB3aXRoaW4gdGhlIGNvbnRleHQgb2YgJ3Njb3BlJy5cbiAgICAgKiBAcGFyYW0gcHJvcHMgQXJndW1lbnRzIHJlbGF0ZWQgdG8gdGhlIGNvbmZpZ3VyYXRpb24gb2YgdGhlIHJlc291cmNlLlxuICAgICAqL1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogU3lzdGVtUmVzb2x2ZXJSdWxlUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIGRvbWFpbk5hbWU6IHByb3BzLmRvbWFpbk5hbWUsXG4gICAgICBydWxlTmFtZTogcHJvcHMucnVsZU5hbWUsXG4gICAgICBydWxlVHlwZTogUmVzb2x2ZXJSdWxlVHlwZS5TWVNURU0sXG4gICAgfSk7XG4gIH1cbn0iXX0=