"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudfrontLogsBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const glue_1 = require("../glue");
const glue_tables_1 = require("../glue-tables");
const raw_bucket_1 = require("./private/raw-bucket");
class CloudfrontLogsBucket extends raw_bucket_1.RawBucket {
    /**
       * Creates a new instance of the ElbLogsBucket class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            bucketEncryption: {
                serverSideEncryptionConfiguration: [
                    {
                        serverSideEncryptionByDefault: {
                            sseAlgorithm: 'AES256',
                        },
                    },
                ],
            },
            bucketName: props.bucketName ?? aws_cdk_lib_1.PhysicalName.GENERATE_IF_NEEDED,
            publicAccessBlockConfiguration: {
                blockPublicAcls: true,
                blockPublicPolicy: true,
                ignorePublicAcls: true,
                restrictPublicBuckets: true,
            },
            versioningConfiguration: {
                status: 'Enabled',
            },
        });
        this.createQueries = props.createQueries;
        this.friendlyQueryNames = props.friendlyQueryNames;
        this.database = props.database ?? new glue_1.Database(this, 'database', {
            description: 'Database for storing ELB access logs',
        });
        this.table = new glue_tables_1.CloudfrontLogsTable(this, 'table', {
            bucket: this,
            createQueries: this.createQueries,
            database: this.database,
            friendlyQueryNames: this.friendlyQueryNames,
            name: props.tableName,
        });
    }
}
exports.CloudfrontLogsBucket = CloudfrontLogsBucket;
_a = JSII_RTTI_SYMBOL_1;
CloudfrontLogsBucket[_a] = { fqn: "cdk-extensions.s3_buckets.CloudfrontLogsBucket", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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