/**
 * Provides a wrapper around the accepted values for the IAM Identity Center
 * [Assignment.PrincipalType attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-assignment.html#cfn-sso-assignment-principaltype).
 *
 * Accepted values are provided as static properties that can be used when
 * configuring an assignment.
 */
export declare class IdentityCenterPrincipalType {
    /**
       * An IAM Identity Center group.
       */
    static readonly GROUP: IdentityCenterPrincipalType;
    /**
       * An IAM Identity Center user.
       */
    static readonly USER: IdentityCenterPrincipalType;
    /**
       * An escape hatch method that allows specifying a custom principal types in
       * the even more options are added and the provided static types are yet to
       * catch up.
       *
       * It is recommended that the provided static types be used when possible
       * instead of calling `of`.
       *
       * @param name The name for a type of IAM Identity Center Principal.
       */
    static of(name: string): IdentityCenterPrincipalType;
    /**
       * The name for a type of IAM Identity Center Principal.
       */
    readonly name: string;
    /**
       * Creates a new instance of the IdentityCenterPrincipalType class.
       *
       * @param name The name for a type of IAM Identity Center Principal.
       */
    private constructor();
}
/**
 * Represents an entity that can be granted permissions via IAM Identity
 * Center.
 */
export interface IIdentityCenterPrincipal {
    /**
       * The unique ID that identifies the entity withing IAM Identity Center.
       */
    readonly principalId: string;
    /**
       * The type of entity being represented.
       */
    readonly principalType: IdentityCenterPrincipalType;
}
