"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.User = exports.UserBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const identity_center_principal_1 = require("./lib/identity-center-principal");
class UserBase extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        this.principalType = identity_center_principal_1.IdentityCenterPrincipalType.USER;
    }
}
exports.UserBase = UserBase;
_a = JSII_RTTI_SYMBOL_1;
UserBase[_a] = { fqn: "cdk-extensions.sso.UserBase", version: "0.0.12" };
class User {
    static fromUserId(scope, id, userId) {
        class Import extends UserBase {
            constructor() {
                super(scope, id);
                this.principalId = userId;
                this.userId = userId;
            }
        }
        return new Import();
    }
}
exports.User = User;
_b = JSII_RTTI_SYMBOL_1;
User[_b] = { fqn: "cdk-extensions.sso.User", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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