import { Stack, StackProps } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { FlowLogFormat } from '../ec2';
import { Database } from '../glue';
import { AlbLogsBucket, CloudfrontLogsBucket, CloudtrailBucket, FlowLogsBucket, S3AccessLogsBucket, SesLogsBucket, WafLogsBucket } from '../s3-buckets';
/**
 * Configuration for the demo service stack.
 */
export interface AwsLoggingStackProps extends StackProps {
    readonly albLogsBucket?: AlbLogsBucket;
    readonly cloudfrontLogsBucket?: CloudfrontLogsBucket;
    readonly cloudtrailLogsBucket?: CloudtrailBucket;
    readonly databaseName?: string;
    readonly flowLogsBucket?: FlowLogsBucket;
    readonly flowLogsFormat?: FlowLogFormat;
    readonly friendlyQueryNames?: boolean;
    readonly sesLogsBucket?: SesLogsBucket;
    readonly standardizeNames?: boolean;
    readonly wafLogsBucket?: WafLogsBucket;
}
/**
 * Creates a demo web service running in Fargate that is accessible through an application load balancer.
 * The demo service serves a generic "Welcome to nginx" page.
 *
 * The service can be accessed remotely using ECS Exec. For details see the documentation at:
 * https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-exec.html#ecs-exec-running-commands
 */
export declare class AwsLoggingStack extends Stack {
    readonly databaseName: string;
    readonly flowLogsFormat: FlowLogFormat;
    readonly friendlyQueryNames?: boolean;
    readonly standardizeNames: boolean;
    readonly albLogsBucket: AlbLogsBucket;
    readonly cloudfrontLogsBucket: CloudfrontLogsBucket;
    readonly cloudtrailLogsBucket: CloudtrailBucket;
    readonly database: Database;
    readonly flowLogsBucket: FlowLogsBucket;
    readonly s3AccessLogsBucket: S3AccessLogsBucket;
    readonly sesLogsBucket: SesLogsBucket;
    readonly wafLogsBucket: WafLogsBucket;
    constructor(scope: Construct, id: string, props?: AwsLoggingStackProps);
}
