"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLoggingStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ec2_1 = require("../ec2");
const glue_1 = require("../glue");
const s3_buckets_1 = require("../s3-buckets");
/**
 * Creates a demo web service running in Fargate that is accessible through an application load balancer.
 * The demo service serves a generic "Welcome to nginx" page.
 *
 * The service can be accessed remotely using ECS Exec. For details see the documentation at:
 * https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-exec.html#ecs-exec-running-commands
 */
class AwsLoggingStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        this.databaseName = props.databaseName ?? 'awslogs';
        this.flowLogsFormat = props.flowLogsFormat ?? ec2_1.FlowLogFormat.V2;
        this.friendlyQueryNames = props.friendlyQueryNames ?? props.standardizeNames ?? true;
        this.standardizeNames = props.standardizeNames ?? true;
        this.database = new glue_1.Database(this, 'database', {
            name: this.databaseName,
        });
        this.s3AccessLogsBucket = new s3_buckets_1.S3AccessLogsBucket(this, 's3-access-logs-bucket', {
            bucketName: this.standardizeNames ? `aws-s3-access-logs-${this.account}-${this.region}` : undefined,
            database: this.database,
            friendlyQueryNames: this.friendlyQueryNames,
            tableName: 's3_access_logs',
        });
        this.albLogsBucket = props.albLogsBucket ?? new s3_buckets_1.AlbLogsBucket(this, 'alb-logs-bucket', {
            bucketName: this.standardizeNames ? `aws-alb-logs-${this.account}-${this.region}` : undefined,
            database: this.database,
            friendlyQueryNames: this.friendlyQueryNames,
            tableName: 'alb_logs',
        });
        this.cloudfrontLogsBucket = props.cloudfrontLogsBucket ?? new s3_buckets_1.CloudfrontLogsBucket(this, 'cloudfront-logs-bucket', {
            bucketName: this.standardizeNames ? `aws-cloudfront-logs-${this.account}-${this.region}` : undefined,
            database: this.database,
            friendlyQueryNames: this.friendlyQueryNames,
            tableName: 'cloudfront_logs',
        });
        this.cloudtrailLogsBucket = props.cloudtrailLogsBucket ?? new s3_buckets_1.CloudtrailBucket(this, 'cloudtail-logs-bucket', {
            bucketName: this.standardizeNames ? `aws-cloudtrail-logs-${this.account}-${this.region}` : undefined,
            database: this.database,
            friendlyQueryNames: this.friendlyQueryNames,
            tableName: 'cloudtrail_logs',
        });
        this.flowLogsBucket = props.flowLogsBucket ?? new s3_buckets_1.FlowLogsBucket(this, 'flow-logs-bucket', {
            bucketName: this.standardizeNames ? `aws-flow-logs-${this.account}-${this.region}` : undefined,
            database: this.database,
            format: this.flowLogsFormat,
            friendlyQueryNames: this.friendlyQueryNames,
            tableName: 'flow_logs',
        });
        this.sesLogsBucket = props.sesLogsBucket ?? new s3_buckets_1.SesLogsBucket(this, 'ses-logs-bucket', {
            bucketName: this.standardizeNames ? `aws-ses-logs-${this.account}-${this.region}` : undefined,
            database: this.database,
            friendlyQueryNames: this.friendlyQueryNames,
            tableName: 'ses_logs',
        });
        this.wafLogsBucket = props.wafLogsBucket ?? new s3_buckets_1.WafLogsBucket(this, 'waf-logs-bucket', {
            bucketName: this.standardizeNames ? `aws-waf-logs-${this.account}-${this.region}` : undefined,
            database: this.database,
            friendlyQueryNames: this.friendlyQueryNames,
            tableName: 'waf_logs',
        });
        this.s3AccessLogsBucket.addLoggingAspect(this);
    }
}
exports.AwsLoggingStack = AwsLoggingStack;
_a = JSII_RTTI_SYMBOL_1;
AwsLoggingStack[_a] = { fqn: "cdk-extensions.stacks.AwsLoggingStack", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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