import { aws_elasticache as elasticache, aws_memorydb as memorydb, aws_ec2 as ec2, StackProps, IResolvable } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface RedisDBProps extends StackProps {
    readonly existingVpc?: ec2.IVpc;
    readonly existingSecurityGroup?: ec2.ISecurityGroup;
    readonly existingSubnetGroupName?: string;
    readonly atRestEncryptionEnabled?: boolean | IResolvable;
    readonly transitEncryptionEnabled?: boolean | IResolvable;
    readonly engineVersion?: string;
    readonly memoryAutoscalingTarget?: number;
    readonly replicasCpuAutoscalingTarget?: number;
    readonly nodesCpuAutoscalingTarget?: number;
    readonly nodes?: number;
    readonly nodeType?: string;
    readonly replicas?: number;
    readonly authToken?: string;
    readonly subnetGroupName?: string;
}
export declare class RedisDB extends Construct {
    readonly replicationGroup: elasticache.CfnReplicationGroup;
    constructor(scope: Construct, id: string, props?: RedisDBProps);
}
export declare class MemoryDB extends Construct {
    readonly cluster: memorydb.CfnCluster;
    constructor(scope: Construct, id: string, props?: RedisDBProps);
}
