"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MemoryDB = exports.RedisDB = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
function setupVpc(parent, props) {
    return props.existingVpc ?? new aws_cdk_lib_1.aws_ec2.Vpc(parent, 'Vpc', {
        subnetConfiguration: [
            {
                cidrMask: 24,
                name: 'Public Subnet',
                subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.PUBLIC,
            },
            {
                cidrMask: 24,
                name: 'Isolated Subnet',
                subnetType: aws_cdk_lib_1.aws_ec2.SubnetType.ISOLATED,
            },
        ],
    });
}
class RedisDB extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        let isolatedSubnets = [];
        let redisVpc = setupVpc(this, props);
        redisVpc.isolatedSubnets.forEach(function (value) {
            isolatedSubnets.push(value.subnetId);
        });
        if (isolatedSubnets.length == 0) {
            redisVpc.privateSubnets.forEach(function (value) {
                isolatedSubnets.push(value.subnetId);
            });
        }
        const ecSecurityGroup = props.existingSecurityGroup ?? new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, id + '-RedisDB-SG', {
            vpc: redisVpc,
            description: 'SecurityGroup associated with RedisDB Cluster ' + id,
            allowAllOutbound: false,
        });
        let groupName;
        let ecSubnetGroup;
        if (!props.existingSubnetGroupName) {
            ecSubnetGroup = new aws_cdk_lib_1.aws_elasticache.CfnSubnetGroup(this, id + '-RedisDB-SubnetGroup', {
                description: 'RedisDB Subnet Group',
                subnetIds: isolatedSubnets,
                cacheSubnetGroupName: props.subnetGroupName || 'RedisDBSubnetGroup',
            });
            groupName = ecSubnetGroup.cacheSubnetGroupName;
        }
        else {
            groupName = props.existingSubnetGroupName;
        }
        let elasticacheReplicationGroupName = id + '-RedisDB';
        let redis_cluster = new aws_cdk_lib_1.aws_elasticache.CfnReplicationGroup(this, elasticacheReplicationGroupName, {
            numNodeGroups: props.nodes || 1,
            cacheNodeType: props.nodeType || 'cache.m6g.large',
            engine: 'Redis',
            multiAzEnabled: false,
            autoMinorVersionUpgrade: false,
            cacheParameterGroupName: 'default.redis6.x.cluster.on',
            engineVersion: props.engineVersion ?? '6.x',
            cacheSubnetGroupName: groupName,
            securityGroupIds: [ecSecurityGroup.securityGroupId],
            replicationGroupDescription: 'RedisDB setup by CDK',
            atRestEncryptionEnabled: props.atRestEncryptionEnabled,
            transitEncryptionEnabled: props.transitEncryptionEnabled,
            replicasPerNodeGroup: props.replicas || 0,
            authToken: props.authToken,
        });
        this.replicationGroup = redis_cluster;
        if (!props.existingSubnetGroupName) {
            redis_cluster.node.addDependency(ecSubnetGroup);
        }
        if (typeof props.memoryAutoscalingTarget == 'number') {
            const target = new aws_cdk_lib_1.aws_applicationautoscaling.ScalableTarget(this, 'ScalableTarget', {
                serviceNamespace: aws_cdk_lib_1.aws_applicationautoscaling.ServiceNamespace.ELASTICACHE,
                resourceId: 'replication-group/' + redis_cluster.ref,
                scalableDimension: 'elasticache:replication-group:NodeGroups',
                maxCapacity: props.nodes || 1 * 3,
                minCapacity: props.nodes || 1,
            });
            target.scaleToTrackMetric('MemTracking', {
                targetValue: props.memoryAutoscalingTarget,
                predefinedMetric: aws_cdk_lib_1.aws_applicationautoscaling.PredefinedMetric.ELASTICACHE_DATABASE_MEMORY_USAGE_COUNTED_FOR_EVICT_PERCENTAGE,
            });
        }
        else if (typeof props.replicasCpuAutoscalingTarget == 'number') {
            const target = new aws_cdk_lib_1.aws_applicationautoscaling.ScalableTarget(this, 'ScalableTarget', {
                serviceNamespace: aws_cdk_lib_1.aws_applicationautoscaling.ServiceNamespace.ELASTICACHE,
                resourceId: 'replication-group/' + redis_cluster.ref,
                scalableDimension: 'elasticache:replication-group:group:Replicas',
                maxCapacity: props.nodes || 1 * 3,
                minCapacity: props.nodes || 1,
            });
            target.scaleToTrackMetric('CpuTracking', {
                targetValue: props.replicasCpuAutoscalingTarget,
                predefinedMetric: aws_cdk_lib_1.aws_applicationautoscaling.PredefinedMetric.ELASTICACHE_PRIMARY_ENGINE_CPU_UTILIZATION,
            });
        }
        else if (typeof props.nodesCpuAutoscalingTarget == 'number') {
            const target = new aws_cdk_lib_1.aws_applicationautoscaling.ScalableTarget(this, 'ScalableTarget', {
                serviceNamespace: aws_cdk_lib_1.aws_applicationautoscaling.ServiceNamespace.ELASTICACHE,
                resourceId: 'replication-group/' + redis_cluster.ref,
                scalableDimension: 'elasticache:replication-group:NodeGroups',
                maxCapacity: props.nodes || 1 * 3,
                minCapacity: props.nodes || 1,
            });
            target.scaleToTrackMetric('CpuTracking', {
                targetValue: props.nodesCpuAutoscalingTarget,
                predefinedMetric: aws_cdk_lib_1.aws_applicationautoscaling.PredefinedMetric.ELASTICACHE_PRIMARY_ENGINE_CPU_UTILIZATION,
            });
        }
    }
}
exports.RedisDB = RedisDB;
_a = JSII_RTTI_SYMBOL_1;
RedisDB[_a] = { fqn: "cdk-redisdb.RedisDB", version: "0.0.15" };
class MemoryDB extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        let isolatedSubnets = [];
        let redisVpc = setupVpc(this, props);
        redisVpc.isolatedSubnets.forEach(function (value) {
            isolatedSubnets.push(value.subnetId);
        });
        const ecSecurityGroup = props.existingSecurityGroup ?? new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, id + '-RedisDB-SG', {
            vpc: redisVpc,
            description: 'SecurityGroup associated with RedisDB Cluster ' + id,
            allowAllOutbound: false,
        });
        let groupName;
        let ecSubnetGroup;
        if (!props.existingSubnetGroupName) {
            ecSubnetGroup = new aws_cdk_lib_1.aws_memorydb.CfnSubnetGroup(this, id + '-RedisDB-SubnetGroup', {
                description: 'RedisDB Subnet Group',
                subnetIds: isolatedSubnets,
                subnetGroupName: props.subnetGroupName || 'memorydbsubnetgroup',
            });
            groupName = ecSubnetGroup.subnetGroupName;
        }
        else {
            groupName = props.existingSubnetGroupName;
        }
        /*
        const cfnUser = new memorydb.CfnUser(this, 'memorydb-user', {
          accessString: 'on ~* +@all',
          authenticationMode: {"Passwords":["*****hunter2*****"],"Type":"password"},
          userName: 'admin',
        });
        const cfnACL = new memorydb.CfnACL(this, 'memorydb-acl', {
          aclName: 'myacl',
          userNames: ['admin'],
        });
        */
        const memorydb_cluster = new aws_cdk_lib_1.aws_memorydb.CfnCluster(this, 'memorydb', {
            aclName: 'open-access',
            clusterName: 'clustername',
            nodeType: props.nodeType || 'db.t4g.small',
            autoMinorVersionUpgrade: false,
            description: 'description',
            engineVersion: props.engineVersion ?? '6.2',
            numShards: props.nodes || 1,
            numReplicasPerShard: props.replicas || 0,
            securityGroupIds: [ecSecurityGroup.securityGroupId],
            subnetGroupName: groupName,
            tlsEnabled: true,
        });
        if (!props.existingSubnetGroupName) {
            memorydb_cluster.node.addDependency(ecSubnetGroup);
        }
        this.cluster = memorydb_cluster;
        //memorydb_cluster.node.addDependency(cfnACL);
        //cfnACL.node.addDependency(cfnUser);
    }
}
exports.MemoryDB = MemoryDB;
_b = JSII_RTTI_SYMBOL_1;
MemoryDB[_b] = { fqn: "cdk-redisdb.MemoryDB", version: "0.0.15" };
//# sourceMappingURL=data:application/json;base64,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