# coding: utf-8

"""
    DocRaptor

    A native client library for the DocRaptor HTML to PDF/XLS service.  # noqa: E501

    OpenAPI spec version: 2.0.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from docraptor.api_client import ApiClient


class DocApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_async_doc(self, doc, **kwargs):  # noqa: E501
        """create_async_doc  # noqa: E501

        Creates a document asynchronously. You must use a callback url or the returned status id and the status API to find out when it completes. Then use the download API to get the document.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_async_doc(doc, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Doc doc: The document to be created. (required)
        :return: AsyncDoc
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_async_doc_with_http_info(doc, **kwargs)  # noqa: E501
        else:
            (data) = self.create_async_doc_with_http_info(doc, **kwargs)  # noqa: E501
            return data

    def create_async_doc_with_http_info(self, doc, **kwargs):  # noqa: E501
        """create_async_doc  # noqa: E501

        Creates a document asynchronously. You must use a callback url or the returned status id and the status API to find out when it completes. Then use the download API to get the document.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_async_doc_with_http_info(doc, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Doc doc: The document to be created. (required)
        :return: AsyncDoc
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['doc']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_async_doc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'doc' is set
        if ('doc' not in params or
                params['doc'] is None):
            raise ValueError("Missing the required parameter `doc` when calling `create_async_doc`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'doc' in params:
            body_params = params['doc']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml', 'application/pdf', 'application/vnd.ms-excel', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/async_docs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncDoc',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_doc(self, doc, **kwargs):  # noqa: E501
        """create_doc  # noqa: E501

        Creates a document synchronously.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_doc(doc, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Doc doc: The document to be created. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_doc_with_http_info(doc, **kwargs)  # noqa: E501
        else:
            (data) = self.create_doc_with_http_info(doc, **kwargs)  # noqa: E501
            return data

    def create_doc_with_http_info(self, doc, **kwargs):  # noqa: E501
        """create_doc  # noqa: E501

        Creates a document synchronously.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_doc_with_http_info(doc, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Doc doc: The document to be created. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['doc']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_doc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'doc' is set
        if ('doc' not in params or
                params['doc'] is None):
            raise ValueError("Missing the required parameter `doc` when calling `create_doc`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'doc' in params:
            body_params = params['doc']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml', 'application/pdf', 'application/vnd.ms-excel', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/docs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_hosted_async_doc(self, doc, **kwargs):  # noqa: E501
        """create_hosted_async_doc  # noqa: E501

        Creates a hosted document asynchronously. You must use a callback url or the returned status id and the status API to find out when it completes. Then use the download API to get the document.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_hosted_async_doc(doc, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Doc doc: The document to be created. (required)
        :return: AsyncDoc
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_hosted_async_doc_with_http_info(doc, **kwargs)  # noqa: E501
        else:
            (data) = self.create_hosted_async_doc_with_http_info(doc, **kwargs)  # noqa: E501
            return data

    def create_hosted_async_doc_with_http_info(self, doc, **kwargs):  # noqa: E501
        """create_hosted_async_doc  # noqa: E501

        Creates a hosted document asynchronously. You must use a callback url or the returned status id and the status API to find out when it completes. Then use the download API to get the document.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_hosted_async_doc_with_http_info(doc, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Doc doc: The document to be created. (required)
        :return: AsyncDoc
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['doc']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_hosted_async_doc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'doc' is set
        if ('doc' not in params or
                params['doc'] is None):
            raise ValueError("Missing the required parameter `doc` when calling `create_hosted_async_doc`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'doc' in params:
            body_params = params['doc']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml', 'application/pdf', 'application/vnd.ms-excel', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/hosted_async_docs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AsyncDoc',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_hosted_doc(self, doc, **kwargs):  # noqa: E501
        """create_hosted_doc  # noqa: E501

        Creates a hosted document synchronously.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_hosted_doc(doc, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Doc doc: The document to be created. (required)
        :return: DocStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_hosted_doc_with_http_info(doc, **kwargs)  # noqa: E501
        else:
            (data) = self.create_hosted_doc_with_http_info(doc, **kwargs)  # noqa: E501
            return data

    def create_hosted_doc_with_http_info(self, doc, **kwargs):  # noqa: E501
        """create_hosted_doc  # noqa: E501

        Creates a hosted document synchronously.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_hosted_doc_with_http_info(doc, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Doc doc: The document to be created. (required)
        :return: DocStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['doc']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_hosted_doc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'doc' is set
        if ('doc' not in params or
                params['doc'] is None):
            raise ValueError("Missing the required parameter `doc` when calling `create_hosted_doc`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'doc' in params:
            body_params = params['doc']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml', 'application/pdf', 'application/vnd.ms-excel', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/hosted_docs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def expire(self, id, **kwargs):  # noqa: E501
        """expire  # noqa: E501

        Expires a previously created hosted doc.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.expire(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The download_id returned from status request or hosted document response. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.expire_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.expire_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def expire_with_http_info(self, id, **kwargs):  # noqa: E501
        """expire  # noqa: E501

        Expires a previously created hosted doc.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.expire_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The download_id returned from status request or hosted document response. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method expire" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `expire`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml', 'application/pdf', 'application/vnd.ms-excel', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/expire/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_async_doc(self, id, **kwargs):  # noqa: E501
        """get_async_doc  # noqa: E501

        Downloads a finished document.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_async_doc(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The download_id returned from an async status request or callback. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_async_doc_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_async_doc_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_async_doc_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_async_doc  # noqa: E501

        Downloads a finished document.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_async_doc_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The download_id returned from an async status request or callback. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_async_doc" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_async_doc`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml', 'application/pdf', 'application/vnd.ms-excel', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/download/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_async_doc_status(self, id, **kwargs):  # noqa: E501
        """get_async_doc_status  # noqa: E501

        Check on the status of an asynchronously created document.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_async_doc_status(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The status_id returned when creating an asynchronous document. (required)
        :return: DocStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_async_doc_status_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_async_doc_status_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_async_doc_status_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_async_doc_status  # noqa: E501

        Check on the status of an asynchronously created document.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_async_doc_status_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The status_id returned when creating an asynchronous document. (required)
        :return: DocStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_async_doc_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_async_doc_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml', 'application/pdf', 'application/vnd.ms-excel', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/status/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
