from stograde.common.parse_commit_msg_for_assignments import parse_commit_msg_for_assignments
sample = parse_commit_msg_for_assignments


def test_parse_commit_msg_for_assignments():
    assert sample('''[hw1] rename secondComent to secondComment''') == [('hw', '1')]
    assert sample('''Add cleaned-up StarTrekDVDDriver code for HW21''') == [('hw', '21')]
    assert sample('''add lab 5,6,7,10''') == [('lab', '5')]
    assert sample('''added comments to hw8''') == [('hw', '8')]
    assert sample('''added DVD.h and DVD.cpp to hw21''') == [('hw', '21')]
    assert sample('''Added lab4 Part B''') == [('lab', '4')]
    assert sample('''Added louder1 from Lab 3 Part D''') == [('lab', '3')]
    assert sample('''adjusted hw10''') == [('hw', '10')]
    assert sample('''adjusted hw6''') == [('hw', '6')]
    assert sample('''adjusted hw7''') == [('hw', '7')]
    assert sample('''Class implementations - Lab 8 part B: Shape, Rectangle, Circle''') == [('lab', '8')]
    assert sample('''commiting partial lab5 for now''') == [('lab', '5')]
    assert sample('''committing lab8 Circle Rectangle Shape''') == [('lab', '8')]
    assert sample('''Complete - Lab 8 part B: ShapeDriver1 ShapeDriver2''') == [('lab', '8')]
    assert sample('''Complete - Lab 8 part C: proto-draw with shape drawing''') == [('lab', '8')]
    assert sample('''Complete DVD class implementation - Lab 7 part A: DVD class''') == [('lab', '7')]
    assert sample('''complete Hw20 submit''') == [('hw', '20')]
    assert sample('''complete Lab 10 part A''') == [('lab', '10')]
    assert sample('''Complete Lab 10 part A: make test (gitignore ignored the *.out files)''') == [('lab', '10')]
    assert sample('''Complete Lab 10 part A: make tests''') == [('lab', '10')]
    assert sample('''Complete Lab 10 part B''') == [('lab', '10')]
    assert sample('''COmplete lab 10 part B''') == [('lab', '10')]
    assert sample('''Complete Lab 10 part B: OpenGL examples''') == [('lab', '10')]
    assert sample('''Complete Lab 10 part C: Doxygen specs''') == [('lab', '10')]
    assert sample('''complete lab 10 part C: Doxygen specs''') == [('lab', '10')]
    assert sample('''Complete Lab 11''') == [('lab', '11')]
    assert sample('''Complete Lab 3 Sound''') == [('lab', '3')]
    assert sample('''Complete Lab 8 part A, part B: Shape''') == [('lab', '8')]
    assert sample('''Complete Lab 8 part A: ColorPoint2.h''') == [('lab', '8')]
    assert sample('''complete Lab 9 part A:Shape.dia''') == [('lab', '9')]
    assert sample('''Complete Lab10 part B: openGL examples''') == [('lab', '10')]
    assert sample('''Complete Lab10 part C: DOxygen specs''') == [('lab', '10')]
    assert sample('''complete lab5 Part B''') == [('lab', '5')]
    assert sample('''complete Lab8 part A: colorpoint2.h''') == [('lab', '8')]
    assert sample('''Complete lab9 part A: lab9.dia''') == [('lab', '9'), ('lab', '9')]
    assert sample('''Complete Lab9 part A: laundry.dia''') == [('lab', '9')]
    assert sample('''error in part B of Lab 12, cann't get read in file to work.''') == [('lab', '12')]
    assert sample('''final submit hw18: corrected DVD.h''') == [('hw', '18')]
    assert sample('''first part of lab 7''') == [('lab', '7')]
    assert sample('''fix .gitignore to not ignore hw8/''') == [('hw', '8')]
    assert sample('''fix lab2 gitignore''') == [('lab', '2')]
    assert sample('''Fixed Lab 1, compiled with the gcc compiler that comes with OS X on my local machine''') == [('lab', '1')]
    assert sample('''git submit partial lab8: all up to B:6-complete''') == [('lab', '8')]
    assert sample('''had extension, submitting lab5 complete''') == [('lab', '5')]
    assert sample('''homework 1''') == [('hw', '1')]
    assert sample('''homework 10 complete''') == [('hw', '10')]
    assert sample('''homework 11 complete''') == [('hw', '11')]
    assert sample('''homework 12 complete''') == [('hw', '12')]
    assert sample('''Homework 12 complete''') == [('hw', '12')]
    assert sample('''Homework 13 complete''') == [('hw', '13')]
    assert sample('''homework 13 complete''') == [('hw', '13')]
    assert sample('''Homework 14 to section B''') == [('hw', '14')]
    assert sample('''homework 8''') == [('hw', '8')]
    assert sample('''homework 8 complete''') == [('hw', '8')]
    assert sample('''homework1 finished''') == [('hw', '1')]
    assert sample('''homework11 complete''') == [('hw', '11')]
    assert sample('''homework9 complete''') == [('hw', '9')]
    assert sample('''hw 11 complete''') == [('hw', '11')]
    assert sample('''hw 15 complete''') == [('hw', '15')]
    assert sample('''hw 17 exercise files''') == [('hw', '17')]
    assert sample('''hw 19 complete''') == [('hw', '19')]
    assert sample('''hw 19 part C complete''') == [('hw', '19')]
    assert sample('''hw1 complete''') == [('hw', '1')]
    assert sample('''hw1 submit completed''') == [('hw', '1')]
    assert sample('''hw10 complete''') == [('hw', '10')]
    assert sample('''hw14 complete''') == [('hw', '14')]
    assert sample('''hw15 complete''') == [('hw', '15')]
    assert sample('''hw15 examples''') == [('hw', '15')]
    assert sample('''hw16 complete''') == [('hw', '16')]
    assert sample('''hw17 complete''') == [('hw', '17')]
    assert sample('''HW18 complete''') == [('hw', '18')]
    assert sample('''hw18 complete''') == [('hw', '18')]
    assert sample('''hw18 with all constructors''') == [('hw', '18')]
    assert sample('''hw18 with makecopy''') == [('hw', '18')]
    assert sample('''hw18, now with get methods''') == [('hw', '18')]
    assert sample('''HW19 C: final commit post-increment''') == [('hw', '19')]
    assert sample('''HW19 C: pre-increment operator + Makefile''') == [('hw', '19')]
    assert sample('''hw19 complete''') == [('hw', '19')]
    assert sample('''hw19 part C''') == [('hw', '19')]
    assert sample('''hw19, part C complete''') == [('hw', '19')]
    assert sample('''hw20 complete''') == [('hw', '20')]
    assert sample('''hw21 - late, I know''') == [('hw', '21')]
    assert sample('''hw21 almost complete, problem with indexing''') == [('hw', '21')]
    assert sample('''hw21 complete''') == [('hw', '21')]
    assert sample('''hw22 complete''') == [('hw', '22')]
    assert sample('''hw23 complete''') == [('hw', '23')]
    assert sample('''hw23 submit almost complete: a couple bugs''') == [('hw', '23')]
    assert sample('''hw24''') == [('hw', '24')]
    assert sample('''hw24 fixed''') == [('hw', '24')]
    assert sample('''hw6 final submit''') == [('hw', '6')]
    assert sample('''hw7 complpete''') == [('hw', '7')]
    assert sample('''lab 10 complete''') == [('lab', '10')]
    assert sample('''lab 11''') == [('lab', '11')]
    assert sample('''lab 11 complete''') == [('lab', '11')]
    assert sample('''lab 12 complete''') == [('lab', '12')]
    assert sample('''lab 12 part A complete''') == [('lab', '12')]
    assert sample('''Lab 12 part A complete''') == [('lab', '12')]
    assert sample('''lab 12 part A, added ACK mesages''') == [('lab', '12')]
    assert sample('''lab 12 part A, added ACK messages''') == [('lab', '12')]
    assert sample('''lab 12 part A, added ACK messages updated''') == [('lab', '12')]
    assert sample('''lab 3''') == [('lab', '3')]
    assert sample('''Lab 3 Part C''') == [('lab', '3')]
    assert sample('''Lab 3 resubmit attempt''') == [('lab', '3')]
    assert sample('''Lab 3 with octave1.cpp''') == [('lab', '3')]
    assert sample('''Lab 3 with octaveup1.cpp''') == [('lab', '3')]
    assert sample('''Lab 4 complete''') == [('lab', '4')]
    assert sample('''lab 4 part b''') == [('lab', '4')]
    assert sample('''lab 4 submit''') == [('lab', '4')]
    assert sample('''Lab 4 through part B''') == [('lab', '4')]
    assert sample('''Lab 5 complete''') == [('lab', '5')]
    assert sample('''Lab 6 complete''') == [('lab', '6')]
    assert sample('''Lab 6 part A''') == [('lab', '6')]
    assert sample('''Lab 6 Part A''') == [('lab', '6')]
    assert sample('''Lab 6 part B''') == [('lab', '6')]
    assert sample('''Lab 6 Part B''') == [('lab', '6')]
    assert sample('''Lab 6 part B, start of C''') == [('lab', '6')]
    assert sample('''Lab 6 part C''') == [('lab', '6')]
    assert sample('''Lab 6 Part C''') == [('lab', '6')]
    assert sample('''Lab 6 part D''') == [('lab', '6')]
    assert sample('''Lab 6 Part D''') == [('lab', '6')]
    assert sample('''Lab 6 part E''') == [('lab', '6')]
    assert sample('''Lab 6 part F''') == [('lab', '6')]
    assert sample('''Lab 6 Part F''') == [('lab', '6')]
    assert sample('''Lab 6 parts A,B''') == [('lab', '6')]
    assert sample('''lab 7 complete''') == [('lab', '7')]
    assert sample('''Lab 7 part B: Makefile''') == [('lab', '7')]
    assert sample('''lab 7 part b: makefile''') == [('lab', '7')]
    assert sample('''Lab 7 part C''') == [('lab', '7')]
    assert sample('''Lab 7 Part C, fixed proto-game''') == [('lab', '7')]
    assert sample('''Lab 7 part C: proto-game''') == [('lab', '7')]
    assert sample('''lab 7 part c: proto-game''') == [('lab', '7')]
    assert sample('''Lab 7 part D: DVDArray''') == [('lab', '7')]
    assert sample('''Lab 7 pert B: Makefile''') == [('lab', '7')]
    assert sample('''Lab 8 part B: classes shape rectangle circle''') == [('lab', '8')]
    assert sample('''Lab 8 Part C, early proto-draw''') == [('lab', '8')]
    assert sample('''Lab 8 part C: early version of proto-draw''') == [('lab', '8')]
    assert sample('''Lab 8: committing Part A, some bugs still present''') == [('lab', '8')]
    assert sample('''Lab 9 complete''') == [('lab', '9')]
    assert sample('''lab 9 part a complete''') == [('lab', '9')]
    assert sample('''lab 9 part c''') == [('lab', '9')]
    assert sample('''Lab 9 up to D11''') == [('lab', '9')]
    assert sample('''lab12 done''') == [('lab', '12')]
    assert sample('''lab12 part a done''') == [('lab', '12')]
    assert sample('''Lab12 part B''') == [('lab', '12')]
    assert sample('''lab4 Part A complete''') == [('lab', '4')]
    assert sample('''lab4 Part B complete''') == [('lab', '4')]
    assert sample('''lab5 up until c''') == [('lab', '5')]
    assert sample('''lab6 partway through step E''') == [('lab', '6')]
    assert sample('''Lab7 part B: Makefile''') == [('lab', '7')]
    assert sample('''Lab7, Part D, In Progress''') == [('lab', '7')]
    assert sample('''lab8 complete''') == [('lab', '8')]
    assert sample('''lab9 part b''') == [('lab', '9')]
    assert sample('''lab9 part B, pre-multiple objects''') == [('lab', '9')]
    assert sample('''more lab 12 part A DONE''') == [('lab', '12')]
    assert sample('''more of lab 8''') == [('lab', '8')]
    assert sample('''put lab 12 in the right folder''') == [('lab', '12')]
    assert sample('''re-submit hw23 complete''') == [('hw', '23')]
    assert sample('''rename hw3/arithmetic''') == [('hw', '3')]
    assert sample('''rename hw3/casting to miscOperators''') == [('hw', '3')]
    assert sample('''rename hw8/stddev2''') == [('hw', '8')]
    assert sample('''resubmitting because of hw10 error''') == [('hw', '10')]
    assert sample('''retry lab3 subission''') == [('lab', '3')]
    assert sample('''saving lab 2 part A''') == [('lab', '2')]
    assert sample('''saving lab 2 part B''') == [('lab', '2')]
    assert sample('''saving lab2 part b''') == [('lab', '2')]
    assert sample('''submit hw1 complete''') == [('hw', '1')]
    assert sample('''Submit hw10 complete''') == [('hw', '10')]
    assert sample('''submit hw10 complete''') == [('hw', '10')]
    assert sample('''submit hw11 complete''') == [('hw', '11')]
    assert sample('''Submit hw11 complete''') == [('hw', '11')]
    assert sample('''submit hw12 complete''') == [('hw', '12')]
    assert sample('''submit HW12 complete''') == [('hw', '12')]
    assert sample('''submit hw13 complete''') == [('hw', '13')]
    assert sample('''submit hw13 complete with doxygen''') == [('hw', '13')]
    assert sample('''submit hw14''') == [('hw', '14')]
    assert sample('''submit hw14 complete''') == [('hw', '14')]
    assert sample('''submit hw15 complete''') == [('hw', '15')]
    assert sample('''submit hw16 complete''') == [('hw', '16')]
    assert sample('''submit hw17 complete''') == [('hw', '17')]
    assert sample('''submit HW18 complete''') == [('hw', '18')]
    assert sample('''submit hw18 complete''') == [('hw', '18')]
    assert sample('''submit hw18 correct complete''') == [('hw', '18')]
    assert sample('''submit hw19''') == [('hw', '19')]
    assert sample('''submit hw19 complete''') == [('hw', '19')]
    assert sample('''submit hw19 part C''') == [('hw', '19')]
    assert sample('''submit hw2 complete''') == [('hw', '2')]
    assert sample('''submit hw20 can't get assignment operator to work properly ( operator= )''') == [('hw', '20')]
    assert sample('''submit hw20 complete''') == [('hw', '20')]
    assert sample('''submit hw21''') == [('hw', '21')]
    assert sample('''submit hw21 complete''') == [('hw', '21')]
    assert sample('''submit hw21 complete: can't compile- what am I doing wrong?''') == [('hw', '21')]
    assert sample('''submit hw21 correction complete''') == [('hw', '21')]
    assert sample('''submit HW22 complete''') == [('hw', '22')]
    assert sample('''submit hw22 complete''') == [('hw', '22')]
    assert sample('''submit hw23''') == [('hw', '23')]
    assert sample('''submit hw23 complete''') == [('hw', '23')]
    assert sample('''submit hw24''') == [('hw', '24')]
    assert sample('''submit hw24 complete''') == [('hw', '24')]
    assert sample('''submit hw24 complete- a few bugs still present''') == [('hw', '24')]
    assert sample('''submit hw25''') == [('hw', '25')]
    assert sample('''submit hw25 complete''') == [('hw', '25')]
    assert sample('''submit hw3''') == [('hw', '3')]
    assert sample('''submit hw3 complete''') == [('hw', '3')]
    assert sample('''submit hw4 complete''') == [('hw', '4')]
    assert sample('''submit hw5 complete''') == [('hw', '5')]
    assert sample('''submit hw6 complete''') == [('hw', '6')]
    assert sample('''submit hw7 complete''') == [('hw', '7')]
    assert sample('''submit hw8 complete''') == [('hw', '8')]
    assert sample('''submit hw8, save lab3''') == [('hw', '8'), ('lab', '3')]
    assert sample('''submit hw9 complete''') == [('hw', '9')]
    assert sample('''submit Lab 10 complete''') == [('lab', '10')]
    assert sample('''submit Lab 11 complete''') == [('lab', '11')]
    assert sample('''submit lab 12 complete''') == [('lab', '12')]
    assert sample('''submit lab 7 complete''') == [('lab', '7')]
    assert sample('''submit lab 8 complete''') == [('lab', '8')]
    assert sample('''submit lab10 complete''') == [('lab', '10')]
    assert sample('''submit lab11 complete''') == [('lab', '11')]
    assert sample('''submit Lab11 complete''') == [('lab', '11')]
    assert sample('''submit lab12 complete''') == [('lab', '12')]
    assert sample('''submit Lab12 complete''') == [('lab', '12')]
    assert sample('''submit lab2 A-E''') == [('lab', '2')]
    assert sample('''submit lab2 cmplete''') == [('lab', '2')]
    assert sample('''submit lab2 complete''') == [('lab', '2')]
    assert sample('''submit lab3''') == [('lab', '3')]
    assert sample('''submit lab4 all parts except C6. complete''') == [('lab', '4')]
    assert sample('''submit lab4 complete''') == [('lab', '4')]
    assert sample('''submit lab4 through part b''') == [('lab', '4')]
    assert sample('''submit lab5 complete''') == [('lab', '5')]
    assert sample('''submit lab6 A-D''') == [('lab', '6')]
    assert sample('''submit lab6 A-E complete, F:1-2 complete''') == [('lab', '6')]
    assert sample('''submit lab6 complete''') == [('lab', '6')]
    assert sample('''submit lab7 complete''') == [('lab', '7')]
    assert sample('''submit lab8 complete''') == [('lab', '8')]
    assert sample('''submit lab9 complete''') == [('lab', '9')]
    assert sample('''submit lab9 part B''') == [('lab', '9')]
    assert sample('''submit lab9 part c''') == [('lab', '9')]
    assert sample('''submit lab9 part D complete''') == [('lab', '9')]
    assert sample('''sumbit lab2 complete''') == [('lab', '2')]
    assert sample('''sumbmit lab 2''') == [('lab', '2')]
    assert sample('''this is hw 1''') == [('hw', '1')]
    assert sample('''This is my first attempt to submit lab 2''') == [('lab', '2')]
    assert sample('''this is my first attempt to turn in homework 3''') == [('hw', '3')]
    assert sample('''This is my first attempt to turn in homework 6''') == [('hw', '6')]
    assert sample('''this is my first attempt to upload homework 1''') == [('hw', '1')]
    assert sample('''This is my first attempt to upload homework 5''') == [('hw', '5')]
    assert sample('''This is my first attempt to upload homework 7because originally my homework files were stored in the SD directory, so I moved them to hw6, and manually deleted the files on stogit through the web interface''') == [('hw', '7'), ('hw', '6')]
    assert sample('''This is my revision to homework 7''') == [('hw', '7')]
    assert sample('''this is my second attempt at submittiing lab 2''') == [('lab', '2')]
    assert sample('''this is my second attempt to upload homework 1''') == [('hw', '1')]
    assert sample('''This is my second attempt to upload homework 6''') == [('hw', '6')]
