from setuptools import (
    setup,
    find_packages,
)

setup(
    name="atop",
    version="0.2.24",
    author="Aaarghhh",
    author_email="giacomo@udontknow.us",
    packages=["atop", "atop.modules"],
    package_dir={"": "src"},
    include_package_data=True,
    entry_points={"console_scripts": ["a-ton-of-privacy = atop.atop:run"]},
    url="https://github.com/aaarghhh/a_TON_of_privacy",
    license="MIT",
    description='"A TON of Privacy" formally called ATOP ... is a tool for conducting OSINT investigations on TON NFTs.',
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown",
    install_requires=[
        "beautifulsoup4==4.12.2",
        "bitarray==2.6.0",
        "bs4==0.0.1",
        "build==1.0.3",
        "certifi==2023.11.17",
        "cffi==1.16.0",
        "charset-normalizer==3.3.2",
        "colorama==0.4.6",
        "crc16==0.1.1",
        "crc32c==2.4.1",
        "idna==3.6",
        "load-dotenv==0.1.0",
        "multidict==6.0.5",
        "numpy==1.26.3",
        "packaging==23.2",
        "pyaes==1.6.1",
        "pyasn1==0.5.1",
        "pycparser==2.22",
        "pydantic==1.10.17",
        "PyNaCl==1.5.0",
        "pyproject_hooks==1.0.0",
        "PySocks==1.7.1",
        "python-dotenv==1.0.0",
        "pytonlib==0.0.61",
        "requests==2.31.0",
        "rsa==4.9",
        "soupsieve==2.5",
        "Telethon==1.33.1",
        "tonsdk==1.0.14",
        "tvm-valuetypes==0.0.12",
        "typing_extensions==4.12.2",
        "urllib3==2.1.0",
        "yarl==1.9.4"
    ],
    zip_safe=False,
)
