from django.db import models
from dataclasses import dataclass
from air_drf_relation.model_fields import AirDataClassField


@dataclass
class FilmInformation:
    budget: float
    rating: str
    description: str
    # kek: int = 1


class Actor(models.Model):
    name = models.CharField(max_length=256)


class Film(models.Model):
    name = models.CharField(max_length=256)
    release_date = models.DateField()
    information: FilmInformation = AirDataClassField(data_class=FilmInformation)
    actors = models.ManyToManyField(Actor, related_name='films')
