import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::DirectoryService::MicrosoftAD`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html
 */
export interface CfnMicrosoftADProps {
    /**
     * `AWS::DirectoryService::MicrosoftAD.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-name
     */
    readonly name: string;
    /**
     * `AWS::DirectoryService::MicrosoftAD.Password`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-password
     */
    readonly password: string;
    /**
     * `AWS::DirectoryService::MicrosoftAD.VpcSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-vpcsettings
     */
    readonly vpcSettings: CfnMicrosoftAD.VpcSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::MicrosoftAD.CreateAlias`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-createalias
     */
    readonly createAlias?: boolean | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::MicrosoftAD.Edition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-edition
     */
    readonly edition?: string;
    /**
     * `AWS::DirectoryService::MicrosoftAD.EnableSso`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-enablesso
     */
    readonly enableSso?: boolean | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::MicrosoftAD.ShortName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-shortname
     */
    readonly shortName?: string;
}
/**
 * A CloudFormation `AWS::DirectoryService::MicrosoftAD`.
 *
 * @external
 * @cloudformationResource AWS::DirectoryService::MicrosoftAD
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html
 */
export declare class CfnMicrosoftAD extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DirectoryService::MicrosoftAD";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMicrosoftAD;
    /**
     * @external
     * @cloudformationAttribute Alias
     */
    readonly attrAlias: string;
    /**
     * @external
     * @cloudformationAttribute DnsIpAddresses
     */
    readonly attrDnsIpAddresses: string[];
    /**
     * `AWS::DirectoryService::MicrosoftAD.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-name
     */
    name: string;
    /**
     * `AWS::DirectoryService::MicrosoftAD.Password`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-password
     */
    password: string;
    /**
     * `AWS::DirectoryService::MicrosoftAD.VpcSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-vpcsettings
     */
    vpcSettings: CfnMicrosoftAD.VpcSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::MicrosoftAD.CreateAlias`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-createalias
     */
    createAlias: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DirectoryService::MicrosoftAD.Edition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-edition
     */
    edition: string | undefined;
    /**
     * `AWS::DirectoryService::MicrosoftAD.EnableSso`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-enablesso
     */
    enableSso: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DirectoryService::MicrosoftAD.ShortName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-shortname
     */
    shortName: string | undefined;
    /**
     * Create a new `AWS::DirectoryService::MicrosoftAD`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMicrosoftADProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DirectoryService::MicrosoftAD`.
 *
 * @external
 * @cloudformationResource AWS::DirectoryService::MicrosoftAD
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html
 */
export declare namespace CfnMicrosoftAD {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-directoryservice-microsoftad-vpcsettings.html
     */
    interface VpcSettingsProperty {
        /**
         * `CfnMicrosoftAD.VpcSettingsProperty.SubnetIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-directoryservice-microsoftad-vpcsettings.html#cfn-directoryservice-microsoftad-vpcsettings-subnetids
         */
        readonly subnetIds: string[];
        /**
         * `CfnMicrosoftAD.VpcSettingsProperty.VpcId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-directoryservice-microsoftad-vpcsettings.html#cfn-directoryservice-microsoftad-vpcsettings-vpcid
         */
        readonly vpcId: string;
    }
}
/**
 * Properties for defining a `AWS::DirectoryService::SimpleAD`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html
 */
export interface CfnSimpleADProps {
    /**
     * `AWS::DirectoryService::SimpleAD.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-name
     */
    readonly name: string;
    /**
     * `AWS::DirectoryService::SimpleAD.Password`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-password
     */
    readonly password: string;
    /**
     * `AWS::DirectoryService::SimpleAD.Size`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-size
     */
    readonly size: string;
    /**
     * `AWS::DirectoryService::SimpleAD.VpcSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-vpcsettings
     */
    readonly vpcSettings: CfnSimpleAD.VpcSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::SimpleAD.CreateAlias`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-createalias
     */
    readonly createAlias?: boolean | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::SimpleAD.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-description
     */
    readonly description?: string;
    /**
     * `AWS::DirectoryService::SimpleAD.EnableSso`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-enablesso
     */
    readonly enableSso?: boolean | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::SimpleAD.ShortName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-shortname
     */
    readonly shortName?: string;
}
/**
 * A CloudFormation `AWS::DirectoryService::SimpleAD`.
 *
 * @external
 * @cloudformationResource AWS::DirectoryService::SimpleAD
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html
 */
export declare class CfnSimpleAD extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DirectoryService::SimpleAD";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSimpleAD;
    /**
     * @external
     * @cloudformationAttribute Alias
     */
    readonly attrAlias: string;
    /**
     * @external
     * @cloudformationAttribute DnsIpAddresses
     */
    readonly attrDnsIpAddresses: string[];
    /**
     * `AWS::DirectoryService::SimpleAD.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-name
     */
    name: string;
    /**
     * `AWS::DirectoryService::SimpleAD.Password`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-password
     */
    password: string;
    /**
     * `AWS::DirectoryService::SimpleAD.Size`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-size
     */
    size: string;
    /**
     * `AWS::DirectoryService::SimpleAD.VpcSettings`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-vpcsettings
     */
    vpcSettings: CfnSimpleAD.VpcSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::SimpleAD.CreateAlias`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-createalias
     */
    createAlias: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DirectoryService::SimpleAD.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-description
     */
    description: string | undefined;
    /**
     * `AWS::DirectoryService::SimpleAD.EnableSso`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-enablesso
     */
    enableSso: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DirectoryService::SimpleAD.ShortName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-shortname
     */
    shortName: string | undefined;
    /**
     * Create a new `AWS::DirectoryService::SimpleAD`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSimpleADProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DirectoryService::SimpleAD`.
 *
 * @external
 * @cloudformationResource AWS::DirectoryService::SimpleAD
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html
 */
export declare namespace CfnSimpleAD {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-directoryservice-simplead-vpcsettings.html
     */
    interface VpcSettingsProperty {
        /**
         * `CfnSimpleAD.VpcSettingsProperty.SubnetIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-directoryservice-simplead-vpcsettings.html#cfn-directoryservice-simplead-vpcsettings-subnetids
         */
        readonly subnetIds: string[];
        /**
         * `CfnSimpleAD.VpcSettingsProperty.VpcId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-directoryservice-simplead-vpcsettings.html#cfn-directoryservice-simplead-vpcsettings-vpcid
         */
        readonly vpcId: string;
    }
}
