# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import _utilities, _tables


class CloudIntegrationAppDynamics(pulumi.CustomResource):
    additional_tags: pulumi.Output[dict]
    """
    A list of point tag key-values to add to every point ingested using this integration
    """
    app_filter_regexes: pulumi.Output[list]
    """
    List of regular expressions that a application name must match (case-insensitively) 
    in order to be ingested
    """
    controller_name: pulumi.Output[str]
    """
    Name of the SaaS controller
    """
    enable_app_infra_metrics: pulumi.Output[bool]
    """
    Boolean flag to control Application Infrastructure metric injection
    """
    enable_backend_metrics: pulumi.Output[bool]
    """
    Boolean flag to control Backend metric injection
    """
    enable_business_trx_metrics: pulumi.Output[bool]
    """
    Boolean flag to control Business Transaction metric injection
    """
    enable_error_metrics: pulumi.Output[bool]
    """
    Boolean flag to control Error metric injection
    """
    enable_individual_node_metrics: pulumi.Output[bool]
    """
    Boolean flag to control Individual Node metric injection
    """
    enable_overall_perf_metrics: pulumi.Output[bool]
    """
    Boolean flag to control Overall Performance metric injection
    """
    enable_rollup: pulumi.Output[bool]
    """
    Set this to `false` to get separate results for all values within the time range, 
    by default it is `true`
    """
    enable_service_endpoint_metrics: pulumi.Output[bool]
    """
    Boolean flag to control Service End point metric injection
    """
    encrypted_password: pulumi.Output[str]
    """
    Password for AppDynamics user
    """
    force_save: pulumi.Output[bool]
    """
    Forces this resource to save, even if errors are present
    """
    name: pulumi.Output[str]
    """
    The human-readable name of this integration
    """
    service: pulumi.Output[str]
    """
    A value denoting which cloud service this service integrates with
    """
    service_refresh_rate_in_minutes: pulumi.Output[float]
    """
    How often, in minutes, to refresh the service
    """
    user_name: pulumi.Output[str]
    """
    Username is a combination of userName and the account name
    """
    def __init__(__self__, resource_name, opts=None, additional_tags=None, app_filter_regexes=None, controller_name=None, enable_app_infra_metrics=None, enable_backend_metrics=None, enable_business_trx_metrics=None, enable_error_metrics=None, enable_individual_node_metrics=None, enable_overall_perf_metrics=None, enable_rollup=None, enable_service_endpoint_metrics=None, encrypted_password=None, force_save=None, name=None, service=None, service_refresh_rate_in_minutes=None, user_name=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a Wavefront Cloud Integration for App Dynamics. This allows app dynamics cloud integrations to be created,
        updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        app_dynamics = wavefront.CloudIntegrationAppDynamics("appDynamics",
            controller_name="exampleController",
            encrypted_password="encryptedPassword",
            user_name="example")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] additional_tags: A list of point tag key-values to add to every point ingested using this integration
        :param pulumi.Input[list] app_filter_regexes: List of regular expressions that a application name must match (case-insensitively) 
               in order to be ingested
        :param pulumi.Input[str] controller_name: Name of the SaaS controller
        :param pulumi.Input[bool] enable_app_infra_metrics: Boolean flag to control Application Infrastructure metric injection
        :param pulumi.Input[bool] enable_backend_metrics: Boolean flag to control Backend metric injection
        :param pulumi.Input[bool] enable_business_trx_metrics: Boolean flag to control Business Transaction metric injection
        :param pulumi.Input[bool] enable_error_metrics: Boolean flag to control Error metric injection
        :param pulumi.Input[bool] enable_individual_node_metrics: Boolean flag to control Individual Node metric injection
        :param pulumi.Input[bool] enable_overall_perf_metrics: Boolean flag to control Overall Performance metric injection
        :param pulumi.Input[bool] enable_rollup: Set this to `false` to get separate results for all values within the time range, 
               by default it is `true`
        :param pulumi.Input[bool] enable_service_endpoint_metrics: Boolean flag to control Service End point metric injection
        :param pulumi.Input[str] encrypted_password: Password for AppDynamics user
        :param pulumi.Input[bool] force_save: Forces this resource to save, even if errors are present
        :param pulumi.Input[str] name: The human-readable name of this integration
        :param pulumi.Input[str] service: A value denoting which cloud service this service integrates with
        :param pulumi.Input[float] service_refresh_rate_in_minutes: How often, in minutes, to refresh the service
        :param pulumi.Input[str] user_name: Username is a combination of userName and the account name
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['additional_tags'] = additional_tags
            __props__['app_filter_regexes'] = app_filter_regexes
            if controller_name is None:
                raise TypeError("Missing required property 'controller_name'")
            __props__['controller_name'] = controller_name
            __props__['enable_app_infra_metrics'] = enable_app_infra_metrics
            __props__['enable_backend_metrics'] = enable_backend_metrics
            __props__['enable_business_trx_metrics'] = enable_business_trx_metrics
            __props__['enable_error_metrics'] = enable_error_metrics
            __props__['enable_individual_node_metrics'] = enable_individual_node_metrics
            __props__['enable_overall_perf_metrics'] = enable_overall_perf_metrics
            __props__['enable_rollup'] = enable_rollup
            __props__['enable_service_endpoint_metrics'] = enable_service_endpoint_metrics
            if encrypted_password is None:
                raise TypeError("Missing required property 'encrypted_password'")
            __props__['encrypted_password'] = encrypted_password
            __props__['force_save'] = force_save
            __props__['name'] = name
            if service is None:
                raise TypeError("Missing required property 'service'")
            __props__['service'] = service
            __props__['service_refresh_rate_in_minutes'] = service_refresh_rate_in_minutes
            if user_name is None:
                raise TypeError("Missing required property 'user_name'")
            __props__['user_name'] = user_name
        super(CloudIntegrationAppDynamics, __self__).__init__(
            'wavefront:index/cloudIntegrationAppDynamics:CloudIntegrationAppDynamics',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, additional_tags=None, app_filter_regexes=None, controller_name=None, enable_app_infra_metrics=None, enable_backend_metrics=None, enable_business_trx_metrics=None, enable_error_metrics=None, enable_individual_node_metrics=None, enable_overall_perf_metrics=None, enable_rollup=None, enable_service_endpoint_metrics=None, encrypted_password=None, force_save=None, name=None, service=None, service_refresh_rate_in_minutes=None, user_name=None):
        """
        Get an existing CloudIntegrationAppDynamics resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] additional_tags: A list of point tag key-values to add to every point ingested using this integration
        :param pulumi.Input[list] app_filter_regexes: List of regular expressions that a application name must match (case-insensitively) 
               in order to be ingested
        :param pulumi.Input[str] controller_name: Name of the SaaS controller
        :param pulumi.Input[bool] enable_app_infra_metrics: Boolean flag to control Application Infrastructure metric injection
        :param pulumi.Input[bool] enable_backend_metrics: Boolean flag to control Backend metric injection
        :param pulumi.Input[bool] enable_business_trx_metrics: Boolean flag to control Business Transaction metric injection
        :param pulumi.Input[bool] enable_error_metrics: Boolean flag to control Error metric injection
        :param pulumi.Input[bool] enable_individual_node_metrics: Boolean flag to control Individual Node metric injection
        :param pulumi.Input[bool] enable_overall_perf_metrics: Boolean flag to control Overall Performance metric injection
        :param pulumi.Input[bool] enable_rollup: Set this to `false` to get separate results for all values within the time range, 
               by default it is `true`
        :param pulumi.Input[bool] enable_service_endpoint_metrics: Boolean flag to control Service End point metric injection
        :param pulumi.Input[str] encrypted_password: Password for AppDynamics user
        :param pulumi.Input[bool] force_save: Forces this resource to save, even if errors are present
        :param pulumi.Input[str] name: The human-readable name of this integration
        :param pulumi.Input[str] service: A value denoting which cloud service this service integrates with
        :param pulumi.Input[float] service_refresh_rate_in_minutes: How often, in minutes, to refresh the service
        :param pulumi.Input[str] user_name: Username is a combination of userName and the account name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["additional_tags"] = additional_tags
        __props__["app_filter_regexes"] = app_filter_regexes
        __props__["controller_name"] = controller_name
        __props__["enable_app_infra_metrics"] = enable_app_infra_metrics
        __props__["enable_backend_metrics"] = enable_backend_metrics
        __props__["enable_business_trx_metrics"] = enable_business_trx_metrics
        __props__["enable_error_metrics"] = enable_error_metrics
        __props__["enable_individual_node_metrics"] = enable_individual_node_metrics
        __props__["enable_overall_perf_metrics"] = enable_overall_perf_metrics
        __props__["enable_rollup"] = enable_rollup
        __props__["enable_service_endpoint_metrics"] = enable_service_endpoint_metrics
        __props__["encrypted_password"] = encrypted_password
        __props__["force_save"] = force_save
        __props__["name"] = name
        __props__["service"] = service
        __props__["service_refresh_rate_in_minutes"] = service_refresh_rate_in_minutes
        __props__["user_name"] = user_name
        return CloudIntegrationAppDynamics(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
