# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import _utilities, _tables


class CloudIntegrationEc2(pulumi.CustomResource):
    additional_tags: pulumi.Output[dict]
    """
    A list of point tag key-values to add to every point ingested using this integration
    """
    external_id: pulumi.Output[str]
    """
    The Role ARN that the customer has created in AWS IAM to allow access to Wavefront
    """
    force_save: pulumi.Output[bool]
    """
    Forces this resource to save, even if errors are present
    """
    hostname_tags: pulumi.Output[list]
    name: pulumi.Output[str]
    """
    The human-readable name of this integration
    """
    role_arn: pulumi.Output[str]
    """
    The external id corresponding to the Role ARN
    """
    service: pulumi.Output[str]
    """
    A value denoting which cloud service this service integrates with
    """
    service_refresh_rate_in_minutes: pulumi.Output[float]
    """
    How often, in minutes, to refresh the service
    """
    def __init__(__self__, resource_name, opts=None, additional_tags=None, external_id=None, force_save=None, hostname_tags=None, name=None, role_arn=None, service=None, service_refresh_rate_in_minutes=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a Wavefront Cloud Integration for EC2. This allows EC2 cloud integrations to be created,
        updated, and delete

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        ext_id = wavefront.CloudIntegrationAwsExternalId("extId")
        ec2 = wavefront.CloudIntegrationEc2("ec2",
            role_arn="arn:aws::1234567:role/example-arn",
            external_id=ext_id.id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] additional_tags: A list of point tag key-values to add to every point ingested using this integration
        :param pulumi.Input[str] external_id: The Role ARN that the customer has created in AWS IAM to allow access to Wavefront
        :param pulumi.Input[bool] force_save: Forces this resource to save, even if errors are present
        :param pulumi.Input[str] name: The human-readable name of this integration
        :param pulumi.Input[str] role_arn: The external id corresponding to the Role ARN
        :param pulumi.Input[str] service: A value denoting which cloud service this service integrates with
        :param pulumi.Input[float] service_refresh_rate_in_minutes: How often, in minutes, to refresh the service
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['additional_tags'] = additional_tags
            if external_id is None:
                raise TypeError("Missing required property 'external_id'")
            __props__['external_id'] = external_id
            __props__['force_save'] = force_save
            __props__['hostname_tags'] = hostname_tags
            __props__['name'] = name
            if role_arn is None:
                raise TypeError("Missing required property 'role_arn'")
            __props__['role_arn'] = role_arn
            if service is None:
                raise TypeError("Missing required property 'service'")
            __props__['service'] = service
            __props__['service_refresh_rate_in_minutes'] = service_refresh_rate_in_minutes
        super(CloudIntegrationEc2, __self__).__init__(
            'wavefront:index/cloudIntegrationEc2:CloudIntegrationEc2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, additional_tags=None, external_id=None, force_save=None, hostname_tags=None, name=None, role_arn=None, service=None, service_refresh_rate_in_minutes=None):
        """
        Get an existing CloudIntegrationEc2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] additional_tags: A list of point tag key-values to add to every point ingested using this integration
        :param pulumi.Input[str] external_id: The Role ARN that the customer has created in AWS IAM to allow access to Wavefront
        :param pulumi.Input[bool] force_save: Forces this resource to save, even if errors are present
        :param pulumi.Input[str] name: The human-readable name of this integration
        :param pulumi.Input[str] role_arn: The external id corresponding to the Role ARN
        :param pulumi.Input[str] service: A value denoting which cloud service this service integrates with
        :param pulumi.Input[float] service_refresh_rate_in_minutes: How often, in minutes, to refresh the service
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["additional_tags"] = additional_tags
        __props__["external_id"] = external_id
        __props__["force_save"] = force_save
        __props__["hostname_tags"] = hostname_tags
        __props__["name"] = name
        __props__["role_arn"] = role_arn
        __props__["service"] = service
        __props__["service_refresh_rate_in_minutes"] = service_refresh_rate_in_minutes
        return CloudIntegrationEc2(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
