# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import _utilities, _tables


class CloudIntegrationTesla(pulumi.CustomResource):
    additional_tags: pulumi.Output[dict]
    """
    A list of point tag key-values to add to every point ingested using this integration
    """
    email: pulumi.Output[str]
    """
    Email address for the Tesla account login
    """
    force_save: pulumi.Output[bool]
    """
    Forces this resource to save, even if errors are present
    """
    name: pulumi.Output[str]
    """
    The human-readable name of this integration
    """
    password: pulumi.Output[str]
    """
    Password for the Tesla account login
    """
    service: pulumi.Output[str]
    """
    A value denoting which cloud service this service integrates with
    """
    service_refresh_rate_in_minutes: pulumi.Output[float]
    """
    How often, in minutes, to refresh the service
    """
    def __init__(__self__, resource_name, opts=None, additional_tags=None, email=None, force_save=None, name=None, password=None, service=None, service_refresh_rate_in_minutes=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a Wavefront Cloud Integration for Tesla. This allows NewRelic cloud integrations to be created,
        updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        tesla = wavefront.CloudIntegrationTesla("tesla",
            email="email@example.com",
            password="password")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] additional_tags: A list of point tag key-values to add to every point ingested using this integration
        :param pulumi.Input[str] email: Email address for the Tesla account login
        :param pulumi.Input[bool] force_save: Forces this resource to save, even if errors are present
        :param pulumi.Input[str] name: The human-readable name of this integration
        :param pulumi.Input[str] password: Password for the Tesla account login
        :param pulumi.Input[str] service: A value denoting which cloud service this service integrates with
        :param pulumi.Input[float] service_refresh_rate_in_minutes: How often, in minutes, to refresh the service
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['additional_tags'] = additional_tags
            if email is None:
                raise TypeError("Missing required property 'email'")
            __props__['email'] = email
            __props__['force_save'] = force_save
            __props__['name'] = name
            if password is None:
                raise TypeError("Missing required property 'password'")
            __props__['password'] = password
            if service is None:
                raise TypeError("Missing required property 'service'")
            __props__['service'] = service
            __props__['service_refresh_rate_in_minutes'] = service_refresh_rate_in_minutes
        super(CloudIntegrationTesla, __self__).__init__(
            'wavefront:index/cloudIntegrationTesla:CloudIntegrationTesla',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, additional_tags=None, email=None, force_save=None, name=None, password=None, service=None, service_refresh_rate_in_minutes=None):
        """
        Get an existing CloudIntegrationTesla resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] additional_tags: A list of point tag key-values to add to every point ingested using this integration
        :param pulumi.Input[str] email: Email address for the Tesla account login
        :param pulumi.Input[bool] force_save: Forces this resource to save, even if errors are present
        :param pulumi.Input[str] name: The human-readable name of this integration
        :param pulumi.Input[str] password: Password for the Tesla account login
        :param pulumi.Input[str] service: A value denoting which cloud service this service integrates with
        :param pulumi.Input[float] service_refresh_rate_in_minutes: How often, in minutes, to refresh the service
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["additional_tags"] = additional_tags
        __props__["email"] = email
        __props__["force_save"] = force_save
        __props__["name"] = name
        __props__["password"] = password
        __props__["service"] = service
        __props__["service_refresh_rate_in_minutes"] = service_refresh_rate_in_minutes
        return CloudIntegrationTesla(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
