# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import _utilities, _tables


class Role(pulumi.CustomResource):
    assignees: pulumi.Output[list]
    """
    A list of user groups or accounts to assign to this role.
    """
    description: pulumi.Output[str]
    """
    A short description of the user group
    """
    name: pulumi.Output[str]
    """
    The name of the user group
    """
    permissions: pulumi.Output[list]
    """
    A list of permissions to assign to this role. Valid options are 
    `agent_management`, `alerts_management`, `dashboard_management`, `embedded_charts`, `events_management`, `external_links_management`,
    `host_tag_management`, `metrics_management`, `user_management`
    """
    def __init__(__self__, resource_name, opts=None, assignees=None, description=None, name=None, permissions=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a Wavefront Role Resource. This allows user groups to be created, updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        role = wavefront.Role("role")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] assignees: A list of user groups or accounts to assign to this role.
        :param pulumi.Input[str] description: A short description of the user group
        :param pulumi.Input[str] name: The name of the user group
        :param pulumi.Input[list] permissions: A list of permissions to assign to this role. Valid options are 
               `agent_management`, `alerts_management`, `dashboard_management`, `embedded_charts`, `events_management`, `external_links_management`,
               `host_tag_management`, `metrics_management`, `user_management`
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['assignees'] = assignees
            __props__['description'] = description
            __props__['name'] = name
            __props__['permissions'] = permissions
        super(Role, __self__).__init__(
            'wavefront:index/role:Role',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, assignees=None, description=None, name=None, permissions=None):
        """
        Get an existing Role resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] assignees: A list of user groups or accounts to assign to this role.
        :param pulumi.Input[str] description: A short description of the user group
        :param pulumi.Input[str] name: The name of the user group
        :param pulumi.Input[list] permissions: A list of permissions to assign to this role. Valid options are 
               `agent_management`, `alerts_management`, `dashboard_management`, `embedded_charts`, `events_management`, `external_links_management`,
               `host_tag_management`, `metrics_management`, `user_management`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["assignees"] = assignees
        __props__["description"] = description
        __props__["name"] = name
        __props__["permissions"] = permissions
        return Role(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
