"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricFilter = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("@aws-cdk/aws-cloudwatch");
const core_1 = require("@aws-cdk/core");
const logs_generated_1 = require("./logs.generated");
/**
 * A filter that extracts information from CloudWatch Logs and emits to CloudWatch Metrics
 */
class MetricFilter extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_logs_MetricFilterProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, MetricFilter);
            }
            throw error;
        }
        this.metricName = props.metricName;
        this.metricNamespace = props.metricNamespace;
        // It looks odd to map this object to a singleton list, but that's how
        // we're supposed to do it according to the docs.
        //
        // > Currently, you can specify only one metric transformation for
        // > each metric filter. If you want to specify multiple metric
        // > transformations, you must specify multiple metric filters.
        //
        // https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-metricfilter.html
        new logs_generated_1.CfnMetricFilter(this, 'Resource', {
            logGroupName: props.logGroup.logGroupName,
            filterPattern: props.filterPattern.logPatternString,
            metricTransformations: [{
                    metricNamespace: props.metricNamespace,
                    metricName: props.metricName,
                    metricValue: props.metricValue ?? '1',
                    defaultValue: props.defaultValue,
                }],
        });
    }
    /**
     * Return the given named metric for this Metric Filter
     *
     * @default avg over 5 minutes
     */
    metric(props) {
        return new aws_cloudwatch_1.Metric({
            metricName: this.metricName,
            namespace: this.metricNamespace,
            statistic: 'avg',
            ...props,
        }).attachTo(this);
    }
}
exports.MetricFilter = MetricFilter;
_a = JSII_RTTI_SYMBOL_1;
MetricFilter[_a] = { fqn: "@aws-cdk/aws-logs.MetricFilter", version: "1.186.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWV0cmljLWZpbHRlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIm1ldHJpYy1maWx0ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsNERBQWdFO0FBQ2hFLHdDQUF5QztBQUd6QyxxREFBbUQ7QUFZbkQ7O0dBRUc7QUFDSCxNQUFhLFlBQWEsU0FBUSxlQUFRO0lBS3hDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBd0I7UUFDaEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQzs7Ozs7OytDQU5SLFlBQVk7Ozs7UUFRckIsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDO1FBQ25DLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztRQUU3QyxzRUFBc0U7UUFDdEUsaURBQWlEO1FBQ2pELEVBQUU7UUFDRixrRUFBa0U7UUFDbEUsK0RBQStEO1FBQy9ELCtEQUErRDtRQUMvRCxFQUFFO1FBQ0YscUdBQXFHO1FBQ3JHLElBQUksZ0NBQWUsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ3BDLFlBQVksRUFBRSxLQUFLLENBQUMsUUFBUSxDQUFDLFlBQVk7WUFDekMsYUFBYSxFQUFFLEtBQUssQ0FBQyxhQUFhLENBQUMsZ0JBQWdCO1lBQ25ELHFCQUFxQixFQUFFLENBQUM7b0JBQ3RCLGVBQWUsRUFBRSxLQUFLLENBQUMsZUFBZTtvQkFDdEMsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVO29CQUM1QixXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVcsSUFBSSxHQUFHO29CQUNyQyxZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7aUJBQ2pDLENBQUM7U0FDSCxDQUFDLENBQUM7S0FDSjtJQUVEOzs7O09BSUc7SUFDSSxNQUFNLENBQUMsS0FBcUI7UUFDakMsT0FBTyxJQUFJLHVCQUFNLENBQUM7WUFDaEIsVUFBVSxFQUFFLElBQUksQ0FBQyxVQUFVO1lBQzNCLFNBQVMsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUMvQixTQUFTLEVBQUUsS0FBSztZQUNoQixHQUFHLEtBQUs7U0FDVCxDQUFDLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDO0tBQ25COztBQTNDSCxvQ0E0Q0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBNZXRyaWMsIE1ldHJpY09wdGlvbnMgfSBmcm9tICdAYXdzLWNkay9hd3MtY2xvdWR3YXRjaCc7XG5pbXBvcnQgeyBSZXNvdXJjZSB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBJTG9nR3JvdXAsIE1ldHJpY0ZpbHRlck9wdGlvbnMgfSBmcm9tICcuL2xvZy1ncm91cCc7XG5pbXBvcnQgeyBDZm5NZXRyaWNGaWx0ZXIgfSBmcm9tICcuL2xvZ3MuZ2VuZXJhdGVkJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBhIE1ldHJpY0ZpbHRlclxuICovXG5leHBvcnQgaW50ZXJmYWNlIE1ldHJpY0ZpbHRlclByb3BzIGV4dGVuZHMgTWV0cmljRmlsdGVyT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUaGUgbG9nIGdyb3VwIHRvIGNyZWF0ZSB0aGUgZmlsdGVyIG9uLlxuICAgKi9cbiAgcmVhZG9ubHkgbG9nR3JvdXA6IElMb2dHcm91cDtcbn1cblxuLyoqXG4gKiBBIGZpbHRlciB0aGF0IGV4dHJhY3RzIGluZm9ybWF0aW9uIGZyb20gQ2xvdWRXYXRjaCBMb2dzIGFuZCBlbWl0cyB0byBDbG91ZFdhdGNoIE1ldHJpY3NcbiAqL1xuZXhwb3J0IGNsYXNzIE1ldHJpY0ZpbHRlciBleHRlbmRzIFJlc291cmNlIHtcblxuICBwcml2YXRlIHJlYWRvbmx5IG1ldHJpY05hbWU6IHN0cmluZztcbiAgcHJpdmF0ZSByZWFkb25seSBtZXRyaWNOYW1lc3BhY2U6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogTWV0cmljRmlsdGVyUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdGhpcy5tZXRyaWNOYW1lID0gcHJvcHMubWV0cmljTmFtZTtcbiAgICB0aGlzLm1ldHJpY05hbWVzcGFjZSA9IHByb3BzLm1ldHJpY05hbWVzcGFjZTtcblxuICAgIC8vIEl0IGxvb2tzIG9kZCB0byBtYXAgdGhpcyBvYmplY3QgdG8gYSBzaW5nbGV0b24gbGlzdCwgYnV0IHRoYXQncyBob3dcbiAgICAvLyB3ZSdyZSBzdXBwb3NlZCB0byBkbyBpdCBhY2NvcmRpbmcgdG8gdGhlIGRvY3MuXG4gICAgLy9cbiAgICAvLyA+IEN1cnJlbnRseSwgeW91IGNhbiBzcGVjaWZ5IG9ubHkgb25lIG1ldHJpYyB0cmFuc2Zvcm1hdGlvbiBmb3JcbiAgICAvLyA+IGVhY2ggbWV0cmljIGZpbHRlci4gSWYgeW91IHdhbnQgdG8gc3BlY2lmeSBtdWx0aXBsZSBtZXRyaWNcbiAgICAvLyA+IHRyYW5zZm9ybWF0aW9ucywgeW91IG11c3Qgc3BlY2lmeSBtdWx0aXBsZSBtZXRyaWMgZmlsdGVycy5cbiAgICAvL1xuICAgIC8vIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1sb2dzLW1ldHJpY2ZpbHRlci5odG1sXG4gICAgbmV3IENmbk1ldHJpY0ZpbHRlcih0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBsb2dHcm91cE5hbWU6IHByb3BzLmxvZ0dyb3VwLmxvZ0dyb3VwTmFtZSxcbiAgICAgIGZpbHRlclBhdHRlcm46IHByb3BzLmZpbHRlclBhdHRlcm4ubG9nUGF0dGVyblN0cmluZyxcbiAgICAgIG1ldHJpY1RyYW5zZm9ybWF0aW9uczogW3tcbiAgICAgICAgbWV0cmljTmFtZXNwYWNlOiBwcm9wcy5tZXRyaWNOYW1lc3BhY2UsXG4gICAgICAgIG1ldHJpY05hbWU6IHByb3BzLm1ldHJpY05hbWUsXG4gICAgICAgIG1ldHJpY1ZhbHVlOiBwcm9wcy5tZXRyaWNWYWx1ZSA/PyAnMScsXG4gICAgICAgIGRlZmF1bHRWYWx1ZTogcHJvcHMuZGVmYXVsdFZhbHVlLFxuICAgICAgfV0sXG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJuIHRoZSBnaXZlbiBuYW1lZCBtZXRyaWMgZm9yIHRoaXMgTWV0cmljIEZpbHRlclxuICAgKlxuICAgKiBAZGVmYXVsdCBhdmcgb3ZlciA1IG1pbnV0ZXNcbiAgICovXG4gIHB1YmxpYyBtZXRyaWMocHJvcHM/OiBNZXRyaWNPcHRpb25zKTogTWV0cmljIHtcbiAgICByZXR1cm4gbmV3IE1ldHJpYyh7XG4gICAgICBtZXRyaWNOYW1lOiB0aGlzLm1ldHJpY05hbWUsXG4gICAgICBuYW1lc3BhY2U6IHRoaXMubWV0cmljTmFtZXNwYWNlLFxuICAgICAgc3RhdGlzdGljOiAnYXZnJyxcbiAgICAgIC4uLnByb3BzLFxuICAgIH0pLmF0dGFjaFRvKHRoaXMpO1xuICB9XG59XG4iXX0=