"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionFilter = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const logs_generated_1 = require("./logs.generated");
/**
 * A new Subscription on a CloudWatch log group.
 */
class SubscriptionFilter extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_logs_SubscriptionFilterProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SubscriptionFilter);
            }
            throw error;
        }
        const destProps = props.destination.bind(this, props.logGroup);
        new logs_generated_1.CfnSubscriptionFilter(this, 'Resource', {
            logGroupName: props.logGroup.logGroupName,
            destinationArn: destProps.arn,
            roleArn: destProps.role && destProps.role.roleArn,
            filterPattern: props.filterPattern.logPatternString,
        });
    }
}
exports.SubscriptionFilter = SubscriptionFilter;
_a = JSII_RTTI_SYMBOL_1;
SubscriptionFilter[_a] = { fqn: "@aws-cdk/aws-logs.SubscriptionFilter", version: "1.186.0" };
//# sourceMappingURL=data:application/json;base64,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