# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'EdgeCacheKeysetPublicKey',
    'EdgeCacheOriginTimeout',
    'EdgeCacheServiceLogConfig',
    'EdgeCacheServiceRouting',
    'EdgeCacheServiceRoutingHostRule',
    'EdgeCacheServiceRoutingPathMatcher',
    'EdgeCacheServiceRoutingPathMatcherRouteRule',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite',
    'EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect',
]

@pulumi.output_type
class EdgeCacheKeysetPublicKey(dict):
    def __init__(__self__, *,
                 id: str,
                 value: str):
        """
        :param str id: The ID of the public key. The ID must be 1-63 characters long, and comply with RFC1035.
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]*
               which means the first character must be a letter, and all following characters must be a dash, underscore, letter or digit.
        :param str value: The base64-encoded value of the Ed25519 public key. The base64 encoding can be padded (44 bytes) or unpadded (43 bytes).
               Representations or encodings of the public key other than this will be rejected with an error.
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the public key. The ID must be 1-63 characters long, and comply with RFC1035.
        The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]*
        which means the first character must be a letter, and all following characters must be a dash, underscore, letter or digit.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The base64-encoded value of the Ed25519 public key. The base64 encoding can be padded (44 bytes) or unpadded (43 bytes).
        Representations or encodings of the public key other than this will be rejected with an error.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EdgeCacheOriginTimeout(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "maxAttemptsTimeout":
            suggest = "max_attempts_timeout"
        elif key == "responseTimeout":
            suggest = "response_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheOriginTimeout. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheOriginTimeout.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheOriginTimeout.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_timeout: Optional[str] = None,
                 max_attempts_timeout: Optional[str] = None,
                 response_timeout: Optional[str] = None):
        """
        :param str connect_timeout: The maximum duration to wait for the origin connection to be established, including DNS lookup, TLS handshake and TCP/QUIC connection establishment.
               Defaults to 5 seconds. The timeout must be a value between 1s and 15s.
        :param str max_attempts_timeout: The maximum time across all connection attempts to the origin, including failover origins, before returning an error to the client. A HTTP 503 will be returned if the timeout is reached before a response is returned.
               Defaults to 5 seconds. The timeout must be a value between 1s and 15s.
        :param str response_timeout: The maximum duration to wait for data to arrive when reading from the HTTP connection/stream.
               Defaults to 5 seconds. The timeout must be a value between 1s and 30s.
        """
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if max_attempts_timeout is not None:
            pulumi.set(__self__, "max_attempts_timeout", max_attempts_timeout)
        if response_timeout is not None:
            pulumi.set(__self__, "response_timeout", response_timeout)

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[str]:
        """
        The maximum duration to wait for the origin connection to be established, including DNS lookup, TLS handshake and TCP/QUIC connection establishment.
        Defaults to 5 seconds. The timeout must be a value between 1s and 15s.
        """
        return pulumi.get(self, "connect_timeout")

    @property
    @pulumi.getter(name="maxAttemptsTimeout")
    def max_attempts_timeout(self) -> Optional[str]:
        """
        The maximum time across all connection attempts to the origin, including failover origins, before returning an error to the client. A HTTP 503 will be returned if the timeout is reached before a response is returned.
        Defaults to 5 seconds. The timeout must be a value between 1s and 15s.
        """
        return pulumi.get(self, "max_attempts_timeout")

    @property
    @pulumi.getter(name="responseTimeout")
    def response_timeout(self) -> Optional[str]:
        """
        The maximum duration to wait for data to arrive when reading from the HTTP connection/stream.
        Defaults to 5 seconds. The timeout must be a value between 1s and 30s.
        """
        return pulumi.get(self, "response_timeout")


@pulumi.output_type
class EdgeCacheServiceLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sampleRate":
            suggest = "sample_rate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: Optional[bool] = None,
                 sample_rate: Optional[float] = None):
        """
        :param bool enable: Specifies whether to enable logging for traffic served by this service.
        :param float sample_rate: Configures the sampling rate of requests, where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported. The default value is 1.0, and the value of the field must be in [0, 1].
               This field can only be specified if logging is enabled for this service.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if sample_rate is not None:
            pulumi.set(__self__, "sample_rate", sample_rate)

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        """
        Specifies whether to enable logging for traffic served by this service.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="sampleRate")
    def sample_rate(self) -> Optional[float]:
        """
        Configures the sampling rate of requests, where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported. The default value is 1.0, and the value of the field must be in [0, 1].
        This field can only be specified if logging is enabled for this service.
        """
        return pulumi.get(self, "sample_rate")


@pulumi.output_type
class EdgeCacheServiceRouting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostRules":
            suggest = "host_rules"
        elif key == "pathMatchers":
            suggest = "path_matchers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRouting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRouting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRouting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_rules: Sequence['outputs.EdgeCacheServiceRoutingHostRule'],
                 path_matchers: Sequence['outputs.EdgeCacheServiceRoutingPathMatcher']):
        """
        :param Sequence['EdgeCacheServiceRoutingHostRuleArgs'] host_rules: The list of hostRules to match against. These rules define which hostnames the EdgeCacheService will match against, and which route configurations apply.
               Structure is documented below.
        :param Sequence['EdgeCacheServiceRoutingPathMatcherArgs'] path_matchers: The name of the pathMatcher associated with this hostRule.
        """
        pulumi.set(__self__, "host_rules", host_rules)
        pulumi.set(__self__, "path_matchers", path_matchers)

    @property
    @pulumi.getter(name="hostRules")
    def host_rules(self) -> Sequence['outputs.EdgeCacheServiceRoutingHostRule']:
        """
        The list of hostRules to match against. These rules define which hostnames the EdgeCacheService will match against, and which route configurations apply.
        Structure is documented below.
        """
        return pulumi.get(self, "host_rules")

    @property
    @pulumi.getter(name="pathMatchers")
    def path_matchers(self) -> Sequence['outputs.EdgeCacheServiceRoutingPathMatcher']:
        """
        The name of the pathMatcher associated with this hostRule.
        """
        return pulumi.get(self, "path_matchers")


@pulumi.output_type
class EdgeCacheServiceRoutingHostRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pathMatcher":
            suggest = "path_matcher"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingHostRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingHostRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingHostRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hosts: Sequence[str],
                 path_matcher: str,
                 description: Optional[str] = None):
        """
        :param Sequence[str] hosts: The list of host patterns to match.
               Host patterns must be valid hostnames with optional port numbers in the format host:port. * matches any string of ([a-z0-9-.]*).
               The only accepted ports are :80 and :443.
               Hosts are matched against the HTTP Host header, or for HTTP/2 and HTTP/3, the ":authority" header, from the incoming request.
        :param str path_matcher: The name of the pathMatcher associated with this hostRule.
        :param str description: A human-readable description of the resource.
        """
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "path_matcher", path_matcher)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def hosts(self) -> Sequence[str]:
        """
        The list of host patterns to match.
        Host patterns must be valid hostnames with optional port numbers in the format host:port. * matches any string of ([a-z0-9-.]*).
        The only accepted ports are :80 and :443.
        Hosts are matched against the HTTP Host header, or for HTTP/2 and HTTP/3, the ":authority" header, from the incoming request.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter(name="pathMatcher")
    def path_matcher(self) -> str:
        """
        The name of the pathMatcher associated with this hostRule.
        """
        return pulumi.get(self, "path_matcher")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcher(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "routeRules":
            suggest = "route_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcher. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcher.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcher.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 route_rules: Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRule'],
                 description: Optional[str] = None):
        """
        :param str name: The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        :param Sequence['EdgeCacheServiceRoutingPathMatcherRouteRuleArgs'] route_rules: The routeRules to match against. routeRules support advanced routing behaviour, and can match on paths, headers and query parameters, as well as status codes and HTTP methods.
               Structure is documented below.
        :param str description: A human-readable description of the resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "route_rules", route_rules)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="routeRules")
    def route_rules(self) -> Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRule']:
        """
        The routeRules to match against. routeRules support advanced routing behaviour, and can match on paths, headers and query parameters, as well as status codes and HTTP methods.
        Structure is documented below.
        """
        return pulumi.get(self, "route_rules")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchRules":
            suggest = "match_rules"
        elif key == "headerAction":
            suggest = "header_action"
        elif key == "routeAction":
            suggest = "route_action"
        elif key == "urlRedirect":
            suggest = "url_redirect"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_rules: Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule'],
                 priority: str,
                 description: Optional[str] = None,
                 header_action: Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction'] = None,
                 origin: Optional[str] = None,
                 route_action: Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction'] = None,
                 url_redirect: Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect'] = None):
        """
        :param Sequence['EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleArgs'] match_rules: The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates
               within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
               Structure is documented below.
        :param str priority: The priority of this route rule, where 1 is the highest priority.
               You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number between 1 and 999 inclusive.
               Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers
               to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
        :param str description: A human-readable description of the resource.
        :param 'EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionArgs' header_action: The header actions, including adding & removing headers, for requests that match this route.
               Structure is documented below.
        :param str origin: The Origin resource that requests to this route should fetch from when a matching response is not in cache. Origins can be defined as short names ("my-origin") or fully-qualified resource URLs - e.g. "networkservices.googleapis.com/projects/my-project/global/edgecacheorigins/my-origin"
               Only one of origin or urlRedirect can be set.
        :param 'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionArgs' route_action: In response to a matching path, the routeAction performs advanced routing actions like URL rewrites, header transformations, etc. prior to forwarding the request to the selected origin.
               Structure is documented below.
        :param 'EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirectArgs' url_redirect: The URL redirect configuration for requests that match this route.
               Structure is documented below.
        """
        pulumi.set(__self__, "match_rules", match_rules)
        pulumi.set(__self__, "priority", priority)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if header_action is not None:
            pulumi.set(__self__, "header_action", header_action)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if route_action is not None:
            pulumi.set(__self__, "route_action", route_action)
        if url_redirect is not None:
            pulumi.set(__self__, "url_redirect", url_redirect)

    @property
    @pulumi.getter(name="matchRules")
    def match_rules(self) -> Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule']:
        """
        The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates
        within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
        Structure is documented below.
        """
        return pulumi.get(self, "match_rules")

    @property
    @pulumi.getter
    def priority(self) -> str:
        """
        The priority of this route rule, where 1 is the highest priority.
        You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number between 1 and 999 inclusive.
        Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers
        to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="headerAction")
    def header_action(self) -> Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction']:
        """
        The header actions, including adding & removing headers, for requests that match this route.
        Structure is documented below.
        """
        return pulumi.get(self, "header_action")

    @property
    @pulumi.getter
    def origin(self) -> Optional[str]:
        """
        The Origin resource that requests to this route should fetch from when a matching response is not in cache. Origins can be defined as short names ("my-origin") or fully-qualified resource URLs - e.g. "networkservices.googleapis.com/projects/my-project/global/edgecacheorigins/my-origin"
        Only one of origin or urlRedirect can be set.
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter(name="routeAction")
    def route_action(self) -> Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction']:
        """
        In response to a matching path, the routeAction performs advanced routing actions like URL rewrites, header transformations, etc. prior to forwarding the request to the selected origin.
        Structure is documented below.
        """
        return pulumi.get(self, "route_action")

    @property
    @pulumi.getter(name="urlRedirect")
    def url_redirect(self) -> Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect']:
        """
        The URL redirect configuration for requests that match this route.
        Structure is documented below.
        """
        return pulumi.get(self, "url_redirect")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestHeaderToAdds":
            suggest = "request_header_to_adds"
        elif key == "requestHeaderToRemoves":
            suggest = "request_header_to_removes"
        elif key == "responseHeaderToAdds":
            suggest = "response_header_to_adds"
        elif key == "responseHeaderToRemoves":
            suggest = "response_header_to_removes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 request_header_to_adds: Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd']] = None,
                 request_header_to_removes: Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove']] = None,
                 response_header_to_adds: Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd']] = None,
                 response_header_to_removes: Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove']] = None):
        """
        :param Sequence['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAddArgs'] request_header_to_adds: Describes a header to add.
               Structure is documented below.
        :param Sequence['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemoveArgs'] request_header_to_removes: A list of header names for headers that need to be removed from the request prior to forwarding the request to the origin.
               Structure is documented below.
        :param Sequence['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAddArgs'] response_header_to_adds: Headers to add to the response prior to sending it back to the client.
               Response headers are only sent to the client, and do not have an effect on the cache serving the response.
               Structure is documented below.
        :param Sequence['EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemoveArgs'] response_header_to_removes: A list of header names for headers that need to be removed from the request prior to forwarding the request to the origin.
               Structure is documented below.
        """
        if request_header_to_adds is not None:
            pulumi.set(__self__, "request_header_to_adds", request_header_to_adds)
        if request_header_to_removes is not None:
            pulumi.set(__self__, "request_header_to_removes", request_header_to_removes)
        if response_header_to_adds is not None:
            pulumi.set(__self__, "response_header_to_adds", response_header_to_adds)
        if response_header_to_removes is not None:
            pulumi.set(__self__, "response_header_to_removes", response_header_to_removes)

    @property
    @pulumi.getter(name="requestHeaderToAdds")
    def request_header_to_adds(self) -> Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd']]:
        """
        Describes a header to add.
        Structure is documented below.
        """
        return pulumi.get(self, "request_header_to_adds")

    @property
    @pulumi.getter(name="requestHeaderToRemoves")
    def request_header_to_removes(self) -> Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove']]:
        """
        A list of header names for headers that need to be removed from the request prior to forwarding the request to the origin.
        Structure is documented below.
        """
        return pulumi.get(self, "request_header_to_removes")

    @property
    @pulumi.getter(name="responseHeaderToAdds")
    def response_header_to_adds(self) -> Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd']]:
        """
        Headers to add to the response prior to sending it back to the client.
        Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        Structure is documented below.
        """
        return pulumi.get(self, "response_header_to_adds")

    @property
    @pulumi.getter(name="responseHeaderToRemoves")
    def response_header_to_removes(self) -> Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove']]:
        """
        A list of header names for headers that need to be removed from the request prior to forwarding the request to the origin.
        Structure is documented below.
        """
        return pulumi.get(self, "response_header_to_removes")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToAdd.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: str,
                 header_value: str,
                 replace: Optional[bool] = None):
        """
        :param str header_name: Headers to remove from the response prior to sending it back to the client.
               Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        :param str header_value: The value of the header to add.
        :param bool replace: Whether to replace all existing headers with the same name.
        """
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "header_value", header_value)
        if replace is not None:
            pulumi.set(__self__, "replace", replace)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> str:
        """
        Headers to remove from the response prior to sending it back to the client.
        Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> str:
        """
        The value of the header to add.
        """
        return pulumi.get(self, "header_value")

    @property
    @pulumi.getter
    def replace(self) -> Optional[bool]:
        """
        Whether to replace all existing headers with the same name.
        """
        return pulumi.get(self, "replace")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionRequestHeaderToRemove.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: str):
        """
        :param str header_name: Headers to remove from the response prior to sending it back to the client.
               Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        """
        pulumi.set(__self__, "header_name", header_name)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> str:
        """
        Headers to remove from the response prior to sending it back to the client.
        Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        """
        return pulumi.get(self, "header_name")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "headerValue":
            suggest = "header_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToAdd.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: str,
                 header_value: str,
                 replace: Optional[bool] = None):
        """
        :param str header_name: Headers to remove from the response prior to sending it back to the client.
               Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        :param str header_value: The value of the header to add.
        :param bool replace: Whether to replace all existing headers with the same name.
        """
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "header_value", header_value)
        if replace is not None:
            pulumi.set(__self__, "replace", replace)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> str:
        """
        Headers to remove from the response prior to sending it back to the client.
        Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> str:
        """
        The value of the header to add.
        """
        return pulumi.get(self, "header_value")

    @property
    @pulumi.getter
    def replace(self) -> Optional[bool]:
        """
        Whether to replace all existing headers with the same name.
        """
        return pulumi.get(self, "replace")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleHeaderActionResponseHeaderToRemove.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: str):
        """
        :param str header_name: Headers to remove from the response prior to sending it back to the client.
               Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        """
        pulumi.set(__self__, "header_name", header_name)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> str:
        """
        Headers to remove from the response prior to sending it back to the client.
        Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        """
        return pulumi.get(self, "header_name")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fullPathMatch":
            suggest = "full_path_match"
        elif key == "headerMatches":
            suggest = "header_matches"
        elif key == "ignoreCase":
            suggest = "ignore_case"
        elif key == "pathTemplateMatch":
            suggest = "path_template_match"
        elif key == "prefixMatch":
            suggest = "prefix_match"
        elif key == "queryParameterMatches":
            suggest = "query_parameter_matches"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 full_path_match: Optional[str] = None,
                 header_matches: Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch']] = None,
                 ignore_case: Optional[bool] = None,
                 path_template_match: Optional[str] = None,
                 prefix_match: Optional[str] = None,
                 query_parameter_matches: Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch']] = None):
        """
        :param str full_path_match: For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL.
        :param Sequence['EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatchArgs'] header_matches: Specifies a list of header match criteria, all of which must match corresponding headers in the request.
               Structure is documented below.
        :param bool ignore_case: Specifies that prefixMatch and fullPathMatch matches are case sensitive.
        :param str path_template_match: For satisfying the matchRule condition, the path of the request
               must match the wildcard pattern specified in pathTemplateMatch
               after removing any query parameters and anchor that may be part
               of the original URL.
               pathTemplateMatch must be between 1 and 255 characters
               (inclusive).  The pattern specified by pathTemplateMatch may
               have at most 5 wildcard operators and at most 5 variable
               captures in total.
        :param str prefix_match: The value of the header must start with the contents of prefixMatch.
        :param Sequence['EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatchArgs'] query_parameter_matches: Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request.
               Structure is documented below.
        """
        if full_path_match is not None:
            pulumi.set(__self__, "full_path_match", full_path_match)
        if header_matches is not None:
            pulumi.set(__self__, "header_matches", header_matches)
        if ignore_case is not None:
            pulumi.set(__self__, "ignore_case", ignore_case)
        if path_template_match is not None:
            pulumi.set(__self__, "path_template_match", path_template_match)
        if prefix_match is not None:
            pulumi.set(__self__, "prefix_match", prefix_match)
        if query_parameter_matches is not None:
            pulumi.set(__self__, "query_parameter_matches", query_parameter_matches)

    @property
    @pulumi.getter(name="fullPathMatch")
    def full_path_match(self) -> Optional[str]:
        """
        For satisfying the matchRule condition, the path of the request must exactly match the value specified in fullPathMatch after removing any query parameters and anchor that may be part of the original URL.
        """
        return pulumi.get(self, "full_path_match")

    @property
    @pulumi.getter(name="headerMatches")
    def header_matches(self) -> Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch']]:
        """
        Specifies a list of header match criteria, all of which must match corresponding headers in the request.
        Structure is documented below.
        """
        return pulumi.get(self, "header_matches")

    @property
    @pulumi.getter(name="ignoreCase")
    def ignore_case(self) -> Optional[bool]:
        """
        Specifies that prefixMatch and fullPathMatch matches are case sensitive.
        """
        return pulumi.get(self, "ignore_case")

    @property
    @pulumi.getter(name="pathTemplateMatch")
    def path_template_match(self) -> Optional[str]:
        """
        For satisfying the matchRule condition, the path of the request
        must match the wildcard pattern specified in pathTemplateMatch
        after removing any query parameters and anchor that may be part
        of the original URL.
        pathTemplateMatch must be between 1 and 255 characters
        (inclusive).  The pattern specified by pathTemplateMatch may
        have at most 5 wildcard operators and at most 5 variable
        captures in total.
        """
        return pulumi.get(self, "path_template_match")

    @property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> Optional[str]:
        """
        The value of the header must start with the contents of prefixMatch.
        """
        return pulumi.get(self, "prefix_match")

    @property
    @pulumi.getter(name="queryParameterMatches")
    def query_parameter_matches(self) -> Optional[Sequence['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch']]:
        """
        Specifies a list of query parameter match criteria, all of which must match corresponding query parameters in the request.
        Structure is documented below.
        """
        return pulumi.get(self, "query_parameter_matches")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerName":
            suggest = "header_name"
        elif key == "exactMatch":
            suggest = "exact_match"
        elif key == "invertMatch":
            suggest = "invert_match"
        elif key == "prefixMatch":
            suggest = "prefix_match"
        elif key == "presentMatch":
            suggest = "present_match"
        elif key == "suffixMatch":
            suggest = "suffix_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleHeaderMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_name: str,
                 exact_match: Optional[str] = None,
                 invert_match: Optional[bool] = None,
                 prefix_match: Optional[str] = None,
                 present_match: Optional[bool] = None,
                 suffix_match: Optional[str] = None):
        """
        :param str header_name: Headers to remove from the response prior to sending it back to the client.
               Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        :param str exact_match: The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch.
        :param bool invert_match: If set to false (default), the headerMatch is considered a match if the match criteria above are met.
               If set to true, the headerMatch is considered a match if the match criteria above are NOT met.
        :param str prefix_match: The value of the header must start with the contents of prefixMatch.
        :param bool present_match: Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not.
        :param str suffix_match: The value of the header must end with the contents of suffixMatch.
        """
        pulumi.set(__self__, "header_name", header_name)
        if exact_match is not None:
            pulumi.set(__self__, "exact_match", exact_match)
        if invert_match is not None:
            pulumi.set(__self__, "invert_match", invert_match)
        if prefix_match is not None:
            pulumi.set(__self__, "prefix_match", prefix_match)
        if present_match is not None:
            pulumi.set(__self__, "present_match", present_match)
        if suffix_match is not None:
            pulumi.set(__self__, "suffix_match", suffix_match)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> str:
        """
        Headers to remove from the response prior to sending it back to the client.
        Response headers are only sent to the client, and do not have an effect on the cache serving the response.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="exactMatch")
    def exact_match(self) -> Optional[str]:
        """
        The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch.
        """
        return pulumi.get(self, "exact_match")

    @property
    @pulumi.getter(name="invertMatch")
    def invert_match(self) -> Optional[bool]:
        """
        If set to false (default), the headerMatch is considered a match if the match criteria above are met.
        If set to true, the headerMatch is considered a match if the match criteria above are NOT met.
        """
        return pulumi.get(self, "invert_match")

    @property
    @pulumi.getter(name="prefixMatch")
    def prefix_match(self) -> Optional[str]:
        """
        The value of the header must start with the contents of prefixMatch.
        """
        return pulumi.get(self, "prefix_match")

    @property
    @pulumi.getter(name="presentMatch")
    def present_match(self) -> Optional[bool]:
        """
        Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not.
        """
        return pulumi.get(self, "present_match")

    @property
    @pulumi.getter(name="suffixMatch")
    def suffix_match(self) -> Optional[str]:
        """
        The value of the header must end with the contents of suffixMatch.
        """
        return pulumi.get(self, "suffix_match")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exactMatch":
            suggest = "exact_match"
        elif key == "presentMatch":
            suggest = "present_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleMatchRuleQueryParameterMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 exact_match: Optional[str] = None,
                 present_match: Optional[bool] = None):
        """
        :param str name: The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        :param str exact_match: The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch.
        :param bool present_match: Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not.
        """
        pulumi.set(__self__, "name", name)
        if exact_match is not None:
            pulumi.set(__self__, "exact_match", exact_match)
        if present_match is not None:
            pulumi.set(__self__, "present_match", present_match)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the query parameter to match. The query parameter must exist in the request, in the absence of which the request match fails.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="exactMatch")
    def exact_match(self) -> Optional[str]:
        """
        The queryParameterMatch matches if the value of the parameter exactly matches the contents of exactMatch.
        """
        return pulumi.get(self, "exact_match")

    @property
    @pulumi.getter(name="presentMatch")
    def present_match(self) -> Optional[bool]:
        """
        Specifies that the queryParameterMatch matches if the request contains the query parameter, irrespective of whether the parameter has a value or not.
        """
        return pulumi.get(self, "present_match")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cdnPolicy":
            suggest = "cdn_policy"
        elif key == "corsPolicy":
            suggest = "cors_policy"
        elif key == "urlRewrite":
            suggest = "url_rewrite"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cdn_policy: Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy'] = None,
                 cors_policy: Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy'] = None,
                 url_rewrite: Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite'] = None):
        """
        :param 'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyArgs' cdn_policy: The policy to use for defining caching and signed request behaviour for requests that match this route.
               Structure is documented below.
        :param 'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicyArgs' cors_policy: CORSPolicy defines Cross-Origin-Resource-Sharing configuration, including which CORS response headers will be set.
               Structure is documented below.
        :param 'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewriteArgs' url_rewrite: The URL rewrite configuration for requests that match this route.
               Structure is documented below.
        """
        if cdn_policy is not None:
            pulumi.set(__self__, "cdn_policy", cdn_policy)
        if cors_policy is not None:
            pulumi.set(__self__, "cors_policy", cors_policy)
        if url_rewrite is not None:
            pulumi.set(__self__, "url_rewrite", url_rewrite)

    @property
    @pulumi.getter(name="cdnPolicy")
    def cdn_policy(self) -> Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy']:
        """
        The policy to use for defining caching and signed request behaviour for requests that match this route.
        Structure is documented below.
        """
        return pulumi.get(self, "cdn_policy")

    @property
    @pulumi.getter(name="corsPolicy")
    def cors_policy(self) -> Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy']:
        """
        CORSPolicy defines Cross-Origin-Resource-Sharing configuration, including which CORS response headers will be set.
        Structure is documented below.
        """
        return pulumi.get(self, "cors_policy")

    @property
    @pulumi.getter(name="urlRewrite")
    def url_rewrite(self) -> Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite']:
        """
        The URL rewrite configuration for requests that match this route.
        Structure is documented below.
        """
        return pulumi.get(self, "url_rewrite")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheKeyPolicy":
            suggest = "cache_key_policy"
        elif key == "cacheMode":
            suggest = "cache_mode"
        elif key == "clientTtl":
            suggest = "client_ttl"
        elif key == "defaultTtl":
            suggest = "default_ttl"
        elif key == "maxTtl":
            suggest = "max_ttl"
        elif key == "negativeCaching":
            suggest = "negative_caching"
        elif key == "negativeCachingPolicy":
            suggest = "negative_caching_policy"
        elif key == "signedRequestKeyset":
            suggest = "signed_request_keyset"
        elif key == "signedRequestMode":
            suggest = "signed_request_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cache_key_policy: Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy'] = None,
                 cache_mode: Optional[str] = None,
                 client_ttl: Optional[str] = None,
                 default_ttl: Optional[str] = None,
                 max_ttl: Optional[str] = None,
                 negative_caching: Optional[bool] = None,
                 negative_caching_policy: Optional[Mapping[str, str]] = None,
                 signed_request_keyset: Optional[str] = None,
                 signed_request_mode: Optional[str] = None):
        """
        :param 'EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicyArgs' cache_key_policy: Defines the request parameters that contribute to the cache key.
               Structure is documented below.
        :param str cache_mode: Cache modes allow users to control the behaviour of the cache, what content it should cache automatically, whether to respect origin headers, or whether to unconditionally cache all responses.
               For all cache modes, Cache-Control headers will be passed to the client. Use clientTtl to override what is sent to the client.
               Possible values are `CACHE_ALL_STATIC`, `USE_ORIGIN_HEADERS`, `FORCE_CACHE_ALL`, and `BYPASS_CACHE`.
        :param str client_ttl: Specifies a separate client (e.g. browser client) TTL, separate from the TTL used by the edge caches. Leaving this empty will use the same cache TTL for both the CDN and the client-facing response.
               - The TTL must be > 0 and <= 86400s (1 day)
               - The clientTtl cannot be larger than the defaultTtl (if set)
               - Fractions of a second are not allowed.
               - Omit this field to use the defaultTtl, or the max-age set by the origin, as the client-facing TTL.
               When the cache mode is set to "USE_ORIGIN_HEADERS" or "BYPASS_CACHE", you must omit this field.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param str default_ttl: Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age).
               Defaults to 3600s (1 hour).
               - The TTL must be >= 0 and <= 2592000s (1 month)
               - Setting a TTL of "0" means "always revalidate" (equivalent to must-revalidate)
               - The value of defaultTTL cannot be set to a value greater than that of maxTTL.
               - Fractions of a second are not allowed.
               - When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses.
               Note that infrequently accessed objects may be evicted from the cache before the defined TTL. Objects that expire will be revalidated with the origin.
               When the cache mode is set to "USE_ORIGIN_HEADERS" or "BYPASS_CACHE", you must omit this field.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param str max_ttl: Specifies the maximum allowed TTL for cached content served by this origin.
               Defaults to 86400s (1 day).
               Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTtl seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive.
               - The TTL must be >= 0 and <= 2592000s (1 month)
               - Setting a TTL of "0" means "always revalidate"
               - The value of maxTtl must be equal to or greater than defaultTtl.
               - Fractions of a second are not allowed.
               - When the cache mode is set to "USE_ORIGIN_HEADERS", "FORCE_CACHE_ALL", or "BYPASS_CACHE", you must omit this field.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param bool negative_caching: Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency.
               By default, the CDNPolicy will apply the following default TTLs to these status codes:
               - HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m
               - HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s
               - HTTP 405 (Method Not Found), 414 (URI Too Long), 501 (Not Implemented): 60s
               These defaults can be overridden in negativeCachingPolicy
        :param Mapping[str, str] negative_caching_policy: Sets a cache TTL for the specified HTTP status code. negativeCaching must be enabled to configure negativeCachingPolicy.
               - Omitting the policy and leaving negativeCaching enabled will use the default TTLs for each status code, defined in negativeCaching.
               - TTLs must be >= 0 (where 0 is "always revalidate") and <= 86400s (1 day)
               Note that when specifying an explicit negativeCachingPolicy, you should take care to specify a cache TTL for all response codes that you wish to cache. The CDNPolicy will not apply any default negative caching when a policy exists.
        :param str signed_request_keyset: The EdgeCacheKeyset containing the set of public keys used to validate signed requests at the edge.
        :param str signed_request_mode: Whether to enforce signed requests. The default value is DISABLED, which means all content is public, and does not authorize access.
               You must also set a signedRequestKeyset to enable signed requests.
               When set to REQUIRE_SIGNATURES, all matching requests will have their signature validated. Requests that were not signed with the corresponding private key, or that are otherwise invalid (expired, do not match the signature, IP address, or header) will be rejected with a HTTP 403 and (if enabled) logged.
               Possible values are `DISABLED` and `REQUIRE_SIGNATURES`.
        """
        if cache_key_policy is not None:
            pulumi.set(__self__, "cache_key_policy", cache_key_policy)
        if cache_mode is not None:
            pulumi.set(__self__, "cache_mode", cache_mode)
        if client_ttl is not None:
            pulumi.set(__self__, "client_ttl", client_ttl)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if negative_caching is not None:
            pulumi.set(__self__, "negative_caching", negative_caching)
        if negative_caching_policy is not None:
            pulumi.set(__self__, "negative_caching_policy", negative_caching_policy)
        if signed_request_keyset is not None:
            pulumi.set(__self__, "signed_request_keyset", signed_request_keyset)
        if signed_request_mode is not None:
            pulumi.set(__self__, "signed_request_mode", signed_request_mode)

    @property
    @pulumi.getter(name="cacheKeyPolicy")
    def cache_key_policy(self) -> Optional['outputs.EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy']:
        """
        Defines the request parameters that contribute to the cache key.
        Structure is documented below.
        """
        return pulumi.get(self, "cache_key_policy")

    @property
    @pulumi.getter(name="cacheMode")
    def cache_mode(self) -> Optional[str]:
        """
        Cache modes allow users to control the behaviour of the cache, what content it should cache automatically, whether to respect origin headers, or whether to unconditionally cache all responses.
        For all cache modes, Cache-Control headers will be passed to the client. Use clientTtl to override what is sent to the client.
        Possible values are `CACHE_ALL_STATIC`, `USE_ORIGIN_HEADERS`, `FORCE_CACHE_ALL`, and `BYPASS_CACHE`.
        """
        return pulumi.get(self, "cache_mode")

    @property
    @pulumi.getter(name="clientTtl")
    def client_ttl(self) -> Optional[str]:
        """
        Specifies a separate client (e.g. browser client) TTL, separate from the TTL used by the edge caches. Leaving this empty will use the same cache TTL for both the CDN and the client-facing response.
        - The TTL must be > 0 and <= 86400s (1 day)
        - The clientTtl cannot be larger than the defaultTtl (if set)
        - Fractions of a second are not allowed.
        - Omit this field to use the defaultTtl, or the max-age set by the origin, as the client-facing TTL.
        When the cache mode is set to "USE_ORIGIN_HEADERS" or "BYPASS_CACHE", you must omit this field.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "client_ttl")

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[str]:
        """
        Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age).
        Defaults to 3600s (1 hour).
        - The TTL must be >= 0 and <= 2592000s (1 month)
        - Setting a TTL of "0" means "always revalidate" (equivalent to must-revalidate)
        - The value of defaultTTL cannot be set to a value greater than that of maxTTL.
        - Fractions of a second are not allowed.
        - When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses.
        Note that infrequently accessed objects may be evicted from the cache before the defined TTL. Objects that expire will be revalidated with the origin.
        When the cache mode is set to "USE_ORIGIN_HEADERS" or "BYPASS_CACHE", you must omit this field.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[str]:
        """
        Specifies the maximum allowed TTL for cached content served by this origin.
        Defaults to 86400s (1 day).
        Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTtl seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive.
        - The TTL must be >= 0 and <= 2592000s (1 month)
        - Setting a TTL of "0" means "always revalidate"
        - The value of maxTtl must be equal to or greater than defaultTtl.
        - Fractions of a second are not allowed.
        - When the cache mode is set to "USE_ORIGIN_HEADERS", "FORCE_CACHE_ALL", or "BYPASS_CACHE", you must omit this field.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter(name="negativeCaching")
    def negative_caching(self) -> Optional[bool]:
        """
        Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency.
        By default, the CDNPolicy will apply the following default TTLs to these status codes:
        - HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m
        - HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s
        - HTTP 405 (Method Not Found), 414 (URI Too Long), 501 (Not Implemented): 60s
        These defaults can be overridden in negativeCachingPolicy
        """
        return pulumi.get(self, "negative_caching")

    @property
    @pulumi.getter(name="negativeCachingPolicy")
    def negative_caching_policy(self) -> Optional[Mapping[str, str]]:
        """
        Sets a cache TTL for the specified HTTP status code. negativeCaching must be enabled to configure negativeCachingPolicy.
        - Omitting the policy and leaving negativeCaching enabled will use the default TTLs for each status code, defined in negativeCaching.
        - TTLs must be >= 0 (where 0 is "always revalidate") and <= 86400s (1 day)
        Note that when specifying an explicit negativeCachingPolicy, you should take care to specify a cache TTL for all response codes that you wish to cache. The CDNPolicy will not apply any default negative caching when a policy exists.
        """
        return pulumi.get(self, "negative_caching_policy")

    @property
    @pulumi.getter(name="signedRequestKeyset")
    def signed_request_keyset(self) -> Optional[str]:
        """
        The EdgeCacheKeyset containing the set of public keys used to validate signed requests at the edge.
        """
        return pulumi.get(self, "signed_request_keyset")

    @property
    @pulumi.getter(name="signedRequestMode")
    def signed_request_mode(self) -> Optional[str]:
        """
        Whether to enforce signed requests. The default value is DISABLED, which means all content is public, and does not authorize access.
        You must also set a signedRequestKeyset to enable signed requests.
        When set to REQUIRE_SIGNATURES, all matching requests will have their signature validated. Requests that were not signed with the corresponding private key, or that are otherwise invalid (expired, do not match the signature, IP address, or header) will be rejected with a HTTP 403 and (if enabled) logged.
        Possible values are `DISABLED` and `REQUIRE_SIGNATURES`.
        """
        return pulumi.get(self, "signed_request_mode")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeHost":
            suggest = "exclude_host"
        elif key == "excludeQueryString":
            suggest = "exclude_query_string"
        elif key == "excludedQueryParameters":
            suggest = "excluded_query_parameters"
        elif key == "includeProtocol":
            suggest = "include_protocol"
        elif key == "includedHeaderNames":
            suggest = "included_header_names"
        elif key == "includedQueryParameters":
            suggest = "included_query_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCdnPolicyCacheKeyPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_host: Optional[bool] = None,
                 exclude_query_string: Optional[bool] = None,
                 excluded_query_parameters: Optional[Sequence[str]] = None,
                 include_protocol: Optional[bool] = None,
                 included_header_names: Optional[Sequence[str]] = None,
                 included_query_parameters: Optional[Sequence[str]] = None):
        """
        :param bool exclude_host: If true, requests to different hosts will be cached separately.
               Note: this should only be enabled if hosts share the same origin and content Removing the host from the cache key may inadvertently result in different objects being cached than intended, depending on which route the first user matched.
        :param bool exclude_query_string: If true, exclude query string parameters from the cache key
               If false (the default), include the query string parameters in
               the cache key according to includeQueryParameters and
               excludeQueryParameters. If neither includeQueryParameters nor
               excludeQueryParameters is set, the entire query string will be
               included.
        :param Sequence[str] excluded_query_parameters: Names of query string parameters to exclude from cache keys. All other parameters will be included.
               Either specify includedQueryParameters or excludedQueryParameters, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        :param bool include_protocol: If true, http and https requests will be cached separately.
        :param Sequence[str] included_header_names: Names of HTTP request headers to include in cache keys. The value of the header field will be used as part of the cache key.
               - Header names must be valid HTTP RFC 7230 header field values.
               - Header field names are case insensitive
               - To include the HTTP method, use ":method"
               Note that specifying several headers, and/or headers that have a large range of values (e.g. per-user) will dramatically impact the cache hit rate, and may result in a higher eviction rate and reduced performance.
        :param Sequence[str] included_query_parameters: Names of query string parameters to include in cache keys. All other parameters will be excluded.
               Either specify includedQueryParameters or excludedQueryParameters, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        """
        if exclude_host is not None:
            pulumi.set(__self__, "exclude_host", exclude_host)
        if exclude_query_string is not None:
            pulumi.set(__self__, "exclude_query_string", exclude_query_string)
        if excluded_query_parameters is not None:
            pulumi.set(__self__, "excluded_query_parameters", excluded_query_parameters)
        if include_protocol is not None:
            pulumi.set(__self__, "include_protocol", include_protocol)
        if included_header_names is not None:
            pulumi.set(__self__, "included_header_names", included_header_names)
        if included_query_parameters is not None:
            pulumi.set(__self__, "included_query_parameters", included_query_parameters)

    @property
    @pulumi.getter(name="excludeHost")
    def exclude_host(self) -> Optional[bool]:
        """
        If true, requests to different hosts will be cached separately.
        Note: this should only be enabled if hosts share the same origin and content Removing the host from the cache key may inadvertently result in different objects being cached than intended, depending on which route the first user matched.
        """
        return pulumi.get(self, "exclude_host")

    @property
    @pulumi.getter(name="excludeQueryString")
    def exclude_query_string(self) -> Optional[bool]:
        """
        If true, exclude query string parameters from the cache key
        If false (the default), include the query string parameters in
        the cache key according to includeQueryParameters and
        excludeQueryParameters. If neither includeQueryParameters nor
        excludeQueryParameters is set, the entire query string will be
        included.
        """
        return pulumi.get(self, "exclude_query_string")

    @property
    @pulumi.getter(name="excludedQueryParameters")
    def excluded_query_parameters(self) -> Optional[Sequence[str]]:
        """
        Names of query string parameters to exclude from cache keys. All other parameters will be included.
        Either specify includedQueryParameters or excludedQueryParameters, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        """
        return pulumi.get(self, "excluded_query_parameters")

    @property
    @pulumi.getter(name="includeProtocol")
    def include_protocol(self) -> Optional[bool]:
        """
        If true, http and https requests will be cached separately.
        """
        return pulumi.get(self, "include_protocol")

    @property
    @pulumi.getter(name="includedHeaderNames")
    def included_header_names(self) -> Optional[Sequence[str]]:
        """
        Names of HTTP request headers to include in cache keys. The value of the header field will be used as part of the cache key.
        - Header names must be valid HTTP RFC 7230 header field values.
        - Header field names are case insensitive
        - To include the HTTP method, use ":method"
        Note that specifying several headers, and/or headers that have a large range of values (e.g. per-user) will dramatically impact the cache hit rate, and may result in a higher eviction rate and reduced performance.
        """
        return pulumi.get(self, "included_header_names")

    @property
    @pulumi.getter(name="includedQueryParameters")
    def included_query_parameters(self) -> Optional[Sequence[str]]:
        """
        Names of query string parameters to include in cache keys. All other parameters will be excluded.
        Either specify includedQueryParameters or excludedQueryParameters, not both. '&' and '=' will be percent encoded and not treated as delimiters.
        """
        return pulumi.get(self, "included_query_parameters")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAge":
            suggest = "max_age"
        elif key == "allowCredentials":
            suggest = "allow_credentials"
        elif key == "allowHeaders":
            suggest = "allow_headers"
        elif key == "allowMethods":
            suggest = "allow_methods"
        elif key == "allowOrigins":
            suggest = "allow_origins"
        elif key == "exposeHeaders":
            suggest = "expose_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionCorsPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_age: str,
                 allow_credentials: Optional[bool] = None,
                 allow_headers: Optional[Sequence[str]] = None,
                 allow_methods: Optional[Sequence[str]] = None,
                 allow_origins: Optional[Sequence[str]] = None,
                 disabled: Optional[bool] = None,
                 expose_headers: Optional[Sequence[str]] = None):
        """
        :param str max_age: Specifies how long results of a preflight request can be cached by a client in seconds. Note that many browser clients enforce a maximum TTL of 600s (10 minutes).
               - Setting the value to -1 forces a pre-flight check for all requests (not recommended)
               - A maximum TTL of 86400s can be set, but note that (as above) some clients may force pre-flight checks at a more regular interval.
               - This translates to the Access-Control-Max-Age header.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param bool allow_credentials: In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
               This translates to the Access-Control-Allow-Credentials response header.
        :param Sequence[str] allow_headers: Specifies the content for the Access-Control-Allow-Headers response header.
        :param Sequence[str] allow_methods: Specifies the content for the Access-Control-Allow-Methods response header.
        :param Sequence[str] allow_origins: Specifies the list of origins that will be allowed to do CORS requests.
               This translates to the Access-Control-Allow-Origin response header.
        :param bool disabled: If true, specifies the CORS policy is disabled. The default value is false, which indicates that the CORS policy is in effect.
        :param Sequence[str] expose_headers: Specifies the content for the Access-Control-Allow-Headers response header.
        """
        pulumi.set(__self__, "max_age", max_age)
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> str:
        """
        Specifies how long results of a preflight request can be cached by a client in seconds. Note that many browser clients enforce a maximum TTL of 600s (10 minutes).
        - Setting the value to -1 forces a pre-flight check for all requests (not recommended)
        - A maximum TTL of 86400s can be set, but note that (as above) some clients may force pre-flight checks at a more regular interval.
        - This translates to the Access-Control-Max-Age header.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "max_age")

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[bool]:
        """
        In response to a preflight request, setting this to true indicates that the actual request can include user credentials.
        This translates to the Access-Control-Allow-Credentials response header.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[Sequence[str]]:
        """
        Specifies the content for the Access-Control-Allow-Headers response header.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[Sequence[str]]:
        """
        Specifies the content for the Access-Control-Allow-Methods response header.
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional[Sequence[str]]:
        """
        Specifies the list of origins that will be allowed to do CORS requests.
        This translates to the Access-Control-Allow-Origin response header.
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        If true, specifies the CORS policy is disabled. The default value is false, which indicates that the CORS policy is in effect.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[str]]:
        """
        Specifies the content for the Access-Control-Allow-Headers response header.
        """
        return pulumi.get(self, "expose_headers")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostRewrite":
            suggest = "host_rewrite"
        elif key == "pathPrefixRewrite":
            suggest = "path_prefix_rewrite"
        elif key == "pathTemplateRewrite":
            suggest = "path_template_rewrite"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleRouteActionUrlRewrite.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_rewrite: Optional[str] = None,
                 path_prefix_rewrite: Optional[str] = None,
                 path_template_rewrite: Optional[str] = None):
        """
        :param str host_rewrite: Prior to forwarding the request to the selected origin, the request's host header is replaced with contents of hostRewrite.
        :param str path_prefix_rewrite: Prior to forwarding the request to the selected origin, the matching portion of the request's path is replaced by pathPrefixRewrite.
        :param str path_template_rewrite: Prior to forwarding the request to the selected origin, if the
               request matched a pathTemplateMatch, the matching portion of the
               request's path is replaced re-written using the pattern specified
               by pathTemplateRewrite.
               pathTemplateRewrite must be between 1 and 255 characters
               (inclusive), must start with a '/', and must only use variables
               captured by the route's pathTemplate matchers.
               pathTemplateRewrite may only be used when all of a route's
               MatchRules specify pathTemplate.
               Only one of pathPrefixRewrite and pathTemplateRewrite may be
               specified.
        """
        if host_rewrite is not None:
            pulumi.set(__self__, "host_rewrite", host_rewrite)
        if path_prefix_rewrite is not None:
            pulumi.set(__self__, "path_prefix_rewrite", path_prefix_rewrite)
        if path_template_rewrite is not None:
            pulumi.set(__self__, "path_template_rewrite", path_template_rewrite)

    @property
    @pulumi.getter(name="hostRewrite")
    def host_rewrite(self) -> Optional[str]:
        """
        Prior to forwarding the request to the selected origin, the request's host header is replaced with contents of hostRewrite.
        """
        return pulumi.get(self, "host_rewrite")

    @property
    @pulumi.getter(name="pathPrefixRewrite")
    def path_prefix_rewrite(self) -> Optional[str]:
        """
        Prior to forwarding the request to the selected origin, the matching portion of the request's path is replaced by pathPrefixRewrite.
        """
        return pulumi.get(self, "path_prefix_rewrite")

    @property
    @pulumi.getter(name="pathTemplateRewrite")
    def path_template_rewrite(self) -> Optional[str]:
        """
        Prior to forwarding the request to the selected origin, if the
        request matched a pathTemplateMatch, the matching portion of the
        request's path is replaced re-written using the pattern specified
        by pathTemplateRewrite.
        pathTemplateRewrite must be between 1 and 255 characters
        (inclusive), must start with a '/', and must only use variables
        captured by the route's pathTemplate matchers.
        pathTemplateRewrite may only be used when all of a route's
        MatchRules specify pathTemplate.
        Only one of pathPrefixRewrite and pathTemplateRewrite may be
        specified.
        """
        return pulumi.get(self, "path_template_rewrite")


@pulumi.output_type
class EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostRedirect":
            suggest = "host_redirect"
        elif key == "httpsRedirect":
            suggest = "https_redirect"
        elif key == "pathRedirect":
            suggest = "path_redirect"
        elif key == "prefixRedirect":
            suggest = "prefix_redirect"
        elif key == "redirectResponseCode":
            suggest = "redirect_response_code"
        elif key == "stripQuery":
            suggest = "strip_query"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeCacheServiceRoutingPathMatcherRouteRuleUrlRedirect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_redirect: Optional[str] = None,
                 https_redirect: Optional[bool] = None,
                 path_redirect: Optional[str] = None,
                 prefix_redirect: Optional[str] = None,
                 redirect_response_code: Optional[str] = None,
                 strip_query: Optional[bool] = None):
        """
        :param str host_redirect: The host that will be used in the redirect response instead of the one that was supplied in the request.
        :param bool https_redirect: If set to true, the URL scheme in the redirected request is set to https. If set to false, the URL scheme of the redirected request will remain the same as that of the request.
               This can only be set if there is at least one (1) edgeSslCertificate set on the service.
        :param str path_redirect: The path that will be used in the redirect response instead of the one that was supplied in the request.
               pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
               The path value must be between 1 and 1024 characters.
        :param str prefix_redirect: The prefix that replaces the prefixMatch specified in the routeRule, retaining the remaining portion of the URL before redirecting the request.
               prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
        :param str redirect_response_code: The HTTP Status code to use for this RedirectAction.
               The supported values are:
               - `MOVED_PERMANENTLY_DEFAULT`, which is the default value and corresponds to 301.
               - `FOUND`, which corresponds to 302.
        :param bool strip_query: If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request. If set to false, the query portion of the original URL is retained.
        """
        if host_redirect is not None:
            pulumi.set(__self__, "host_redirect", host_redirect)
        if https_redirect is not None:
            pulumi.set(__self__, "https_redirect", https_redirect)
        if path_redirect is not None:
            pulumi.set(__self__, "path_redirect", path_redirect)
        if prefix_redirect is not None:
            pulumi.set(__self__, "prefix_redirect", prefix_redirect)
        if redirect_response_code is not None:
            pulumi.set(__self__, "redirect_response_code", redirect_response_code)
        if strip_query is not None:
            pulumi.set(__self__, "strip_query", strip_query)

    @property
    @pulumi.getter(name="hostRedirect")
    def host_redirect(self) -> Optional[str]:
        """
        The host that will be used in the redirect response instead of the one that was supplied in the request.
        """
        return pulumi.get(self, "host_redirect")

    @property
    @pulumi.getter(name="httpsRedirect")
    def https_redirect(self) -> Optional[bool]:
        """
        If set to true, the URL scheme in the redirected request is set to https. If set to false, the URL scheme of the redirected request will remain the same as that of the request.
        This can only be set if there is at least one (1) edgeSslCertificate set on the service.
        """
        return pulumi.get(self, "https_redirect")

    @property
    @pulumi.getter(name="pathRedirect")
    def path_redirect(self) -> Optional[str]:
        """
        The path that will be used in the redirect response instead of the one that was supplied in the request.
        pathRedirect cannot be supplied together with prefixRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
        The path value must be between 1 and 1024 characters.
        """
        return pulumi.get(self, "path_redirect")

    @property
    @pulumi.getter(name="prefixRedirect")
    def prefix_redirect(self) -> Optional[str]:
        """
        The prefix that replaces the prefixMatch specified in the routeRule, retaining the remaining portion of the URL before redirecting the request.
        prefixRedirect cannot be supplied together with pathRedirect. Supply one alone or neither. If neither is supplied, the path of the original request will be used for the redirect.
        """
        return pulumi.get(self, "prefix_redirect")

    @property
    @pulumi.getter(name="redirectResponseCode")
    def redirect_response_code(self) -> Optional[str]:
        """
        The HTTP Status code to use for this RedirectAction.
        The supported values are:
        - `MOVED_PERMANENTLY_DEFAULT`, which is the default value and corresponds to 301.
        - `FOUND`, which corresponds to 302.
        """
        return pulumi.get(self, "redirect_response_code")

    @property
    @pulumi.getter(name="stripQuery")
    def strip_query(self) -> Optional[bool]:
        """
        If set to true, any accompanying query portion of the original URL is removed prior to redirecting the request. If set to false, the query portion of the original URL is retained.
        """
        return pulumi.get(self, "strip_query")


