# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 memory_size_gb: pulumi.Input[int],
                 alternative_location_id: Optional[pulumi.Input[str]] = None,
                 auth_enabled: Optional[pulumi.Input[bool]] = None,
                 authorized_network: Optional[pulumi.Input[str]] = None,
                 connect_mode: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location_id: Optional[pulumi.Input[str]] = None,
                 maintenance_policy: Optional[pulumi.Input['InstanceMaintenancePolicyArgs']] = None,
                 maintenance_schedule: Optional[pulumi.Input['InstanceMaintenanceScheduleArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 read_replicas_mode: Optional[pulumi.Input[str]] = None,
                 redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 redis_version: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 reserved_ip_range: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[int] memory_size_gb: Redis memory size in GiB.
        :param pulumi.Input[str] alternative_location_id: Only applicable to STANDARD_HA tier which protects the instance
               against zonal failures by provisioning it across two zones.
               If provided, it must be a different zone from the one provided in
               [locationId].
        :param pulumi.Input[bool] auth_enabled: Optional. Indicates whether OSS Redis AUTH is enabled for the
               instance. If set to "true" AUTH is enabled on the instance.
               Default value is "false" meaning AUTH is disabled.
        :param pulumi.Input[str] authorized_network: The full name of the Google Compute Engine network to which the
               instance is connected. If left unspecified, the default network
               will be used.
        :param pulumi.Input[str] connect_mode: The connection mode of the Redis instance.
               Default value is `DIRECT_PEERING`.
               Possible values are `DIRECT_PEERING` and `PRIVATE_SERVICE_ACCESS`.
        :param pulumi.Input[str] display_name: An arbitrary and optional user-provided name for the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Resource labels to represent user provided metadata.
        :param pulumi.Input[str] location_id: The zone where the instance will be provisioned. If not provided,
               the service will choose a zone for the instance. For STANDARD_HA tier,
               instances will be created across two zones for protection against
               zonal failures. If [alternativeLocationId] is also provided, it must
               be different from [locationId].
        :param pulumi.Input['InstanceMaintenancePolicyArgs'] maintenance_policy: Maintenance policy for an instance.
               Structure is documented below.
        :param pulumi.Input['InstanceMaintenanceScheduleArgs'] maintenance_schedule: Upcoming maintenance schedule.
               Structure is documented below.
        :param pulumi.Input[str] name: The ID of the instance or a fully qualified identifier for the instance.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] read_replicas_mode: Optional. Read replica mode. Can only be specified when trying to create the instance. If not set, Memorystore Redis
               backend will default to READ_REPLICAS_DISABLED. - READ_REPLICAS_DISABLED: If disabled, read endpoint will not be
               provided and the instance cannot scale up or down the number of replicas. - READ_REPLICAS_ENABLED: If enabled, read
               endpoint will be provided and the instance can scale up and down the number of replicas. Default value:
               "READ_REPLICAS_DISABLED" Possible values: ["READ_REPLICAS_DISABLED", "READ_REPLICAS_ENABLED"]
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] redis_configs: Redis configuration parameters, according to http://redis.io/topics/config.
               Please check Memorystore documentation for the list of supported parameters:
               https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs
        :param pulumi.Input[str] redis_version: The version of Redis software. If not provided, latest supported
               version will be used. Please check the API documentation linked
               at the top for the latest valid values.
        :param pulumi.Input[str] region: The name of the Redis region of the instance.
        :param pulumi.Input[int] replica_count: Optional. The number of replica nodes. The valid range for the Standard Tier with read replicas enabled is [1-5] and
               defaults to 2. If read replicas are not enabled for a Standard Tier instance, the only valid value is 1 and the default
               is 1. The valid value for basic tier is 0 and the default is also 0.
        :param pulumi.Input[str] reserved_ip_range: The CIDR range of internal addresses that are reserved for this
               instance. If not provided, the service will choose an unused /29
               block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
               unique and non-overlapping with existing subnets in an authorized
               network.
        :param pulumi.Input[str] tier: The service tier of the instance. Must be one of these values:
               - BASIC: standalone instance
               - STANDARD_HA: highly available primary/replica instances
               Default value is `BASIC`.
               Possible values are `BASIC` and `STANDARD_HA`.
        :param pulumi.Input[str] transit_encryption_mode: The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
               - SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentication
               Default value is `DISABLED`.
               Possible values are `SERVER_AUTHENTICATION` and `DISABLED`.
        """
        pulumi.set(__self__, "memory_size_gb", memory_size_gb)
        if alternative_location_id is not None:
            pulumi.set(__self__, "alternative_location_id", alternative_location_id)
        if auth_enabled is not None:
            pulumi.set(__self__, "auth_enabled", auth_enabled)
        if authorized_network is not None:
            pulumi.set(__self__, "authorized_network", authorized_network)
        if connect_mode is not None:
            pulumi.set(__self__, "connect_mode", connect_mode)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location_id is not None:
            pulumi.set(__self__, "location_id", location_id)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if maintenance_schedule is not None:
            pulumi.set(__self__, "maintenance_schedule", maintenance_schedule)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if read_replicas_mode is not None:
            pulumi.set(__self__, "read_replicas_mode", read_replicas_mode)
        if redis_configs is not None:
            pulumi.set(__self__, "redis_configs", redis_configs)
        if redis_version is not None:
            pulumi.set(__self__, "redis_version", redis_version)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if reserved_ip_range is not None:
            pulumi.set(__self__, "reserved_ip_range", reserved_ip_range)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if transit_encryption_mode is not None:
            pulumi.set(__self__, "transit_encryption_mode", transit_encryption_mode)

    @property
    @pulumi.getter(name="memorySizeGb")
    def memory_size_gb(self) -> pulumi.Input[int]:
        """
        Redis memory size in GiB.
        """
        return pulumi.get(self, "memory_size_gb")

    @memory_size_gb.setter
    def memory_size_gb(self, value: pulumi.Input[int]):
        pulumi.set(self, "memory_size_gb", value)

    @property
    @pulumi.getter(name="alternativeLocationId")
    def alternative_location_id(self) -> Optional[pulumi.Input[str]]:
        """
        Only applicable to STANDARD_HA tier which protects the instance
        against zonal failures by provisioning it across two zones.
        If provided, it must be a different zone from the one provided in
        [locationId].
        """
        return pulumi.get(self, "alternative_location_id")

    @alternative_location_id.setter
    def alternative_location_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alternative_location_id", value)

    @property
    @pulumi.getter(name="authEnabled")
    def auth_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Indicates whether OSS Redis AUTH is enabled for the
        instance. If set to "true" AUTH is enabled on the instance.
        Default value is "false" meaning AUTH is disabled.
        """
        return pulumi.get(self, "auth_enabled")

    @auth_enabled.setter
    def auth_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auth_enabled", value)

    @property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the Google Compute Engine network to which the
        instance is connected. If left unspecified, the default network
        will be used.
        """
        return pulumi.get(self, "authorized_network")

    @authorized_network.setter
    def authorized_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorized_network", value)

    @property
    @pulumi.getter(name="connectMode")
    def connect_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The connection mode of the Redis instance.
        Default value is `DIRECT_PEERING`.
        Possible values are `DIRECT_PEERING` and `PRIVATE_SERVICE_ACCESS`.
        """
        return pulumi.get(self, "connect_mode")

    @connect_mode.setter
    def connect_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connect_mode", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary and optional user-provided name for the instance.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource labels to represent user provided metadata.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone where the instance will be provisioned. If not provided,
        the service will choose a zone for the instance. For STANDARD_HA tier,
        instances will be created across two zones for protection against
        zonal failures. If [alternativeLocationId] is also provided, it must
        be different from [locationId].
        """
        return pulumi.get(self, "location_id")

    @location_id.setter
    def location_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_id", value)

    @property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['InstanceMaintenancePolicyArgs']]:
        """
        Maintenance policy for an instance.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['InstanceMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @property
    @pulumi.getter(name="maintenanceSchedule")
    def maintenance_schedule(self) -> Optional[pulumi.Input['InstanceMaintenanceScheduleArgs']]:
        """
        Upcoming maintenance schedule.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_schedule")

    @maintenance_schedule.setter
    def maintenance_schedule(self, value: Optional[pulumi.Input['InstanceMaintenanceScheduleArgs']]):
        pulumi.set(self, "maintenance_schedule", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the instance or a fully qualified identifier for the instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="readReplicasMode")
    def read_replicas_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Read replica mode. Can only be specified when trying to create the instance. If not set, Memorystore Redis
        backend will default to READ_REPLICAS_DISABLED. - READ_REPLICAS_DISABLED: If disabled, read endpoint will not be
        provided and the instance cannot scale up or down the number of replicas. - READ_REPLICAS_ENABLED: If enabled, read
        endpoint will be provided and the instance can scale up and down the number of replicas. Default value:
        "READ_REPLICAS_DISABLED" Possible values: ["READ_REPLICAS_DISABLED", "READ_REPLICAS_ENABLED"]
        """
        return pulumi.get(self, "read_replicas_mode")

    @read_replicas_mode.setter
    def read_replicas_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "read_replicas_mode", value)

    @property
    @pulumi.getter(name="redisConfigs")
    def redis_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Redis configuration parameters, according to http://redis.io/topics/config.
        Please check Memorystore documentation for the list of supported parameters:
        https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs
        """
        return pulumi.get(self, "redis_configs")

    @redis_configs.setter
    def redis_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "redis_configs", value)

    @property
    @pulumi.getter(name="redisVersion")
    def redis_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of Redis software. If not provided, latest supported
        version will be used. Please check the API documentation linked
        at the top for the latest valid values.
        """
        return pulumi.get(self, "redis_version")

    @redis_version.setter
    def redis_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redis_version", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Redis region of the instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of replica nodes. The valid range for the Standard Tier with read replicas enabled is [1-5] and
        defaults to 2. If read replicas are not enabled for a Standard Tier instance, the only valid value is 1 and the default
        is 1. The valid value for basic tier is 0 and the default is also 0.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replica_count", value)

    @property
    @pulumi.getter(name="reservedIpRange")
    def reserved_ip_range(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR range of internal addresses that are reserved for this
        instance. If not provided, the service will choose an unused /29
        block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
        unique and non-overlapping with existing subnets in an authorized
        network.
        """
        return pulumi.get(self, "reserved_ip_range")

    @reserved_ip_range.setter
    def reserved_ip_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reserved_ip_range", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        The service tier of the instance. Must be one of these values:
        - BASIC: standalone instance
        - STANDARD_HA: highly available primary/replica instances
        Default value is `BASIC`.
        Possible values are `BASIC` and `STANDARD_HA`.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
        - SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentication
        Default value is `DISABLED`.
        Possible values are `SERVER_AUTHENTICATION` and `DISABLED`.
        """
        return pulumi.get(self, "transit_encryption_mode")

    @transit_encryption_mode.setter
    def transit_encryption_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_encryption_mode", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 alternative_location_id: Optional[pulumi.Input[str]] = None,
                 auth_enabled: Optional[pulumi.Input[bool]] = None,
                 auth_string: Optional[pulumi.Input[str]] = None,
                 authorized_network: Optional[pulumi.Input[str]] = None,
                 connect_mode: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 current_location_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location_id: Optional[pulumi.Input[str]] = None,
                 maintenance_policy: Optional[pulumi.Input['InstanceMaintenancePolicyArgs']] = None,
                 maintenance_schedule: Optional[pulumi.Input['InstanceMaintenanceScheduleArgs']] = None,
                 memory_size_gb: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]] = None,
                 persistence_iam_identity: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 read_endpoint: Optional[pulumi.Input[str]] = None,
                 read_endpoint_port: Optional[pulumi.Input[int]] = None,
                 read_replicas_mode: Optional[pulumi.Input[str]] = None,
                 redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 redis_version: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 reserved_ip_range: Optional[pulumi.Input[str]] = None,
                 server_ca_certs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerCaCertArgs']]]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[str] alternative_location_id: Only applicable to STANDARD_HA tier which protects the instance
               against zonal failures by provisioning it across two zones.
               If provided, it must be a different zone from the one provided in
               [locationId].
        :param pulumi.Input[bool] auth_enabled: Optional. Indicates whether OSS Redis AUTH is enabled for the
               instance. If set to "true" AUTH is enabled on the instance.
               Default value is "false" meaning AUTH is disabled.
        :param pulumi.Input[str] auth_string: AUTH String set on the instance. This field will only be populated if auth_enabled is true.
        :param pulumi.Input[str] authorized_network: The full name of the Google Compute Engine network to which the
               instance is connected. If left unspecified, the default network
               will be used.
        :param pulumi.Input[str] connect_mode: The connection mode of the Redis instance.
               Default value is `DIRECT_PEERING`.
               Possible values are `DIRECT_PEERING` and `PRIVATE_SERVICE_ACCESS`.
        :param pulumi.Input[str] create_time: -
               Output only. The time when the policy was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param pulumi.Input[str] current_location_id: The current zone where the Redis endpoint is placed. For Basic Tier instances, this will always be the same as the
               [locationId] provided by the user at creation time. For Standard Tier instances, this can be either [locationId] or
               [alternativeLocationId] and can change after a failover event.
        :param pulumi.Input[str] display_name: An arbitrary and optional user-provided name for the instance.
        :param pulumi.Input[str] host: Hostname or IP address of the exposed Redis endpoint used by clients to connect to the service.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Resource labels to represent user provided metadata.
        :param pulumi.Input[str] location_id: The zone where the instance will be provisioned. If not provided,
               the service will choose a zone for the instance. For STANDARD_HA tier,
               instances will be created across two zones for protection against
               zonal failures. If [alternativeLocationId] is also provided, it must
               be different from [locationId].
        :param pulumi.Input['InstanceMaintenancePolicyArgs'] maintenance_policy: Maintenance policy for an instance.
               Structure is documented below.
        :param pulumi.Input['InstanceMaintenanceScheduleArgs'] maintenance_schedule: Upcoming maintenance schedule.
               Structure is documented below.
        :param pulumi.Input[int] memory_size_gb: Redis memory size in GiB.
        :param pulumi.Input[str] name: The ID of the instance or a fully qualified identifier for the instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]] nodes: Output only. Info per node.
        :param pulumi.Input[str] persistence_iam_identity: Output only. Cloud IAM identity used by import / export operations to transfer data to/from Cloud Storage. Format is
               "serviceAccount:". The value may change over time for a given instance so should be checked before each import/export
               operation.
        :param pulumi.Input[int] port: The port number of the exposed Redis endpoint.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] read_endpoint: Output only. Hostname or IP address of the exposed readonly Redis endpoint. Standard tier only. Targets all healthy
               replica nodes in instance. Replication is asynchronous and replica nodes will exhibit some lag behind the primary. Write
               requests must target 'host'.
        :param pulumi.Input[int] read_endpoint_port: Output only. The port number of the exposed readonly redis endpoint. Standard tier only. Write requests should target
               'port'.
        :param pulumi.Input[str] read_replicas_mode: Optional. Read replica mode. Can only be specified when trying to create the instance. If not set, Memorystore Redis
               backend will default to READ_REPLICAS_DISABLED. - READ_REPLICAS_DISABLED: If disabled, read endpoint will not be
               provided and the instance cannot scale up or down the number of replicas. - READ_REPLICAS_ENABLED: If enabled, read
               endpoint will be provided and the instance can scale up and down the number of replicas. Default value:
               "READ_REPLICAS_DISABLED" Possible values: ["READ_REPLICAS_DISABLED", "READ_REPLICAS_ENABLED"]
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] redis_configs: Redis configuration parameters, according to http://redis.io/topics/config.
               Please check Memorystore documentation for the list of supported parameters:
               https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs
        :param pulumi.Input[str] redis_version: The version of Redis software. If not provided, latest supported
               version will be used. Please check the API documentation linked
               at the top for the latest valid values.
        :param pulumi.Input[str] region: The name of the Redis region of the instance.
        :param pulumi.Input[int] replica_count: Optional. The number of replica nodes. The valid range for the Standard Tier with read replicas enabled is [1-5] and
               defaults to 2. If read replicas are not enabled for a Standard Tier instance, the only valid value is 1 and the default
               is 1. The valid value for basic tier is 0 and the default is also 0.
        :param pulumi.Input[str] reserved_ip_range: The CIDR range of internal addresses that are reserved for this
               instance. If not provided, the service will choose an unused /29
               block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
               unique and non-overlapping with existing subnets in an authorized
               network.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceServerCaCertArgs']]] server_ca_certs: List of server CA certificates for the instance.
        :param pulumi.Input[str] tier: The service tier of the instance. Must be one of these values:
               - BASIC: standalone instance
               - STANDARD_HA: highly available primary/replica instances
               Default value is `BASIC`.
               Possible values are `BASIC` and `STANDARD_HA`.
        :param pulumi.Input[str] transit_encryption_mode: The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
               - SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentication
               Default value is `DISABLED`.
               Possible values are `SERVER_AUTHENTICATION` and `DISABLED`.
        """
        if alternative_location_id is not None:
            pulumi.set(__self__, "alternative_location_id", alternative_location_id)
        if auth_enabled is not None:
            pulumi.set(__self__, "auth_enabled", auth_enabled)
        if auth_string is not None:
            pulumi.set(__self__, "auth_string", auth_string)
        if authorized_network is not None:
            pulumi.set(__self__, "authorized_network", authorized_network)
        if connect_mode is not None:
            pulumi.set(__self__, "connect_mode", connect_mode)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if current_location_id is not None:
            pulumi.set(__self__, "current_location_id", current_location_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location_id is not None:
            pulumi.set(__self__, "location_id", location_id)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if maintenance_schedule is not None:
            pulumi.set(__self__, "maintenance_schedule", maintenance_schedule)
        if memory_size_gb is not None:
            pulumi.set(__self__, "memory_size_gb", memory_size_gb)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if persistence_iam_identity is not None:
            pulumi.set(__self__, "persistence_iam_identity", persistence_iam_identity)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if read_endpoint is not None:
            pulumi.set(__self__, "read_endpoint", read_endpoint)
        if read_endpoint_port is not None:
            pulumi.set(__self__, "read_endpoint_port", read_endpoint_port)
        if read_replicas_mode is not None:
            pulumi.set(__self__, "read_replicas_mode", read_replicas_mode)
        if redis_configs is not None:
            pulumi.set(__self__, "redis_configs", redis_configs)
        if redis_version is not None:
            pulumi.set(__self__, "redis_version", redis_version)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if reserved_ip_range is not None:
            pulumi.set(__self__, "reserved_ip_range", reserved_ip_range)
        if server_ca_certs is not None:
            pulumi.set(__self__, "server_ca_certs", server_ca_certs)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if transit_encryption_mode is not None:
            pulumi.set(__self__, "transit_encryption_mode", transit_encryption_mode)

    @property
    @pulumi.getter(name="alternativeLocationId")
    def alternative_location_id(self) -> Optional[pulumi.Input[str]]:
        """
        Only applicable to STANDARD_HA tier which protects the instance
        against zonal failures by provisioning it across two zones.
        If provided, it must be a different zone from the one provided in
        [locationId].
        """
        return pulumi.get(self, "alternative_location_id")

    @alternative_location_id.setter
    def alternative_location_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alternative_location_id", value)

    @property
    @pulumi.getter(name="authEnabled")
    def auth_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Indicates whether OSS Redis AUTH is enabled for the
        instance. If set to "true" AUTH is enabled on the instance.
        Default value is "false" meaning AUTH is disabled.
        """
        return pulumi.get(self, "auth_enabled")

    @auth_enabled.setter
    def auth_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auth_enabled", value)

    @property
    @pulumi.getter(name="authString")
    def auth_string(self) -> Optional[pulumi.Input[str]]:
        """
        AUTH String set on the instance. This field will only be populated if auth_enabled is true.
        """
        return pulumi.get(self, "auth_string")

    @auth_string.setter
    def auth_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_string", value)

    @property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the Google Compute Engine network to which the
        instance is connected. If left unspecified, the default network
        will be used.
        """
        return pulumi.get(self, "authorized_network")

    @authorized_network.setter
    def authorized_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorized_network", value)

    @property
    @pulumi.getter(name="connectMode")
    def connect_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The connection mode of the Redis instance.
        Default value is `DIRECT_PEERING`.
        Possible values are `DIRECT_PEERING` and `PRIVATE_SERVICE_ACCESS`.
        """
        return pulumi.get(self, "connect_mode")

    @connect_mode.setter
    def connect_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connect_mode", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        -
        Output only. The time when the policy was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="currentLocationId")
    def current_location_id(self) -> Optional[pulumi.Input[str]]:
        """
        The current zone where the Redis endpoint is placed. For Basic Tier instances, this will always be the same as the
        [locationId] provided by the user at creation time. For Standard Tier instances, this can be either [locationId] or
        [alternativeLocationId] and can change after a failover event.
        """
        return pulumi.get(self, "current_location_id")

    @current_location_id.setter
    def current_location_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_location_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary and optional user-provided name for the instance.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname or IP address of the exposed Redis endpoint used by clients to connect to the service.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource labels to represent user provided metadata.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone where the instance will be provisioned. If not provided,
        the service will choose a zone for the instance. For STANDARD_HA tier,
        instances will be created across two zones for protection against
        zonal failures. If [alternativeLocationId] is also provided, it must
        be different from [locationId].
        """
        return pulumi.get(self, "location_id")

    @location_id.setter
    def location_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_id", value)

    @property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['InstanceMaintenancePolicyArgs']]:
        """
        Maintenance policy for an instance.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['InstanceMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @property
    @pulumi.getter(name="maintenanceSchedule")
    def maintenance_schedule(self) -> Optional[pulumi.Input['InstanceMaintenanceScheduleArgs']]:
        """
        Upcoming maintenance schedule.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_schedule")

    @maintenance_schedule.setter
    def maintenance_schedule(self, value: Optional[pulumi.Input['InstanceMaintenanceScheduleArgs']]):
        pulumi.set(self, "maintenance_schedule", value)

    @property
    @pulumi.getter(name="memorySizeGb")
    def memory_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Redis memory size in GiB.
        """
        return pulumi.get(self, "memory_size_gb")

    @memory_size_gb.setter
    def memory_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size_gb", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the instance or a fully qualified identifier for the instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]]:
        """
        Output only. Info per node.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter(name="persistenceIamIdentity")
    def persistence_iam_identity(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Cloud IAM identity used by import / export operations to transfer data to/from Cloud Storage. Format is
        "serviceAccount:". The value may change over time for a given instance so should be checked before each import/export
        operation.
        """
        return pulumi.get(self, "persistence_iam_identity")

    @persistence_iam_identity.setter
    def persistence_iam_identity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "persistence_iam_identity", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number of the exposed Redis endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="readEndpoint")
    def read_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Hostname or IP address of the exposed readonly Redis endpoint. Standard tier only. Targets all healthy
        replica nodes in instance. Replication is asynchronous and replica nodes will exhibit some lag behind the primary. Write
        requests must target 'host'.
        """
        return pulumi.get(self, "read_endpoint")

    @read_endpoint.setter
    def read_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "read_endpoint", value)

    @property
    @pulumi.getter(name="readEndpointPort")
    def read_endpoint_port(self) -> Optional[pulumi.Input[int]]:
        """
        Output only. The port number of the exposed readonly redis endpoint. Standard tier only. Write requests should target
        'port'.
        """
        return pulumi.get(self, "read_endpoint_port")

    @read_endpoint_port.setter
    def read_endpoint_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "read_endpoint_port", value)

    @property
    @pulumi.getter(name="readReplicasMode")
    def read_replicas_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Read replica mode. Can only be specified when trying to create the instance. If not set, Memorystore Redis
        backend will default to READ_REPLICAS_DISABLED. - READ_REPLICAS_DISABLED: If disabled, read endpoint will not be
        provided and the instance cannot scale up or down the number of replicas. - READ_REPLICAS_ENABLED: If enabled, read
        endpoint will be provided and the instance can scale up and down the number of replicas. Default value:
        "READ_REPLICAS_DISABLED" Possible values: ["READ_REPLICAS_DISABLED", "READ_REPLICAS_ENABLED"]
        """
        return pulumi.get(self, "read_replicas_mode")

    @read_replicas_mode.setter
    def read_replicas_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "read_replicas_mode", value)

    @property
    @pulumi.getter(name="redisConfigs")
    def redis_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Redis configuration parameters, according to http://redis.io/topics/config.
        Please check Memorystore documentation for the list of supported parameters:
        https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs
        """
        return pulumi.get(self, "redis_configs")

    @redis_configs.setter
    def redis_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "redis_configs", value)

    @property
    @pulumi.getter(name="redisVersion")
    def redis_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of Redis software. If not provided, latest supported
        version will be used. Please check the API documentation linked
        at the top for the latest valid values.
        """
        return pulumi.get(self, "redis_version")

    @redis_version.setter
    def redis_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redis_version", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Redis region of the instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of replica nodes. The valid range for the Standard Tier with read replicas enabled is [1-5] and
        defaults to 2. If read replicas are not enabled for a Standard Tier instance, the only valid value is 1 and the default
        is 1. The valid value for basic tier is 0 and the default is also 0.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replica_count", value)

    @property
    @pulumi.getter(name="reservedIpRange")
    def reserved_ip_range(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR range of internal addresses that are reserved for this
        instance. If not provided, the service will choose an unused /29
        block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
        unique and non-overlapping with existing subnets in an authorized
        network.
        """
        return pulumi.get(self, "reserved_ip_range")

    @reserved_ip_range.setter
    def reserved_ip_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reserved_ip_range", value)

    @property
    @pulumi.getter(name="serverCaCerts")
    def server_ca_certs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerCaCertArgs']]]]:
        """
        List of server CA certificates for the instance.
        """
        return pulumi.get(self, "server_ca_certs")

    @server_ca_certs.setter
    def server_ca_certs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerCaCertArgs']]]]):
        pulumi.set(self, "server_ca_certs", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        The service tier of the instance. Must be one of these values:
        - BASIC: standalone instance
        - STANDARD_HA: highly available primary/replica instances
        Default value is `BASIC`.
        Possible values are `BASIC` and `STANDARD_HA`.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
        - SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentication
        Default value is `DISABLED`.
        Possible values are `SERVER_AUTHENTICATION` and `DISABLED`.
        """
        return pulumi.get(self, "transit_encryption_mode")

    @transit_encryption_mode.setter
    def transit_encryption_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_encryption_mode", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternative_location_id: Optional[pulumi.Input[str]] = None,
                 auth_enabled: Optional[pulumi.Input[bool]] = None,
                 authorized_network: Optional[pulumi.Input[str]] = None,
                 connect_mode: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location_id: Optional[pulumi.Input[str]] = None,
                 maintenance_policy: Optional[pulumi.Input[pulumi.InputType['InstanceMaintenancePolicyArgs']]] = None,
                 maintenance_schedule: Optional[pulumi.Input[pulumi.InputType['InstanceMaintenanceScheduleArgs']]] = None,
                 memory_size_gb: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 read_replicas_mode: Optional[pulumi.Input[str]] = None,
                 redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 redis_version: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 reserved_ip_range: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A Google Cloud Redis instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/memorystore/docs/redis/)

        ## Example Usage
        ### Redis Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cache = gcp.redis.Instance("cache", memory_size_gb=1)
        ```
        ### Redis Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        redis_network = gcp.compute.get_network(name="redis-test-network")
        cache = gcp.redis.Instance("cache",
            tier="STANDARD_HA",
            memory_size_gb=1,
            location_id="us-central1-a",
            alternative_location_id="us-central1-f",
            authorized_network=redis_network.id,
            redis_version="REDIS_4_0",
            display_name="Test Instance",
            reserved_ip_range="192.168.0.0/29",
            labels={
                "my_key": "my_val",
                "other_key": "other_val",
            },
            maintenance_policy=gcp.redis.InstanceMaintenancePolicyArgs(
                weekly_maintenance_windows=[gcp.redis.InstanceMaintenancePolicyWeeklyMaintenanceWindowArgs(
                    day="TUESDAY",
                    start_time=gcp.redis.InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs(
                        hours=0,
                        minutes=30,
                        seconds=0,
                        nanos=0,
                    ),
                )],
            ))
        ```
        ### Redis Instance Private Service

        ```python
        import pulumi
        import pulumi_gcp as gcp

        redis_network = gcp.compute.get_network(name="redis-test-network")
        service_range = gcp.compute.GlobalAddress("serviceRange",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=redis_network.id)
        private_service_connection = gcp.servicenetworking.Connection("privateServiceConnection",
            network=redis_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[service_range.name])
        cache = gcp.redis.Instance("cache",
            tier="STANDARD_HA",
            memory_size_gb=1,
            location_id="us-central1-a",
            alternative_location_id="us-central1-f",
            authorized_network=redis_network.id,
            connect_mode="PRIVATE_SERVICE_ACCESS",
            redis_version="REDIS_4_0",
            display_name="Test Instance",
            opts=pulumi.ResourceOptions(depends_on=[private_service_connection]))
        ```
        ### Redis Instance Mrr

        ```python
        import pulumi
        import pulumi_gcp as gcp

        redis_network = gcp.compute.get_network(name="redis-test-network")
        cache = gcp.redis.Instance("cache",
            tier="STANDARD_HA",
            memory_size_gb=5,
            location_id="us-central1-a",
            alternative_location_id="us-central1-f",
            authorized_network=redis_network.id,
            redis_version="REDIS_6_X",
            display_name="Terraform Test Instance",
            reserved_ip_range="192.168.0.0/28",
            replica_count=5,
            read_replicas_mode="READ_REPLICAS_ENABLED",
            labels={
                "my_key": "my_val",
                "other_key": "other_val",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        Instance can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:redis/instance:Instance default projects/{{project}}/locations/{{region}}/instances/{{name}}
        ```

        ```sh
         $ pulumi import gcp:redis/instance:Instance default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:redis/instance:Instance default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:redis/instance:Instance default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alternative_location_id: Only applicable to STANDARD_HA tier which protects the instance
               against zonal failures by provisioning it across two zones.
               If provided, it must be a different zone from the one provided in
               [locationId].
        :param pulumi.Input[bool] auth_enabled: Optional. Indicates whether OSS Redis AUTH is enabled for the
               instance. If set to "true" AUTH is enabled on the instance.
               Default value is "false" meaning AUTH is disabled.
        :param pulumi.Input[str] authorized_network: The full name of the Google Compute Engine network to which the
               instance is connected. If left unspecified, the default network
               will be used.
        :param pulumi.Input[str] connect_mode: The connection mode of the Redis instance.
               Default value is `DIRECT_PEERING`.
               Possible values are `DIRECT_PEERING` and `PRIVATE_SERVICE_ACCESS`.
        :param pulumi.Input[str] display_name: An arbitrary and optional user-provided name for the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Resource labels to represent user provided metadata.
        :param pulumi.Input[str] location_id: The zone where the instance will be provisioned. If not provided,
               the service will choose a zone for the instance. For STANDARD_HA tier,
               instances will be created across two zones for protection against
               zonal failures. If [alternativeLocationId] is also provided, it must
               be different from [locationId].
        :param pulumi.Input[pulumi.InputType['InstanceMaintenancePolicyArgs']] maintenance_policy: Maintenance policy for an instance.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['InstanceMaintenanceScheduleArgs']] maintenance_schedule: Upcoming maintenance schedule.
               Structure is documented below.
        :param pulumi.Input[int] memory_size_gb: Redis memory size in GiB.
        :param pulumi.Input[str] name: The ID of the instance or a fully qualified identifier for the instance.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] read_replicas_mode: Optional. Read replica mode. Can only be specified when trying to create the instance. If not set, Memorystore Redis
               backend will default to READ_REPLICAS_DISABLED. - READ_REPLICAS_DISABLED: If disabled, read endpoint will not be
               provided and the instance cannot scale up or down the number of replicas. - READ_REPLICAS_ENABLED: If enabled, read
               endpoint will be provided and the instance can scale up and down the number of replicas. Default value:
               "READ_REPLICAS_DISABLED" Possible values: ["READ_REPLICAS_DISABLED", "READ_REPLICAS_ENABLED"]
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] redis_configs: Redis configuration parameters, according to http://redis.io/topics/config.
               Please check Memorystore documentation for the list of supported parameters:
               https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs
        :param pulumi.Input[str] redis_version: The version of Redis software. If not provided, latest supported
               version will be used. Please check the API documentation linked
               at the top for the latest valid values.
        :param pulumi.Input[str] region: The name of the Redis region of the instance.
        :param pulumi.Input[int] replica_count: Optional. The number of replica nodes. The valid range for the Standard Tier with read replicas enabled is [1-5] and
               defaults to 2. If read replicas are not enabled for a Standard Tier instance, the only valid value is 1 and the default
               is 1. The valid value for basic tier is 0 and the default is also 0.
        :param pulumi.Input[str] reserved_ip_range: The CIDR range of internal addresses that are reserved for this
               instance. If not provided, the service will choose an unused /29
               block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
               unique and non-overlapping with existing subnets in an authorized
               network.
        :param pulumi.Input[str] tier: The service tier of the instance. Must be one of these values:
               - BASIC: standalone instance
               - STANDARD_HA: highly available primary/replica instances
               Default value is `BASIC`.
               Possible values are `BASIC` and `STANDARD_HA`.
        :param pulumi.Input[str] transit_encryption_mode: The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
               - SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentication
               Default value is `DISABLED`.
               Possible values are `SERVER_AUTHENTICATION` and `DISABLED`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Google Cloud Redis instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/memorystore/docs/redis/)

        ## Example Usage
        ### Redis Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cache = gcp.redis.Instance("cache", memory_size_gb=1)
        ```
        ### Redis Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        redis_network = gcp.compute.get_network(name="redis-test-network")
        cache = gcp.redis.Instance("cache",
            tier="STANDARD_HA",
            memory_size_gb=1,
            location_id="us-central1-a",
            alternative_location_id="us-central1-f",
            authorized_network=redis_network.id,
            redis_version="REDIS_4_0",
            display_name="Test Instance",
            reserved_ip_range="192.168.0.0/29",
            labels={
                "my_key": "my_val",
                "other_key": "other_val",
            },
            maintenance_policy=gcp.redis.InstanceMaintenancePolicyArgs(
                weekly_maintenance_windows=[gcp.redis.InstanceMaintenancePolicyWeeklyMaintenanceWindowArgs(
                    day="TUESDAY",
                    start_time=gcp.redis.InstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeArgs(
                        hours=0,
                        minutes=30,
                        seconds=0,
                        nanos=0,
                    ),
                )],
            ))
        ```
        ### Redis Instance Private Service

        ```python
        import pulumi
        import pulumi_gcp as gcp

        redis_network = gcp.compute.get_network(name="redis-test-network")
        service_range = gcp.compute.GlobalAddress("serviceRange",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=redis_network.id)
        private_service_connection = gcp.servicenetworking.Connection("privateServiceConnection",
            network=redis_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[service_range.name])
        cache = gcp.redis.Instance("cache",
            tier="STANDARD_HA",
            memory_size_gb=1,
            location_id="us-central1-a",
            alternative_location_id="us-central1-f",
            authorized_network=redis_network.id,
            connect_mode="PRIVATE_SERVICE_ACCESS",
            redis_version="REDIS_4_0",
            display_name="Test Instance",
            opts=pulumi.ResourceOptions(depends_on=[private_service_connection]))
        ```
        ### Redis Instance Mrr

        ```python
        import pulumi
        import pulumi_gcp as gcp

        redis_network = gcp.compute.get_network(name="redis-test-network")
        cache = gcp.redis.Instance("cache",
            tier="STANDARD_HA",
            memory_size_gb=5,
            location_id="us-central1-a",
            alternative_location_id="us-central1-f",
            authorized_network=redis_network.id,
            redis_version="REDIS_6_X",
            display_name="Terraform Test Instance",
            reserved_ip_range="192.168.0.0/28",
            replica_count=5,
            read_replicas_mode="READ_REPLICAS_ENABLED",
            labels={
                "my_key": "my_val",
                "other_key": "other_val",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        Instance can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:redis/instance:Instance default projects/{{project}}/locations/{{region}}/instances/{{name}}
        ```

        ```sh
         $ pulumi import gcp:redis/instance:Instance default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:redis/instance:Instance default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:redis/instance:Instance default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternative_location_id: Optional[pulumi.Input[str]] = None,
                 auth_enabled: Optional[pulumi.Input[bool]] = None,
                 authorized_network: Optional[pulumi.Input[str]] = None,
                 connect_mode: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location_id: Optional[pulumi.Input[str]] = None,
                 maintenance_policy: Optional[pulumi.Input[pulumi.InputType['InstanceMaintenancePolicyArgs']]] = None,
                 maintenance_schedule: Optional[pulumi.Input[pulumi.InputType['InstanceMaintenanceScheduleArgs']]] = None,
                 memory_size_gb: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 read_replicas_mode: Optional[pulumi.Input[str]] = None,
                 redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 redis_version: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_count: Optional[pulumi.Input[int]] = None,
                 reserved_ip_range: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["alternative_location_id"] = alternative_location_id
            __props__.__dict__["auth_enabled"] = auth_enabled
            __props__.__dict__["authorized_network"] = authorized_network
            __props__.__dict__["connect_mode"] = connect_mode
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location_id"] = location_id
            __props__.__dict__["maintenance_policy"] = maintenance_policy
            __props__.__dict__["maintenance_schedule"] = maintenance_schedule
            if memory_size_gb is None and not opts.urn:
                raise TypeError("Missing required property 'memory_size_gb'")
            __props__.__dict__["memory_size_gb"] = memory_size_gb
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["read_replicas_mode"] = read_replicas_mode
            __props__.__dict__["redis_configs"] = redis_configs
            __props__.__dict__["redis_version"] = redis_version
            __props__.__dict__["region"] = region
            __props__.__dict__["replica_count"] = replica_count
            __props__.__dict__["reserved_ip_range"] = reserved_ip_range
            __props__.__dict__["tier"] = tier
            __props__.__dict__["transit_encryption_mode"] = transit_encryption_mode
            __props__.__dict__["auth_string"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["current_location_id"] = None
            __props__.__dict__["host"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["persistence_iam_identity"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["read_endpoint"] = None
            __props__.__dict__["read_endpoint_port"] = None
            __props__.__dict__["server_ca_certs"] = None
        super(Instance, __self__).__init__(
            'gcp:redis/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alternative_location_id: Optional[pulumi.Input[str]] = None,
            auth_enabled: Optional[pulumi.Input[bool]] = None,
            auth_string: Optional[pulumi.Input[str]] = None,
            authorized_network: Optional[pulumi.Input[str]] = None,
            connect_mode: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            current_location_id: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            host: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location_id: Optional[pulumi.Input[str]] = None,
            maintenance_policy: Optional[pulumi.Input[pulumi.InputType['InstanceMaintenancePolicyArgs']]] = None,
            maintenance_schedule: Optional[pulumi.Input[pulumi.InputType['InstanceMaintenanceScheduleArgs']]] = None,
            memory_size_gb: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNodeArgs']]]]] = None,
            persistence_iam_identity: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            read_endpoint: Optional[pulumi.Input[str]] = None,
            read_endpoint_port: Optional[pulumi.Input[int]] = None,
            read_replicas_mode: Optional[pulumi.Input[str]] = None,
            redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            redis_version: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            replica_count: Optional[pulumi.Input[int]] = None,
            reserved_ip_range: Optional[pulumi.Input[str]] = None,
            server_ca_certs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceServerCaCertArgs']]]]] = None,
            tier: Optional[pulumi.Input[str]] = None,
            transit_encryption_mode: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alternative_location_id: Only applicable to STANDARD_HA tier which protects the instance
               against zonal failures by provisioning it across two zones.
               If provided, it must be a different zone from the one provided in
               [locationId].
        :param pulumi.Input[bool] auth_enabled: Optional. Indicates whether OSS Redis AUTH is enabled for the
               instance. If set to "true" AUTH is enabled on the instance.
               Default value is "false" meaning AUTH is disabled.
        :param pulumi.Input[str] auth_string: AUTH String set on the instance. This field will only be populated if auth_enabled is true.
        :param pulumi.Input[str] authorized_network: The full name of the Google Compute Engine network to which the
               instance is connected. If left unspecified, the default network
               will be used.
        :param pulumi.Input[str] connect_mode: The connection mode of the Redis instance.
               Default value is `DIRECT_PEERING`.
               Possible values are `DIRECT_PEERING` and `PRIVATE_SERVICE_ACCESS`.
        :param pulumi.Input[str] create_time: -
               Output only. The time when the policy was created.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
               resolution and up to nine fractional digits.
        :param pulumi.Input[str] current_location_id: The current zone where the Redis endpoint is placed. For Basic Tier instances, this will always be the same as the
               [locationId] provided by the user at creation time. For Standard Tier instances, this can be either [locationId] or
               [alternativeLocationId] and can change after a failover event.
        :param pulumi.Input[str] display_name: An arbitrary and optional user-provided name for the instance.
        :param pulumi.Input[str] host: Hostname or IP address of the exposed Redis endpoint used by clients to connect to the service.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Resource labels to represent user provided metadata.
        :param pulumi.Input[str] location_id: The zone where the instance will be provisioned. If not provided,
               the service will choose a zone for the instance. For STANDARD_HA tier,
               instances will be created across two zones for protection against
               zonal failures. If [alternativeLocationId] is also provided, it must
               be different from [locationId].
        :param pulumi.Input[pulumi.InputType['InstanceMaintenancePolicyArgs']] maintenance_policy: Maintenance policy for an instance.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['InstanceMaintenanceScheduleArgs']] maintenance_schedule: Upcoming maintenance schedule.
               Structure is documented below.
        :param pulumi.Input[int] memory_size_gb: Redis memory size in GiB.
        :param pulumi.Input[str] name: The ID of the instance or a fully qualified identifier for the instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNodeArgs']]]] nodes: Output only. Info per node.
        :param pulumi.Input[str] persistence_iam_identity: Output only. Cloud IAM identity used by import / export operations to transfer data to/from Cloud Storage. Format is
               "serviceAccount:". The value may change over time for a given instance so should be checked before each import/export
               operation.
        :param pulumi.Input[int] port: The port number of the exposed Redis endpoint.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] read_endpoint: Output only. Hostname or IP address of the exposed readonly Redis endpoint. Standard tier only. Targets all healthy
               replica nodes in instance. Replication is asynchronous and replica nodes will exhibit some lag behind the primary. Write
               requests must target 'host'.
        :param pulumi.Input[int] read_endpoint_port: Output only. The port number of the exposed readonly redis endpoint. Standard tier only. Write requests should target
               'port'.
        :param pulumi.Input[str] read_replicas_mode: Optional. Read replica mode. Can only be specified when trying to create the instance. If not set, Memorystore Redis
               backend will default to READ_REPLICAS_DISABLED. - READ_REPLICAS_DISABLED: If disabled, read endpoint will not be
               provided and the instance cannot scale up or down the number of replicas. - READ_REPLICAS_ENABLED: If enabled, read
               endpoint will be provided and the instance can scale up and down the number of replicas. Default value:
               "READ_REPLICAS_DISABLED" Possible values: ["READ_REPLICAS_DISABLED", "READ_REPLICAS_ENABLED"]
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] redis_configs: Redis configuration parameters, according to http://redis.io/topics/config.
               Please check Memorystore documentation for the list of supported parameters:
               https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs
        :param pulumi.Input[str] redis_version: The version of Redis software. If not provided, latest supported
               version will be used. Please check the API documentation linked
               at the top for the latest valid values.
        :param pulumi.Input[str] region: The name of the Redis region of the instance.
        :param pulumi.Input[int] replica_count: Optional. The number of replica nodes. The valid range for the Standard Tier with read replicas enabled is [1-5] and
               defaults to 2. If read replicas are not enabled for a Standard Tier instance, the only valid value is 1 and the default
               is 1. The valid value for basic tier is 0 and the default is also 0.
        :param pulumi.Input[str] reserved_ip_range: The CIDR range of internal addresses that are reserved for this
               instance. If not provided, the service will choose an unused /29
               block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
               unique and non-overlapping with existing subnets in an authorized
               network.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceServerCaCertArgs']]]] server_ca_certs: List of server CA certificates for the instance.
        :param pulumi.Input[str] tier: The service tier of the instance. Must be one of these values:
               - BASIC: standalone instance
               - STANDARD_HA: highly available primary/replica instances
               Default value is `BASIC`.
               Possible values are `BASIC` and `STANDARD_HA`.
        :param pulumi.Input[str] transit_encryption_mode: The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
               - SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentication
               Default value is `DISABLED`.
               Possible values are `SERVER_AUTHENTICATION` and `DISABLED`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["alternative_location_id"] = alternative_location_id
        __props__.__dict__["auth_enabled"] = auth_enabled
        __props__.__dict__["auth_string"] = auth_string
        __props__.__dict__["authorized_network"] = authorized_network
        __props__.__dict__["connect_mode"] = connect_mode
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["current_location_id"] = current_location_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["host"] = host
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location_id"] = location_id
        __props__.__dict__["maintenance_policy"] = maintenance_policy
        __props__.__dict__["maintenance_schedule"] = maintenance_schedule
        __props__.__dict__["memory_size_gb"] = memory_size_gb
        __props__.__dict__["name"] = name
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["persistence_iam_identity"] = persistence_iam_identity
        __props__.__dict__["port"] = port
        __props__.__dict__["project"] = project
        __props__.__dict__["read_endpoint"] = read_endpoint
        __props__.__dict__["read_endpoint_port"] = read_endpoint_port
        __props__.__dict__["read_replicas_mode"] = read_replicas_mode
        __props__.__dict__["redis_configs"] = redis_configs
        __props__.__dict__["redis_version"] = redis_version
        __props__.__dict__["region"] = region
        __props__.__dict__["replica_count"] = replica_count
        __props__.__dict__["reserved_ip_range"] = reserved_ip_range
        __props__.__dict__["server_ca_certs"] = server_ca_certs
        __props__.__dict__["tier"] = tier
        __props__.__dict__["transit_encryption_mode"] = transit_encryption_mode
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alternativeLocationId")
    def alternative_location_id(self) -> pulumi.Output[str]:
        """
        Only applicable to STANDARD_HA tier which protects the instance
        against zonal failures by provisioning it across two zones.
        If provided, it must be a different zone from the one provided in
        [locationId].
        """
        return pulumi.get(self, "alternative_location_id")

    @property
    @pulumi.getter(name="authEnabled")
    def auth_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Optional. Indicates whether OSS Redis AUTH is enabled for the
        instance. If set to "true" AUTH is enabled on the instance.
        Default value is "false" meaning AUTH is disabled.
        """
        return pulumi.get(self, "auth_enabled")

    @property
    @pulumi.getter(name="authString")
    def auth_string(self) -> pulumi.Output[str]:
        """
        AUTH String set on the instance. This field will only be populated if auth_enabled is true.
        """
        return pulumi.get(self, "auth_string")

    @property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> pulumi.Output[str]:
        """
        The full name of the Google Compute Engine network to which the
        instance is connected. If left unspecified, the default network
        will be used.
        """
        return pulumi.get(self, "authorized_network")

    @property
    @pulumi.getter(name="connectMode")
    def connect_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The connection mode of the Redis instance.
        Default value is `DIRECT_PEERING`.
        Possible values are `DIRECT_PEERING` and `PRIVATE_SERVICE_ACCESS`.
        """
        return pulumi.get(self, "connect_mode")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        -
        Output only. The time when the policy was created.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond
        resolution and up to nine fractional digits.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="currentLocationId")
    def current_location_id(self) -> pulumi.Output[str]:
        """
        The current zone where the Redis endpoint is placed. For Basic Tier instances, this will always be the same as the
        [locationId] provided by the user at creation time. For Standard Tier instances, this can be either [locationId] or
        [alternativeLocationId] and can change after a failover event.
        """
        return pulumi.get(self, "current_location_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        An arbitrary and optional user-provided name for the instance.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        Hostname or IP address of the exposed Redis endpoint used by clients to connect to the service.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource labels to represent user provided metadata.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> pulumi.Output[str]:
        """
        The zone where the instance will be provisioned. If not provided,
        the service will choose a zone for the instance. For STANDARD_HA tier,
        instances will be created across two zones for protection against
        zonal failures. If [alternativeLocationId] is also provided, it must
        be different from [locationId].
        """
        return pulumi.get(self, "location_id")

    @property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> pulumi.Output[Optional['outputs.InstanceMaintenancePolicy']]:
        """
        Maintenance policy for an instance.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_policy")

    @property
    @pulumi.getter(name="maintenanceSchedule")
    def maintenance_schedule(self) -> pulumi.Output[Optional['outputs.InstanceMaintenanceSchedule']]:
        """
        Upcoming maintenance schedule.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_schedule")

    @property
    @pulumi.getter(name="memorySizeGb")
    def memory_size_gb(self) -> pulumi.Output[int]:
        """
        Redis memory size in GiB.
        """
        return pulumi.get(self, "memory_size_gb")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The ID of the instance or a fully qualified identifier for the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.InstanceNode']]:
        """
        Output only. Info per node.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="persistenceIamIdentity")
    def persistence_iam_identity(self) -> pulumi.Output[str]:
        """
        Output only. Cloud IAM identity used by import / export operations to transfer data to/from Cloud Storage. Format is
        "serviceAccount:". The value may change over time for a given instance so should be checked before each import/export
        operation.
        """
        return pulumi.get(self, "persistence_iam_identity")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        The port number of the exposed Redis endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="readEndpoint")
    def read_endpoint(self) -> pulumi.Output[str]:
        """
        Output only. Hostname or IP address of the exposed readonly Redis endpoint. Standard tier only. Targets all healthy
        replica nodes in instance. Replication is asynchronous and replica nodes will exhibit some lag behind the primary. Write
        requests must target 'host'.
        """
        return pulumi.get(self, "read_endpoint")

    @property
    @pulumi.getter(name="readEndpointPort")
    def read_endpoint_port(self) -> pulumi.Output[int]:
        """
        Output only. The port number of the exposed readonly redis endpoint. Standard tier only. Write requests should target
        'port'.
        """
        return pulumi.get(self, "read_endpoint_port")

    @property
    @pulumi.getter(name="readReplicasMode")
    def read_replicas_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Optional. Read replica mode. Can only be specified when trying to create the instance. If not set, Memorystore Redis
        backend will default to READ_REPLICAS_DISABLED. - READ_REPLICAS_DISABLED: If disabled, read endpoint will not be
        provided and the instance cannot scale up or down the number of replicas. - READ_REPLICAS_ENABLED: If enabled, read
        endpoint will be provided and the instance can scale up and down the number of replicas. Default value:
        "READ_REPLICAS_DISABLED" Possible values: ["READ_REPLICAS_DISABLED", "READ_REPLICAS_ENABLED"]
        """
        return pulumi.get(self, "read_replicas_mode")

    @property
    @pulumi.getter(name="redisConfigs")
    def redis_configs(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Redis configuration parameters, according to http://redis.io/topics/config.
        Please check Memorystore documentation for the list of supported parameters:
        https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs
        """
        return pulumi.get(self, "redis_configs")

    @property
    @pulumi.getter(name="redisVersion")
    def redis_version(self) -> pulumi.Output[str]:
        """
        The version of Redis software. If not provided, latest supported
        version will be used. Please check the API documentation linked
        at the top for the latest valid values.
        """
        return pulumi.get(self, "redis_version")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The name of the Redis region of the instance.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> pulumi.Output[int]:
        """
        Optional. The number of replica nodes. The valid range for the Standard Tier with read replicas enabled is [1-5] and
        defaults to 2. If read replicas are not enabled for a Standard Tier instance, the only valid value is 1 and the default
        is 1. The valid value for basic tier is 0 and the default is also 0.
        """
        return pulumi.get(self, "replica_count")

    @property
    @pulumi.getter(name="reservedIpRange")
    def reserved_ip_range(self) -> pulumi.Output[str]:
        """
        The CIDR range of internal addresses that are reserved for this
        instance. If not provided, the service will choose an unused /29
        block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
        unique and non-overlapping with existing subnets in an authorized
        network.
        """
        return pulumi.get(self, "reserved_ip_range")

    @property
    @pulumi.getter(name="serverCaCerts")
    def server_ca_certs(self) -> pulumi.Output[Sequence['outputs.InstanceServerCaCert']]:
        """
        List of server CA certificates for the instance.
        """
        return pulumi.get(self, "server_ca_certs")

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Output[Optional[str]]:
        """
        The service tier of the instance. Must be one of these values:
        - BASIC: standalone instance
        - STANDARD_HA: highly available primary/replica instances
        Default value is `BASIC`.
        Possible values are `BASIC` and `STANDARD_HA`.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
        - SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentication
        Default value is `DISABLED`.
        Possible values are `SERVER_AUTHENTICATION` and `DISABLED`.
        """
        return pulumi.get(self, "transit_encryption_mode")

