import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [neptune-db](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonneptune.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class NeptuneDb extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [neptune-db](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonneptune.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to cancel a loader job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelloaderjob
     */
    toCancelLoaderJob(): this;
    /**
     * Grants permission to cancel an ML data processing job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmldataprocessingjob
     */
    toCancelMLDataProcessingJob(): this;
    /**
     * Grants permission to cancel an ML model training job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltrainingjob
     */
    toCancelMLModelTrainingJob(): this;
    /**
     * Grants permission to cancel an ML model transform job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltransformjob
     */
    toCancelMLModelTransformJob(): this;
    /**
     * Grants permission to cancel a query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery
     */
    toCancelQuery(): this;
    /**
     * Grants permission to create an ML endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#createmlendpoint
     */
    toCreateMLEndpoint(): this;
    /**
     * Grants permission to run delete data via query APIs on database
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifQueryLanguage()
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery
     */
    toDeleteDataViaQuery(): this;
    /**
     * Grants permission to delete an ML endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletemlendpoint
     */
    toDeleteMLEndpoint(): this;
    /**
     * Grants permission to delete all the statistics in the database
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletestatistics
     */
    toDeleteStatistics(): this;
    /**
     * Grants permission to check the status of the Neptune engine
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getenginestatus
     */
    toGetEngineStatus(): this;
    /**
     * Grants permission to check the status of a loader job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getloaderjobstatus
     */
    toGetLoaderJobStatus(): this;
    /**
     * Grants permission to check the status of an ML data processing job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmldataprocessingjobstatus
     */
    toGetMLDataProcessingJobStatus(): this;
    /**
     * Grants permission to check the status of an ML endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlendpointstatus
     */
    toGetMLEndpointStatus(): this;
    /**
     * Grants permission to check the status of an ML model training job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltrainingjobstatus
     */
    toGetMLModelTrainingJobStatus(): this;
    /**
     * Grants permission to check the status of an ML model transform job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltransformjobstatus
     */
    toGetMLModelTransformJobStatus(): this;
    /**
     * Grants permission to check the status of all active queries
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifQueryLanguage()
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus
     */
    toGetQueryStatus(): this;
    /**
     * Grants permission to check the status of statistics of the database
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstatisticsstatus
     */
    toGetStatisticsStatus(): this;
    /**
     * Grants permission to fetch stream records from Neptune
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifQueryLanguage()
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstreamrecords
     */
    toGetStreamRecords(): this;
    /**
     * Grants permission to list all the loader jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listloaderjobs
     */
    toListLoaderJobs(): this;
    /**
     * Grants permission to list all the ML data processing jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmldataprocessingjobs
     */
    toListMLDataProcessingJobs(): this;
    /**
     * Grants permission to list all the ML endpoints
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlendpoints
     */
    toListMLEndpoints(): this;
    /**
     * Grants permission to list all the ML model training jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlmodeltrainingjobs
     */
    toListMLModelTrainingJobs(): this;
    /**
     * Grants permission to list all the ML model transform jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlmodeltransformjobs
     */
    toListMLModelTransformJobs(): this;
    /**
     * Grants permission to manage statistics in the database
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#managestatistics
     */
    toManageStatistics(): this;
    /**
     * Grants permission to run read data via query APIs on database
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifQueryLanguage()
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery
     */
    toReadDataViaQuery(): this;
    /**
     * Grants permission to get the token needed for reset and resets the Neptune database
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#resetdatabase
     */
    toResetDatabase(): this;
    /**
     * Grants permission to start a loader job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startloaderjob
     */
    toStartLoaderJob(): this;
    /**
     * Grants permission to start an ML data processing job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmldataprocessingjob
     */
    toStartMLDataProcessingJob(): this;
    /**
     * Grants permission to start an ML model training job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltrainingjob
     */
    toStartMLModelTrainingJob(): this;
    /**
     * Grants permission to start an ML model transform job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltransformjob
     */
    toStartMLModelTransformJob(): this;
    /**
     * Grants permission to run write data via query APIs on database
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifQueryLanguage()
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery
     */
    toWriteDataViaQuery(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type database to the statement
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/get-started.html
     *
     * @param cluster - Identifier for the cluster.
     * @param database - Identifier for the database.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDatabase(cluster: string, database: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by graph model
     *
     * https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-context-keys.html#querylanguage
     *
     * Applies to actions:
     * - .toDeleteDataViaQuery()
     * - .toGetQueryStatus()
     * - .toGetStreamRecords()
     * - .toReadDataViaQuery()
     * - .toWriteDataViaQuery()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifQueryLanguage(value: string | string[], operator?: Operator | string): this;
}
