import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [route53domains](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53domains.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Route53domains extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [route53domains](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53domains.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to accept the transfer of a domain from another AWS account to the current AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html
     */
    toAcceptDomainTransferFromAnotherAwsAccount(): this;
    /**
     * Grants permission to cancel the transfer of a domain from the current AWS account to another AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CancelDomainTransferToAnotherAwsAccount.html
     */
    toCancelDomainTransferToAnotherAwsAccount(): this;
    /**
     * Grants permission to check the availability of one domain name
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CheckDomainAvailability.html
     */
    toCheckDomainAvailability(): this;
    /**
     * Grants permission to check whether a domain name can be transferred to Amazon Route 53
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CheckDomainTransferability.html
     */
    toCheckDomainTransferability(): this;
    /**
     * Grants permission to delete domains
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DeleteDomain.html
     */
    toDeleteDomain(): this;
    /**
     * Grants permission to delete the specified tags for a domain
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DeleteTagsForDomain.html
     */
    toDeleteTagsForDomain(): this;
    /**
     * Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html
     */
    toDisableDomainAutoRenew(): this;
    /**
     * Grants permission to remove the transfer lock on the domain (specifically the clientTransferProhibited status) to allow domain transfers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainTransferLock.html
     */
    toDisableDomainTransferLock(): this;
    /**
     * Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html
     */
    toEnableDomainAutoRenew(): this;
    /**
     * Grants permission to set the transfer lock on the domain (specifically the clientTransferProhibited status) to prevent domain transfers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_EnableDomainTransferLock.html
     */
    toEnableDomainTransferLock(): this;
    /**
     * Grants permission to get information about whether the registrant contact has responded for operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetContactReachabilityStatus.html
     */
    toGetContactReachabilityStatus(): this;
    /**
     * Grants permission to get detailed information about a domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainDetail.html
     */
    toGetDomainDetail(): this;
    /**
     * Grants permission to get a list of suggested domain names given a string, which can either be a domain name or simply a word or phrase (without spaces)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainSuggestions.html
     */
    toGetDomainSuggestions(): this;
    /**
     * Grants permission to get the current status of an operation that is not completed
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html
     */
    toGetOperationDetail(): this;
    /**
     * Grants permission to list all the domain names registered with Amazon Route 53 for the current AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListDomains.html
     */
    toListDomains(): this;
    /**
     * Grants permission to list the operation IDs of operations that are not yet complete
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html
     */
    toListOperations(): this;
    /**
     * Grants permission to list the prices of operations for TLDs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListPrices.html
     */
    toListPrices(): this;
    /**
     * Grants permission to list all the tags that are associated with the specified domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListTagsForDomain.html
     */
    toListTagsForDomain(): this;
    /**
     * Grants permission to register domains
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RegisterDomain.html
     */
    toRegisterDomain(): this;
    /**
     * Grants permission to reject the transfer of a domain from another AWS account to the current AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RejectDomainTransferFromAnotherAwsAccount.html
     */
    toRejectDomainTransferFromAnotherAwsAccount(): this;
    /**
     * Grants permission to renew domains for the specified number of years
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RenewDomain.html
     */
    toRenewDomain(): this;
    /**
     * Grants permission to resend the confirmation email to the current email address for the registrant contact for operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ResendContactReachabilityEmail.html
     */
    toResendContactReachabilityEmail(): this;
    /**
     * Grants permission to get the AuthCode for the domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RetrieveDomainAuthCode.html
     */
    toRetrieveDomainAuthCode(): this;
    /**
     * Grants permission to transfer a domain from another registrar to Amazon Route 53
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomain.html
     */
    toTransferDomain(): this;
    /**
     * Grants permission to transfer a domain from the current AWS account to another AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html
     */
    toTransferDomainToAnotherAwsAccount(): this;
    /**
     * Grants permission to update the contact information for domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContact.html
     */
    toUpdateDomainContact(): this;
    /**
     * Grants permission to update the domain contact privacy setting
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContactPrivacy.html
     */
    toUpdateDomainContactPrivacy(): this;
    /**
     * Grants permission to replace the current set of name servers for a domain with the specified set of name servers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainNameservers.html
     */
    toUpdateDomainNameservers(): this;
    /**
     * Grants permission to add or update tags for a specified domain
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateTagsForDomain.html
     */
    toUpdateTagsForDomain(): this;
    /**
     * Grants permission to get all the domain-related billing records for the current AWS account for a specified period
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ViewBilling.html
     */
    toViewBilling(): this;
    protected accessLevelList: AccessLevelList;
}
