# Generated by Django 3.2.11 on 2022-01-28 14:19

import edc_model.validators.date
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("meta_prn", "0015_auto_20211104_1447"),
    ]

    operations = [
        migrations.AddField(
            model_name="endofstudy",
            name="clinical_withdrawal_reason",
            field=models.CharField(
                blank=True,
                choices=[
                    ("pregnancy", "Pregnancy"),
                    ("kidney_disease", "Development of chronic kidney disease"),
                    ("liver_disease", "Development of chronic liver disease"),
                    (
                        "intercurrent_illness",
                        "Intercurrent illness which prevents further treatment",
                    ),
                    ("investigator_decision", "Investigator decision"),
                    (
                        "OTHER",
                        "Other condition that justifies the discontinuation of treatment in the clinician’s opinion (specify below)",
                    ),
                ],
                max_length=25,
                null=True,
                verbose_name="If withdrawn for `clinical` reasons, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="endofstudy",
            name="clinical_withdrawal_reason_other",
            field=models.TextField(
                blank=True,
                max_length=500,
                null=True,
                verbose_name="If other `clinical` reason, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="endofstudy",
            name="last_seen_date",
            field=models.DateField(
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="Date patient was last seen",
            ),
        ),
        migrations.AddField(
            model_name="endofstudy",
            name="toxicity_withdrawal_reason",
            field=models.CharField(
                blank=True,
                choices=[
                    (
                        "lactic_acidosis",
                        "Development of lactic acidosis or hyperlactatemia",
                    ),
                    ("hepatomegaly", "Development of hepatomegaly with steatosis"),
                    ("OTHER", "Other (specify below)"),
                ],
                max_length=25,
                null=True,
                verbose_name="If withdrawn for a `toxicity`, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="endofstudy",
            name="toxicity_withdrawal_reason_other",
            field=models.TextField(
                blank=True,
                max_length=500,
                null=True,
                verbose_name="If other `toxicity`, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="historicalendofstudy",
            name="clinical_withdrawal_reason",
            field=models.CharField(
                blank=True,
                choices=[
                    ("pregnancy", "Pregnancy"),
                    ("kidney_disease", "Development of chronic kidney disease"),
                    ("liver_disease", "Development of chronic liver disease"),
                    (
                        "intercurrent_illness",
                        "Intercurrent illness which prevents further treatment",
                    ),
                    ("investigator_decision", "Investigator decision"),
                    (
                        "OTHER",
                        "Other condition that justifies the discontinuation of treatment in the clinician’s opinion (specify below)",
                    ),
                ],
                max_length=25,
                null=True,
                verbose_name="If withdrawn for `clinical` reasons, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="historicalendofstudy",
            name="clinical_withdrawal_reason_other",
            field=models.TextField(
                blank=True,
                max_length=500,
                null=True,
                verbose_name="If other `clinical` reason, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="historicalendofstudy",
            name="last_seen_date",
            field=models.DateField(
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="Date patient was last seen",
            ),
        ),
        migrations.AddField(
            model_name="historicalendofstudy",
            name="toxicity_withdrawal_reason",
            field=models.CharField(
                blank=True,
                choices=[
                    (
                        "lactic_acidosis",
                        "Development of lactic acidosis or hyperlactatemia",
                    ),
                    ("hepatomegaly", "Development of hepatomegaly with steatosis"),
                    ("OTHER", "Other (specify below)"),
                ],
                max_length=25,
                null=True,
                verbose_name="If withdrawn for a `toxicity`, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="historicalendofstudy",
            name="toxicity_withdrawal_reason_other",
            field=models.TextField(
                blank=True,
                max_length=500,
                null=True,
                verbose_name="If other `toxicity`, please specify ...",
            ),
        ),
    ]
