# Generated by Django 4.0.5 on 2022-06-25 18:48

import django.db.models.deletion
import edc_model.validators.date
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        (
            "edc_protocol_incident",
            "0005_protocolincident_historicalprotocolincident_and_more",
        ),
        ("meta_prn", "0024_alter_protocoldeviationviolation_violation"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="historicalprotocoldeviationviolation",
            options={
                "get_latest_by": "history_date",
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical Protocol Incident",
            },
        ),
        migrations.AlterModelOptions(
            name="protocoldeviationviolation",
            options={
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
                "get_latest_by": "modified",
                "ordering": ("-modified", "-created"),
                "verbose_name": "Protocol Incident",
                "verbose_name_plural": "Protocol Incident",
            },
        ),
        migrations.RenameField(
            model_name="historicalprotocoldeviationviolation",
            old_name="violation_other",
            new_name="incident_other",
        ),
        migrations.RenameField(
            model_name="historicalprotocoldeviationviolation",
            old_name="violation",
            new_name="incident",
        ),
        migrations.RenameField(
            model_name="historicalprotocoldeviationviolation",
            old_name="violation_datetime",
            new_name="incident_datetime",
        ),
        migrations.RenameField(
            model_name="historicalprotocoldeviationviolation",
            old_name="violation_description",
            new_name="incident_description",
        ),
        migrations.RenameField(
            model_name="historicalprotocoldeviationviolation",
            old_name="violation_reason",
            new_name="incident_reason",
        ),
        migrations.RenameField(
            model_name="protocoldeviationviolation",
            old_name="violation",
            new_name="incident",
        ),
        migrations.RenameField(
            model_name="protocoldeviationviolation",
            old_name="violation_other",
            new_name="incident_other",
        ),
        migrations.RenameField(
            model_name="protocoldeviationviolation",
            old_name="violation_datetime",
            new_name="incident_datetime",
        ),
        migrations.RenameField(
            model_name="protocoldeviationviolation",
            old_name="violation_description",
            new_name="incident_description",
        ),
        migrations.RenameField(
            model_name="protocoldeviationviolation",
            old_name="violation_reason",
            new_name="incident_reason",
        ),
        migrations.AlterField(
            model_name="historicalprotocoldeviationviolation",
            name="report_type",
            field=models.CharField(
                choices=[
                    ("protocol_violation", "Protocol violation"),
                    ("protocol_deviation", "Protocol deviation"),
                ],
                max_length=25,
                verbose_name="Type of incident",
            ),
        ),
        migrations.AlterField(
            model_name="historicalprotocoldeviationviolation",
            name="safety_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                verbose_name="Could this incident have an impact on safety of the participant?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalprotocoldeviationviolation",
            name="short_description",
            field=models.CharField(
                help_text="Max 35 characters. Note: there is additional space below for a more detailed description",
                max_length=35,
                null=True,
                verbose_name="Provide a short description of this incident",
            ),
        ),
        migrations.AlterField(
            model_name="historicalprotocoldeviationviolation",
            name="study_outcomes_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                verbose_name="Could this incident have an impact on study outcomes?",
            ),
        ),
        migrations.AlterField(
            model_name="protocoldeviationviolation",
            name="report_type",
            field=models.CharField(
                choices=[
                    ("protocol_violation", "Protocol violation"),
                    ("protocol_deviation", "Protocol deviation"),
                ],
                max_length=25,
                verbose_name="Type of incident",
            ),
        ),
        migrations.AlterField(
            model_name="protocoldeviationviolation",
            name="safety_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                verbose_name="Could this incident have an impact on safety of the participant?",
            ),
        ),
        migrations.AlterField(
            model_name="protocoldeviationviolation",
            name="short_description",
            field=models.CharField(
                help_text="Max 35 characters. Note: there is additional space below for a more detailed description",
                max_length=35,
                null=True,
                verbose_name="Provide a short description of this incident",
            ),
        ),
        migrations.AlterField(
            model_name="protocoldeviationviolation",
            name="study_outcomes_impact",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=25,
                verbose_name="Could this incident have an impact on study outcomes?",
            ),
        ),
    ]
