# Generated by Django 2.2.6 on 2019-10-18 19:24

import uuid

import _socket
import django.contrib.sites.managers
import django.core.validators
import django.db.models.deletion
import django.utils.timezone
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_lab.managers
import edc_model.validators.date
import edc_model_fields.fields.initials_field
import edc_model_fields.fields.other_charfield
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
import simple_history.models
from django.conf import settings
from django.db import migrations, models

import meta_subject.models.subject_visit


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("meta_lists", "0001_initial"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("edc_appointment", "0020_auto_20190922_0439"),
        ("edc_action_item", "0023_auto_20191007_0520"),
        ("edc_lab", "0019_auto_20190305_0123"),
        ("sites", "0002_alter_domain_unique"),
    ]

    operations = [
        migrations.CreateModel(
            name="SubjectVisit",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "visit_schedule_name",
                    models.CharField(
                        editable=False,
                        help_text='the name of the visit schedule used to find the "schedule"',
                        max_length=25,
                    ),
                ),
                ("schedule_name", models.CharField(editable=False, max_length=25)),
                (
                    "visit_code",
                    models.CharField(editable=False, max_length=25, null=True),
                ),
                (
                    "visit_code_sequence",
                    models.IntegerField(
                        blank=True,
                        default=0,
                        help_text="An integer to represent the sequence of additional appointments relative to the base appointment, 0, needed to complete data collection for the timepoint. (NNNN.0)",
                        null=True,
                        verbose_name="Sequence",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="Date and time of this report",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report date and time",
                    ),
                ),
                (
                    "reason_unscheduled_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the unscheduled visit is "other", specify',
                    ),
                ),
                (
                    "reason_missed",
                    models.CharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'missed', provide the reason for the missed visit",
                    ),
                ),
                (
                    "reason_missed_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the missed visit is "other", specify',
                    ),
                ),
                (
                    "study_status",
                    models.CharField(
                        max_length=50,
                        null=True,
                        verbose_name="What is the participant's current study status",
                    ),
                ),
                (
                    "require_crfs",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=10,
                        verbose_name="Are scheduled data being submitted with this visit?",
                    ),
                ),
                (
                    "info_source_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name='If "Other" source of information, specify',
                    ),
                ),
                (
                    "survival_status",
                    models.CharField(
                        choices=[
                            ("alive", "Alive"),
                            ("dead", "Deceased"),
                            ("unknown", "Unknown"),
                        ],
                        default="alive",
                        max_length=10,
                        null=True,
                        verbose_name="Participant's survival status",
                    ),
                ),
                (
                    "last_alive_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                        verbose_name="Date participant last known alive",
                    ),
                ),
                (
                    "comments",
                    models.TextField(
                        blank=True,
                        max_length=250,
                        null=True,
                        verbose_name="Comment if any additional pertinent information about the participant",
                    ),
                ),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("scheduled", "Scheduled visit"),
                            ("unscheduled", "Unscheduled visit"),
                            ("missed", "Missed visit"),
                        ],
                        max_length=25,
                        verbose_name="What is the reason for this visit report?",
                    ),
                ),
                (
                    "reason_unscheduled",
                    models.CharField(
                        choices=[
                            (
                                "patient_unwell_outpatient",
                                "Patient unwell (outpatient)",
                            ),
                            ("patient_hospitalised", "Patient hospitalised"),
                            ("routine_non_study", "Routine appointment (non-study)"),
                            ("recurrence_symptoms", "Recurrence of symptoms"),
                            ("OTHER", "Other"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If 'unscheduled', provide reason for the unscheduled visit",
                    ),
                ),
                (
                    "info_source",
                    models.CharField(
                        choices=[
                            ("hospital_notes", "Hospital notes"),
                            ("outpatient_cards", "Outpatient cards"),
                            ("patient", "Patient"),
                            (
                                "collateral_history",
                                "Collateral History from relative/guardian",
                            ),
                            ("OTHER", "Other"),
                        ],
                        max_length=25,
                        verbose_name="What is the main source of this information?",
                    ),
                ),
                (
                    "appointment",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_appointment.Appointment",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "ordering": (
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "visit_code",
                    "visit_code_sequence",
                    "report_datetime",
                ),
                "abstract": False,
            },
            managers=[("on_site", edc_visit_tracking.managers.VisitCurrentSiteManager())],
        ),
        migrations.CreateModel(
            name="UrineDipstickTest",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Was the urine dipstick test performed?",
                    ),
                ),
                (
                    "not_performed_reason",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If NO, provide reason",
                    ),
                ),
                (
                    "ketones",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("N/A", "Not Applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Ketones?",
                    ),
                ),
                (
                    "protein",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("N/A", "Not Applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Protein?",
                    ),
                ),
                (
                    "glucose",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("N/A", "Not Applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Glucose?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={"verbose_name": "Urine Dipstick Test", "abstract": False},
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="SubjectRequisition",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="a field used for quick search",
                        max_length=250,
                        null=True,
                    ),
                ),
                (
                    "requisition_identifier",
                    models.CharField(
                        max_length=50, unique=True, verbose_name="Requisition Id"
                    ),
                ),
                (
                    "identifier_prefix",
                    models.CharField(editable=False, max_length=50, null=True, unique=True),
                ),
                (
                    "primary_aliquot_identifier",
                    models.CharField(editable=False, max_length=18, null=True, unique=True),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "clinic_verified",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")], max_length=15, null=True
                    ),
                ),
                ("clinic_verified_datetime", models.DateTimeField(null=True)),
                ("received", models.BooleanField(default=False)),
                ("received_datetime", models.DateTimeField(blank=True, null=True)),
                ("processed", models.BooleanField(default=False)),
                ("processed_datetime", models.DateTimeField(blank=True, null=True)),
                ("packed", models.BooleanField(default=False)),
                ("packed_datetime", models.DateTimeField(blank=True, null=True)),
                ("shipped", models.BooleanField(default=False)),
                ("shipped_datetime", models.DateTimeField(blank=True, null=True)),
                (
                    "requisition_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Requisition Date",
                    ),
                ),
                (
                    "drawn_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="If not drawn, leave blank.",
                        null=True,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Date / Time Specimen Drawn",
                    ),
                ),
                (
                    "is_drawn",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If No, provide a reason below",
                        max_length=3,
                        verbose_name="Was a specimen drawn?",
                    ),
                ),
                (
                    "reason_not_drawn",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            (
                                "collection_failed",
                                "Tried, but unable to obtain sample from patient",
                            ),
                            ("absent", "Patient did not attend visit"),
                            ("refused", "Patient refused"),
                            ("no_supplies", "No supplies"),
                            ("NOT_REQUIRED", "No longer required for this visit"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If not drawn, please explain",
                    ),
                ),
                (
                    "reason_not_drawn_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If Other, specify ...",
                    ),
                ),
                (
                    "protocol_number",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "clinician_initials",
                    edc_model_fields.fields.initials_field.InitialsField(
                        blank=True,
                        help_text="Type 2-3 letters, all in uppercase and no spaces",
                        max_length=3,
                        null=True,
                        verbose_name="Initials",
                    ),
                ),
                (
                    "specimen_type",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Specimen type",
                    ),
                ),
                (
                    "item_type",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("tube", "Tube"),
                            ("finger_prick", "Finger prick"),
                            ("swab", "Swab"),
                            ("dbs", "DBS Card"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Item collection type",
                    ),
                ),
                (
                    "item_count",
                    models.IntegerField(
                        blank=True,
                        help_text="Number of tubes, samples, cards, etc being sent for this test/order only. Determines number of labels to print",
                        null=True,
                        verbose_name="Number of items",
                    ),
                ),
                (
                    "estimated_volume",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text='If applicable, estimated volume of sample for this test/order. This is the total volume if number of "tubes" above is greater than 1',
                        max_digits=7,
                        null=True,
                        verbose_name="Estimated volume in mL",
                    ),
                ),
                ("comments", models.TextField(blank=True, max_length=25, null=True)),
                (
                    "panel",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_lab.Panel",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={"abstract": False},
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_lab.managers.RequisitionManager()),
            ],
        ),
        migrations.CreateModel(
            name="PatientHistory",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "weight",
                    models.DecimalField(
                        decimal_places=1,
                        help_text="kg",
                        max_digits=4,
                        validators=[
                            django.core.validators.MinValueValidator(20),
                            django.core.validators.MaxValueValidator(150),
                        ],
                        verbose_name="Weight:",
                    ),
                ),
                (
                    "sys_blood_pressure",
                    models.IntegerField(
                        help_text="in mm. format SYS, e.g. 120",
                        validators=[
                            django.core.validators.MinValueValidator(50),
                            django.core.validators.MaxValueValidator(220),
                        ],
                        verbose_name="Blood pressure: systolic",
                    ),
                ),
                (
                    "dia_blood_pressure",
                    models.IntegerField(
                        help_text="in Hg. format DIA, e.g. 80",
                        validators=[
                            django.core.validators.MinValueValidator(20),
                            django.core.validators.MaxValueValidator(150),
                        ],
                        verbose_name="Blood pressure: diastolic",
                    ),
                ),
                (
                    "heart_rate",
                    models.IntegerField(
                        help_text="BPM",
                        validators=[
                            django.core.validators.MinValueValidator(30),
                            django.core.validators.MaxValueValidator(200),
                        ],
                        verbose_name="Heart rate:",
                    ),
                ),
                (
                    "respiratory_rate",
                    models.IntegerField(
                        help_text="breaths/min",
                        validators=[
                            django.core.validators.MinValueValidator(6),
                            django.core.validators.MaxValueValidator(50),
                        ],
                        verbose_name="Respiratory rate:",
                    ),
                ),
                (
                    "temperature",
                    models.DecimalField(
                        decimal_places=1,
                        help_text="in degrees Celcius",
                        max_digits=3,
                        validators=[
                            django.core.validators.MinValueValidator(30),
                            django.core.validators.MaxValueValidator(45),
                        ],
                        verbose_name="Temperature:",
                    ),
                ),
                (
                    "other_symptoms",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If Other, specify ...",
                    ),
                ),
                (
                    "hiv_diagnosis_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="When was the diagnosis of HIV made?",
                    ),
                ),
                (
                    "arv_initiation_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="Date of start of antiretroviral therapy (ART)",
                    ),
                ),
                (
                    "viral_load",
                    models.IntegerField(
                        blank=True,
                        help_text="copies/mL",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(999999),
                        ],
                        verbose_name="Last viral load",
                    ),
                ),
                (
                    "viral_load_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date of last viral load"
                    ),
                ),
                (
                    "cd4",
                    models.IntegerField(
                        blank=True,
                        help_text="cells/mm<sup>3</sup>",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(3000),
                        ],
                        verbose_name="Last CD4",
                    ),
                ),
                (
                    "cd4_date",
                    models.DateField(blank=True, null=True, verbose_name="Date of last CD4"),
                ),
                (
                    "other_current_arv_regimen",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If Other, specify ...",
                    ),
                ),
                (
                    "current_arv_regimen_start_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="When did the patient start this current antiretroviral therapy regimen?",
                    ),
                ),
                (
                    "has_previous_arv_regimen",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient been on any previous regimen?",
                    ),
                ),
                (
                    "other_previous_arv_regimen",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If Other, specify ...",
                    ),
                ),
                (
                    "on_oi_prophylaxis",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient on any prophylaxis against opportunistic infections?",
                    ),
                ),
                (
                    "other_oi_prophylaxis",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If Other, specify ...",
                    ),
                ),
                (
                    "hypertension",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient been diagnosed with hypertension?",
                    ),
                ),
                (
                    "on_hypertension_treatment",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient on treatment for hypertension?",
                    ),
                ),
                (
                    "hypertension_treatment",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="What medications is the patient currently taking for hypertension?",
                    ),
                ),
                (
                    "statins",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient currently taking any statins?",
                    ),
                ),
                (
                    "current_smoker",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient a current smoker?",
                    ),
                ),
                (
                    "former_smoker",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Is the patient a previous smoker?",
                    ),
                ),
                (
                    "other_past_year_symptoms",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If Other, specify ...",
                    ),
                ),
                (
                    "family_diabetics",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has anyone in your immediate family (parents, siblings, children) ever been diagnosed with diabetes?",
                    ),
                ),
                (
                    "is_heartbeat_regular",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the heart beat regular?",
                    ),
                ),
                (
                    "irregular_heartbeat",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If the heartbeat is NOT regular, please describe",
                    ),
                ),
                (
                    "waist_circumference",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="in cm",
                        max_digits=8,
                        verbose_name="Waist circumference",
                    ),
                ),
                (
                    "jaundice",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Jaundice",
                    ),
                ),
                (
                    "peripheral_oedema",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Presence of peripheral oedema",
                    ),
                ),
                (
                    "has_abdominal_tenderness",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Abdominal tenderness on palpation",
                    ),
                ),
                (
                    "abdominal_tenderness",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If YES, abdominal tenderness, please describe",
                    ),
                ),
                (
                    "has_enlarged_liver",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Enlarged liver on palpation",
                    ),
                ),
                (
                    "current_arv_regimen",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="current_arv_regimen",
                        to="meta_lists.ArvRegimens",
                        verbose_name="Which antiretroviral therapy regimen is the patient currently on?",
                    ),
                ),
                (
                    "diabetes_symptoms",
                    models.ManyToManyField(
                        to="meta_lists.DiabetesSymptoms",
                        verbose_name="In the past year, have you had any of the following symptoms?",
                    ),
                ),
                (
                    "oi_prophylaxis",
                    models.ManyToManyField(
                        blank=True,
                        to="meta_lists.OiProphylaxis",
                        verbose_name="If YES, which prophylaxis is the patient on?",
                    ),
                ),
                (
                    "previous_arv_regimen",
                    models.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="previous_arv_regimen",
                        to="meta_lists.ArvRegimens",
                        verbose_name="Which antiretroviral therapy regimen was the patient previously on?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.SubjectVisit",
                    ),
                ),
                (
                    "symptoms",
                    models.ManyToManyField(
                        to="meta_lists.Symptoms",
                        verbose_name="Do you have any of the following symptoms?",
                    ),
                ),
            ],
            options={
                "verbose_name": "Patient History",
                "verbose_name_plural": "Patient History",
                "abstract": False,
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="MedicationAdherence",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "visual_score",
                    models.IntegerField(help_text="%", verbose_name="Visual score"),
                ),
                (
                    "last_missed_pill",
                    models.CharField(
                        choices=[
                            ("today", "today"),
                            ("yesterday", "yesterday"),
                            ("earlier_this_week", "earlier this week"),
                            ("last_week", "last week"),
                            ("lt_month_ago", "less than a month ago"),
                            ("gt_month_ago", "more than a month ago"),
                            ("NEVER", "have never missed taking my study pills"),
                        ],
                        max_length=25,
                        verbose_name="When was the last time you missed your study pill?",
                    ),
                ),
                (
                    "pill_count",
                    models.IntegerField(verbose_name="Number of pills left in the bottle"),
                ),
                (
                    "missed_pill_reason",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Reasons for missing study pills",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Medication Adherence",
                "verbose_name_plural": "Medication Adherence",
                "abstract": False,
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="MalariaRapidTest",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Was the malaria rapid test performed?",
                    ),
                ),
                (
                    "not_performed_reason",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If NO, provide reason",
                    ),
                ),
                (
                    "result",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("N/A", "Not Applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Result",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={"verbose_name": "Malaria Rapid Test", "abstract": False},
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HistoricalUrineDipstickTest",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Was the urine dipstick test performed?",
                    ),
                ),
                (
                    "not_performed_reason",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If NO, provide reason",
                    ),
                ),
                (
                    "ketones",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("N/A", "Not Applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Ketones?",
                    ),
                ),
                (
                    "protein",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("N/A", "Not Applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Protein?",
                    ),
                ),
                (
                    "glucose",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("N/A", "Not Applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Glucose?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Urine Dipstick Test",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSubjectVisit",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "visit_schedule_name",
                    models.CharField(
                        editable=False,
                        help_text='the name of the visit schedule used to find the "schedule"',
                        max_length=25,
                    ),
                ),
                ("schedule_name", models.CharField(editable=False, max_length=25)),
                (
                    "visit_code",
                    models.CharField(editable=False, max_length=25, null=True),
                ),
                (
                    "visit_code_sequence",
                    models.IntegerField(
                        blank=True,
                        default=0,
                        help_text="An integer to represent the sequence of additional appointments relative to the base appointment, 0, needed to complete data collection for the timepoint. (NNNN.0)",
                        null=True,
                        verbose_name="Sequence",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="Date and time of this report",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report date and time",
                    ),
                ),
                (
                    "reason_unscheduled_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the unscheduled visit is "other", specify',
                    ),
                ),
                (
                    "reason_missed",
                    models.CharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'missed', provide the reason for the missed visit",
                    ),
                ),
                (
                    "reason_missed_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name='If the reason for the missed visit is "other", specify',
                    ),
                ),
                (
                    "study_status",
                    models.CharField(
                        max_length=50,
                        null=True,
                        verbose_name="What is the participant's current study status",
                    ),
                ),
                (
                    "require_crfs",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        max_length=10,
                        verbose_name="Are scheduled data being submitted with this visit?",
                    ),
                ),
                (
                    "info_source_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name='If "Other" source of information, specify',
                    ),
                ),
                (
                    "survival_status",
                    models.CharField(
                        choices=[
                            ("alive", "Alive"),
                            ("dead", "Deceased"),
                            ("unknown", "Unknown"),
                        ],
                        default="alive",
                        max_length=10,
                        null=True,
                        verbose_name="Participant's survival status",
                    ),
                ),
                (
                    "last_alive_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[
                            edc_protocol.validators.date_not_before_study_start,
                            edc_model.validators.date.date_not_future,
                        ],
                        verbose_name="Date participant last known alive",
                    ),
                ),
                (
                    "comments",
                    models.TextField(
                        blank=True,
                        max_length=250,
                        null=True,
                        verbose_name="Comment if any additional pertinent information about the participant",
                    ),
                ),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("scheduled", "Scheduled visit"),
                            ("unscheduled", "Unscheduled visit"),
                            ("missed", "Missed visit"),
                        ],
                        max_length=25,
                        verbose_name="What is the reason for this visit report?",
                    ),
                ),
                (
                    "reason_unscheduled",
                    models.CharField(
                        choices=[
                            (
                                "patient_unwell_outpatient",
                                "Patient unwell (outpatient)",
                            ),
                            ("patient_hospitalised", "Patient hospitalised"),
                            ("routine_non_study", "Routine appointment (non-study)"),
                            ("recurrence_symptoms", "Recurrence of symptoms"),
                            ("OTHER", "Other"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If 'unscheduled', provide reason for the unscheduled visit",
                    ),
                ),
                (
                    "info_source",
                    models.CharField(
                        choices=[
                            ("hospital_notes", "Hospital notes"),
                            ("outpatient_cards", "Outpatient cards"),
                            ("patient", "Patient"),
                            (
                                "collateral_history",
                                "Collateral History from relative/guardian",
                            ),
                            ("OTHER", "Other"),
                        ],
                        max_length=25,
                        verbose_name="What is the main source of this information?",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "appointment",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_appointment.Appointment",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical subject visit",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSubjectRequisition",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="a field used for quick search",
                        max_length=250,
                        null=True,
                    ),
                ),
                (
                    "requisition_identifier",
                    models.CharField(
                        db_index=True, max_length=50, verbose_name="Requisition Id"
                    ),
                ),
                (
                    "identifier_prefix",
                    models.CharField(db_index=True, editable=False, max_length=50, null=True),
                ),
                (
                    "primary_aliquot_identifier",
                    models.CharField(db_index=True, editable=False, max_length=18, null=True),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "clinic_verified",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")], max_length=15, null=True
                    ),
                ),
                ("clinic_verified_datetime", models.DateTimeField(null=True)),
                ("received", models.BooleanField(default=False)),
                ("received_datetime", models.DateTimeField(blank=True, null=True)),
                ("processed", models.BooleanField(default=False)),
                ("processed_datetime", models.DateTimeField(blank=True, null=True)),
                ("packed", models.BooleanField(default=False)),
                ("packed_datetime", models.DateTimeField(blank=True, null=True)),
                ("shipped", models.BooleanField(default=False)),
                ("shipped_datetime", models.DateTimeField(blank=True, null=True)),
                (
                    "requisition_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Requisition Date",
                    ),
                ),
                (
                    "drawn_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="If not drawn, leave blank.",
                        null=True,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Date / Time Specimen Drawn",
                    ),
                ),
                (
                    "is_drawn",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If No, provide a reason below",
                        max_length=3,
                        verbose_name="Was a specimen drawn?",
                    ),
                ),
                (
                    "reason_not_drawn",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            (
                                "collection_failed",
                                "Tried, but unable to obtain sample from patient",
                            ),
                            ("absent", "Patient did not attend visit"),
                            ("refused", "Patient refused"),
                            ("no_supplies", "No supplies"),
                            ("NOT_REQUIRED", "No longer required for this visit"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If not drawn, please explain",
                    ),
                ),
                (
                    "reason_not_drawn_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If Other, specify ...",
                    ),
                ),
                (
                    "protocol_number",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "clinician_initials",
                    edc_model_fields.fields.initials_field.InitialsField(
                        blank=True,
                        help_text="Type 2-3 letters, all in uppercase and no spaces",
                        max_length=3,
                        null=True,
                        verbose_name="Initials",
                    ),
                ),
                (
                    "specimen_type",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Specimen type",
                    ),
                ),
                (
                    "item_type",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("tube", "Tube"),
                            ("finger_prick", "Finger prick"),
                            ("swab", "Swab"),
                            ("dbs", "DBS Card"),
                            ("OTHER", "Other"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Item collection type",
                    ),
                ),
                (
                    "item_count",
                    models.IntegerField(
                        blank=True,
                        help_text="Number of tubes, samples, cards, etc being sent for this test/order only. Determines number of labels to print",
                        null=True,
                        verbose_name="Number of items",
                    ),
                ),
                (
                    "estimated_volume",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text='If applicable, estimated volume of sample for this test/order. This is the total volume if number of "tubes" above is greater than 1',
                        max_digits=7,
                        null=True,
                        verbose_name="Estimated volume in mL",
                    ),
                ),
                ("comments", models.TextField(blank=True, max_length=25, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "panel",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_lab.Panel",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical subject requisition",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalPatientHistory",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "weight",
                    models.DecimalField(
                        decimal_places=1,
                        help_text="kg",
                        max_digits=4,
                        validators=[
                            django.core.validators.MinValueValidator(20),
                            django.core.validators.MaxValueValidator(150),
                        ],
                        verbose_name="Weight:",
                    ),
                ),
                (
                    "sys_blood_pressure",
                    models.IntegerField(
                        help_text="in mm. format SYS, e.g. 120",
                        validators=[
                            django.core.validators.MinValueValidator(50),
                            django.core.validators.MaxValueValidator(220),
                        ],
                        verbose_name="Blood pressure: systolic",
                    ),
                ),
                (
                    "dia_blood_pressure",
                    models.IntegerField(
                        help_text="in Hg. format DIA, e.g. 80",
                        validators=[
                            django.core.validators.MinValueValidator(20),
                            django.core.validators.MaxValueValidator(150),
                        ],
                        verbose_name="Blood pressure: diastolic",
                    ),
                ),
                (
                    "heart_rate",
                    models.IntegerField(
                        help_text="BPM",
                        validators=[
                            django.core.validators.MinValueValidator(30),
                            django.core.validators.MaxValueValidator(200),
                        ],
                        verbose_name="Heart rate:",
                    ),
                ),
                (
                    "respiratory_rate",
                    models.IntegerField(
                        help_text="breaths/min",
                        validators=[
                            django.core.validators.MinValueValidator(6),
                            django.core.validators.MaxValueValidator(50),
                        ],
                        verbose_name="Respiratory rate:",
                    ),
                ),
                (
                    "temperature",
                    models.DecimalField(
                        decimal_places=1,
                        help_text="in degrees Celcius",
                        max_digits=3,
                        validators=[
                            django.core.validators.MinValueValidator(30),
                            django.core.validators.MaxValueValidator(45),
                        ],
                        verbose_name="Temperature:",
                    ),
                ),
                (
                    "other_symptoms",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If Other, specify ...",
                    ),
                ),
                (
                    "hiv_diagnosis_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="When was the diagnosis of HIV made?",
                    ),
                ),
                (
                    "arv_initiation_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="Date of start of antiretroviral therapy (ART)",
                    ),
                ),
                (
                    "viral_load",
                    models.IntegerField(
                        blank=True,
                        help_text="copies/mL",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(999999),
                        ],
                        verbose_name="Last viral load",
                    ),
                ),
                (
                    "viral_load_date",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date of last viral load"
                    ),
                ),
                (
                    "cd4",
                    models.IntegerField(
                        blank=True,
                        help_text="cells/mm<sup>3</sup>",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(3000),
                        ],
                        verbose_name="Last CD4",
                    ),
                ),
                (
                    "cd4_date",
                    models.DateField(blank=True, null=True, verbose_name="Date of last CD4"),
                ),
                (
                    "other_current_arv_regimen",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If Other, specify ...",
                    ),
                ),
                (
                    "current_arv_regimen_start_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="When did the patient start this current antiretroviral therapy regimen?",
                    ),
                ),
                (
                    "has_previous_arv_regimen",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient been on any previous regimen?",
                    ),
                ),
                (
                    "other_previous_arv_regimen",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If Other, specify ...",
                    ),
                ),
                (
                    "on_oi_prophylaxis",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient on any prophylaxis against opportunistic infections?",
                    ),
                ),
                (
                    "other_oi_prophylaxis",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If Other, specify ...",
                    ),
                ),
                (
                    "hypertension",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has the patient been diagnosed with hypertension?",
                    ),
                ),
                (
                    "on_hypertension_treatment",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient on treatment for hypertension?",
                    ),
                ),
                (
                    "hypertension_treatment",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="What medications is the patient currently taking for hypertension?",
                    ),
                ),
                (
                    "statins",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient currently taking any statins?",
                    ),
                ),
                (
                    "current_smoker",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the patient a current smoker?",
                    ),
                ),
                (
                    "former_smoker",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="Is the patient a previous smoker?",
                    ),
                ),
                (
                    "other_past_year_symptoms",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If Other, specify ...",
                    ),
                ),
                (
                    "family_diabetics",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has anyone in your immediate family (parents, siblings, children) ever been diagnosed with diabetes?",
                    ),
                ),
                (
                    "is_heartbeat_regular",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is the heart beat regular?",
                    ),
                ),
                (
                    "irregular_heartbeat",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If the heartbeat is NOT regular, please describe",
                    ),
                ),
                (
                    "waist_circumference",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="in cm",
                        max_digits=8,
                        verbose_name="Waist circumference",
                    ),
                ),
                (
                    "jaundice",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Jaundice",
                    ),
                ),
                (
                    "peripheral_oedema",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Presence of peripheral oedema",
                    ),
                ),
                (
                    "has_abdominal_tenderness",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Abdominal tenderness on palpation",
                    ),
                ),
                (
                    "abdominal_tenderness",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If YES, abdominal tenderness, please describe",
                    ),
                ),
                (
                    "has_enlarged_liver",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Enlarged liver on palpation",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "current_arv_regimen",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_lists.ArvRegimens",
                        verbose_name="Which antiretroviral therapy regimen is the patient currently on?",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "previous_arv_regimen",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_lists.ArvRegimens",
                        verbose_name="Which antiretroviral therapy regimen was the patient previously on?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Patient History",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalMedicationAdherence",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "visual_score",
                    models.IntegerField(help_text="%", verbose_name="Visual score"),
                ),
                (
                    "last_missed_pill",
                    models.CharField(
                        choices=[
                            ("today", "today"),
                            ("yesterday", "yesterday"),
                            ("earlier_this_week", "earlier this week"),
                            ("last_week", "last week"),
                            ("lt_month_ago", "less than a month ago"),
                            ("gt_month_ago", "more than a month ago"),
                            ("NEVER", "have never missed taking my study pills"),
                        ],
                        max_length=25,
                        verbose_name="When was the last time you missed your study pill?",
                    ),
                ),
                (
                    "pill_count",
                    models.IntegerField(verbose_name="Number of pills left in the bottle"),
                ),
                (
                    "missed_pill_reason",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Reasons for missing study pills",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Medication Adherence",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalMalariaRapidTest",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "performed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Was the malaria rapid test performed?",
                    ),
                ),
                (
                    "not_performed_reason",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If NO, provide reason",
                    ),
                ),
                (
                    "result",
                    models.CharField(
                        choices=[
                            ("present", "Present"),
                            ("absent", "Absent"),
                            ("N/A", "Not Applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="Result",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Malaria Rapid Test",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalHealthEconomics",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "occupation",
                    models.CharField(
                        max_length=50,
                        verbose_name="What is your occupation/profession?",
                    ),
                ),
                (
                    "education_in_years",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(30),
                        ],
                        verbose_name="How many years of education did you compete?",
                    ),
                ),
                (
                    "education_certificate",
                    models.CharField(
                        max_length=50,
                        verbose_name="What is your highest education certificate?",
                    ),
                ),
                (
                    "primary_school",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you go to primary/elementary school?",
                    ),
                ),
                (
                    "primary_school_in_years",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="If YES, for how many years",
                    ),
                ),
                (
                    "secondary_school",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you go to secondary school?",
                    ),
                ),
                (
                    "secondary_school_in_years",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="If YES, for how many years",
                    ),
                ),
                (
                    "higher_education",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you go to higer education?",
                    ),
                ),
                (
                    "higher_education_in_years",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="If YES, for how many years",
                    ),
                ),
                (
                    "welfare",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Do you receive any welfare or social service support",
                    ),
                ),
                (
                    "income_per_month",
                    models.IntegerField(
                        help_text="in Shilling",
                        verbose_name="How much do you earn (take home) per month?",
                    ),
                ),
                (
                    "household_income_per_month",
                    models.IntegerField(
                        help_text="in Shilling",
                        verbose_name="What is the total income in your household per month?",
                    ),
                ),
                (
                    "is_highest_earner",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Are you the person who earns the highest income in your household?",
                    ),
                ),
                (
                    "highest_earner",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If NO, what is the profession of the person who earns the highest income?",
                    ),
                ),
                (
                    "food_per_month",
                    models.IntegerField(
                        help_text="in Shilling",
                        verbose_name="How much do you/your family spend on food in a month?",
                    ),
                ),
                (
                    "accomodation_per_month",
                    models.IntegerField(
                        help_text="in Shilling",
                        verbose_name="How much do you/your family spend on rent and utilities in a month?",
                    ),
                ),
                (
                    "large_expenditure_year",
                    models.IntegerField(
                        help_text="e.g. furniture, electrical items, cars (in Shilling)",
                        verbose_name="How much have you spent on large items in the last year",
                    ),
                ),
                (
                    "buy_meds_month",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Over the last month, did you buy any drugs or had drug refill?",
                    ),
                ),
                (
                    "diabetic_expenditure_month",
                    models.IntegerField(
                        blank=True,
                        help_text="in Shilling",
                        null=True,
                        verbose_name="If YES, how much did you spend on Diabetic drugs",
                    ),
                ),
                (
                    "diabetic_payee",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative of others paying"),
                            ("free", "Free drugs from the pharmacy"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="If YES, how did you pay or who paid for these drugs",
                    ),
                ),
                (
                    "hypertensive_expenditure_month",
                    models.IntegerField(
                        blank=True,
                        help_text="in Shilling",
                        null=True,
                        verbose_name="If YES, how much did you spend on Hypertensive drugs",
                    ),
                ),
                (
                    "hypertensive_payee",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative of others paying"),
                            ("free", "Free drugs from the pharmacy"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="If YES, how did you pay or who paid for these drugs",
                    ),
                ),
                (
                    "arv_expenditure_month",
                    models.IntegerField(
                        blank=True,
                        help_text="in Shilling",
                        null=True,
                        verbose_name="If YES, how much did you spend on Antiretroviral drugs",
                    ),
                ),
                (
                    "arv_payee",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative of others paying"),
                            ("free", "Free drugs from the pharmacy"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="If YES, how did you pay or who paid for these drugs",
                    ),
                ),
                (
                    "meds_other_expenditure_month",
                    models.IntegerField(
                        blank=True,
                        help_text="in Shilling",
                        null=True,
                        verbose_name="If YES, how much did you spend on 'other' drugs",
                    ),
                ),
                (
                    "meds_other_payee",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative of others paying"),
                            ("free", "Free drugs from the pharmacy"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="If YES, how did you pay or who paid for these drugs",
                    ),
                ),
                (
                    "expenditure_other_month",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Over the last month, did you spend money on other activities (not drugs) relating to your health?",
                    ),
                ),
                (
                    "expenditure_other_detail",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If YES, what was the activity",
                    ),
                ),
                (
                    "expenditure_other",
                    models.IntegerField(
                        blank=True,
                        help_text="in Shilling",
                        null=True,
                        verbose_name="If YES, how much was spent on other activities (not drugs) relating to your health?",
                    ),
                ),
                (
                    "expenditure_other_payee",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative of others paying"),
                            ("free", "Free drugs from the pharmacy"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="If YES, how did you pay or who paid for these activities?",
                    ),
                ),
                (
                    "healthcare_expenditure_month",
                    models.IntegerField(
                        verbose_name="How much in total has been spent on your healthcare in the last month?"
                    ),
                ),
                (
                    "routine_activities",
                    models.CharField(
                        choices=[
                            ("working", "Working"),
                            ("studying", "Studying"),
                            ("caring_for_children", "Caring for children"),
                            ("OTHER", "Other, please specify"),
                        ],
                        max_length=15,
                        verbose_name="What would you be doing if you had not come to the hospital?",
                    ),
                ),
                (
                    "routine_activities_other",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If OTHER, please specify",
                    ),
                ),
                (
                    "off_work_days",
                    models.IntegerField(verbose_name="How much time did you take off work?"),
                ),
                (
                    "travel_time",
                    models.CharField(
                        help_text="in hours and minutes (format HH:MM)",
                        max_length=5,
                        verbose_name="How long did it take you to reach here?",
                    ),
                ),
                (
                    "hospital_time",
                    models.CharField(
                        help_text="in hours and minutes (format HH:MM)",
                        max_length=5,
                        verbose_name="How much time did you spend at the hospital?",
                    ),
                ),
                (
                    "lost_income",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you lose earnings as a result? ",
                    ),
                ),
                (
                    "lost_income_amount",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="If Yes, how much did you lose?",
                    ),
                ),
                (
                    "childcare",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="Did you ask anyone else, such as your family member, friend to look after your child/children in order to come here?",
                    ),
                ),
                (
                    "childcare_source",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("working", "Working"),
                            ("studying", "Studying"),
                            ("caring_for_children", "Caring for children"),
                            ("house_maintenance", "House maintenance"),
                            ("nothing", "Nothing"),
                            ("OTHER", "Other, specify"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If Yes, what would they have been doing if they had not stayed to look after your child or children?",
                    ),
                ),
                (
                    "childcare_source_timeoff",
                    models.IntegerField(
                        blank=True,
                        help_text="in Days",
                        null=True,
                        verbose_name="How much time did a family member, friend take off work to look after your child or children?",
                    ),
                ),
                (
                    "transport",
                    models.CharField(
                        choices=[
                            ("bus", "Bus"),
                            ("train", "Train"),
                            ("ambulance", "Ambulance"),
                            ("private_taxi", "Private taxi"),
                            ("own_bicycle", "Own bicycle"),
                            ("hired_motorbike", "Hired motorbike"),
                            ("own_car", "Own car"),
                            ("own_motorbike", "Own motorbike"),
                            ("hired_bicycle", "Hired bicycle"),
                            ("foot", "Foot"),
                            ("OTHER", "Other, specify"),
                        ],
                        max_length=25,
                        verbose_name="Which form of transport did you take to get to the hospital today?",
                    ),
                ),
                (
                    "transport_cost",
                    models.IntegerField(
                        help_text="in Shilling",
                        verbose_name="How much did you spend on transport in total?",
                    ),
                ),
                (
                    "transport_barter",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you sell anything to pay for your visit today?",
                    ),
                ),
                (
                    "transport_borrow",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you take any loans to pay for your visit?",
                    ),
                ),
                (
                    "health_insurance",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Do you have private healthcare insurance?",
                    ),
                ),
                (
                    "health_insurance_pay",
                    models.IntegerField(
                        blank=True,
                        help_text="in Shilling",
                        null=True,
                        verbose_name="If Yes, how much do you pay towards your contributions to healthcare insurance every month?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Health Economics",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalFollowupVitals",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "weight",
                    models.DecimalField(
                        decimal_places=1,
                        help_text="kg",
                        max_digits=4,
                        validators=[
                            django.core.validators.MinValueValidator(20),
                            django.core.validators.MaxValueValidator(150),
                        ],
                        verbose_name="Weight:",
                    ),
                ),
                (
                    "sys_blood_pressure",
                    models.IntegerField(
                        help_text="in mm. format SYS, e.g. 120",
                        validators=[
                            django.core.validators.MinValueValidator(50),
                            django.core.validators.MaxValueValidator(220),
                        ],
                        verbose_name="Blood pressure: systolic",
                    ),
                ),
                (
                    "dia_blood_pressure",
                    models.IntegerField(
                        help_text="in Hg. format DIA, e.g. 80",
                        validators=[
                            django.core.validators.MinValueValidator(20),
                            django.core.validators.MaxValueValidator(150),
                        ],
                        verbose_name="Blood pressure: diastolic",
                    ),
                ),
                (
                    "heart_rate",
                    models.IntegerField(
                        help_text="BPM",
                        validators=[
                            django.core.validators.MinValueValidator(30),
                            django.core.validators.MaxValueValidator(200),
                        ],
                        verbose_name="Heart rate:",
                    ),
                ),
                (
                    "respiratory_rate",
                    models.IntegerField(
                        help_text="breaths/min",
                        validators=[
                            django.core.validators.MinValueValidator(6),
                            django.core.validators.MaxValueValidator(50),
                        ],
                        verbose_name="Respiratory rate:",
                    ),
                ),
                (
                    "temperature",
                    models.DecimalField(
                        decimal_places=1,
                        help_text="in degrees Celcius",
                        max_digits=3,
                        validators=[
                            django.core.validators.MinValueValidator(30),
                            django.core.validators.MaxValueValidator(45),
                        ],
                        verbose_name="Temperature:",
                    ),
                ),
                (
                    "weight_determination",
                    models.CharField(
                        choices=[("estimated", "Estimated"), ("measured", "Measured")],
                        max_length=15,
                        verbose_name="Is weight estimated or measured?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Clinic follow up: Vitals",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalFollowup",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "followup_reason",
                    models.CharField(
                        choices=[
                            ("appt", "Study appointment"),
                            ("other_routine_appt", "Other routine appointment"),
                        ],
                        max_length=25,
                        verbose_name="Why have you come to the clinic today",
                    ),
                ),
                (
                    "symptoms_detail",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Please provide details on any of the symptoms above.",
                    ),
                ),
                (
                    "attended_clinic",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Includes other routine appointments, e.g. BP check or family planning",
                        max_length=25,
                        verbose_name="Since your last visit did you attend any other clinic or hospital for care for any reason",
                    ),
                ),
                (
                    "admitted_hospital",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="If YES, were you admitted to hospital?",
                    ),
                ),
                (
                    "attended_clinic_detail",
                    models.TextField(
                        blank=True,
                        help_text="If patient was given a referral letter or discharge summary record details here",
                        null=True,
                        verbose_name="If YES, attend other clinic or hospital, please provide details of this visit",
                    ),
                ),
                (
                    "prescribed_medication",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Were you prescribed any other medication at this clinic or hospital visit?",
                    ),
                ),
                (
                    "prescribed_medication_detail",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If YES, prescribed any other medication, please provide details of this visit",
                    ),
                ),
                (
                    "attended_clinic_sae",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If YES, submit a Serious Adverse Event Form",
                        max_length=25,
                        verbose_name="Does the visit described in 5b constitute a Serious Adverse Event",
                    ),
                ),
                (
                    "any_other_problems",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Since your last visit have you experienced any other medical or health problems not listed above",
                    ),
                ),
                (
                    "any_other_problems_detail",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If YES, please provide details",
                    ),
                ),
                (
                    "any_other_problems_sae",
                    models.CharField(
                        choices=[
                            ("3", "Grade 3"),
                            ("4", "Grade 4"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="If YES, grade 3 or 4, submit Serious Adverse Event form",
                        max_length=25,
                        verbose_name="If YES, what grade?",
                    ),
                ),
                (
                    "art_change",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Since your last visit has there been any change in your HIV medication?",
                    ),
                ),
                (
                    "art_change_reason",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If YES, please provide reason for change",
                    ),
                ),
                (
                    "art_new_regimen_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If Other, specify ...",
                    ),
                ),
                (
                    "abdominal_tenderness",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Abdominal tenderness",
                    ),
                ),
                (
                    "enlarged_liver",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Enlarged liver",
                    ),
                ),
                (
                    "jaundice",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Jaundice",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        verbose_name="Comment on the clinical course, any other symptoms present, assessment and management plan"
                    ),
                ),
                (
                    "lactic_acidosis",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Classical signs of lactic acidosis include: abdominal or stomach discomfort, decreased appetite, diarrhoea, fast or shallow breathing, a general feeling of discomfort, muscle pain or cramping; and unusual sleepiness, fatigue, or weakness.",
                        max_length=25,
                        verbose_name="Do you think this patient has lactic acidosis?",
                    ),
                ),
                (
                    "hepatomegaly",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="This condition often does not have any clinical signs and symptoms, it may present with an enlarge liver on examination, and symptoms of fatigue and right upper abdominal pain. The risk of developing this condition is higher in patients who are obese and who have type 2 diabetes or metabolic syndrome",
                        max_length=25,
                        verbose_name="Do you think this patient has hepatomegaly with steatosis?",
                    ),
                ),
                (
                    "referral",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Is patient being referred",
                    ),
                ),
                (
                    "referral_reason",
                    models.TextField(
                        blank=True,
                        help_text="Note: remind participant that admission or discharge information will be needed at the next follow up visit.",
                        null=True,
                        verbose_name="If YES, where are they being referred to",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Clinic follow up: Examination",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalComplications",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "cataracts",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Presence of cataracts",
                    ),
                ),
                (
                    "fundoscopy",
                    models.CharField(
                        choices=[
                            ("no_retinopathy", "No retinopathy"),
                            ("background_retinopathy", "Background retinopathy"),
                            (
                                "pre_proliferative_retinopathy",
                                "Pre-proliferative retinopathy",
                            ),
                            ("proliferative_retinopathy", "Proliferative retinopathy"),
                            ("maculopathy", "Maculopathy"),
                        ],
                        max_length=35,
                        verbose_name="Fundoscopy",
                    ),
                ),
                (
                    "achilles_tendon_reflex",
                    models.CharField(
                        choices=[("present", "Present"), ("absent", "Absent")],
                        max_length=15,
                        verbose_name="Achilles tendon reflex",
                    ),
                ),
                (
                    "foot_pin_prick",
                    models.CharField(
                        choices=[("NORMAL", "Normal"), ("ABNORMAL", "Abnormal")],
                        help_text="Can the patient distinguish between sharp and non-sharp?",
                        max_length=15,
                        verbose_name="Pin prick testing on foot",
                    ),
                ),
                (
                    "foot_light_touch",
                    models.CharField(
                        choices=[("NORMAL", "Normal"), ("ABNORMAL", "Abnormal")],
                        help_text="Can the patient feel light pressure on the dorsum of the foot?",
                        max_length=15,
                        verbose_name="Light touch",
                    ),
                ),
                (
                    "temperature_perception",
                    models.CharField(
                        choices=[("NORMAL", "Normal"), ("ABNORMAL", "Abnormal")],
                        help_text="Can the patient distinguish between temperature on the dorsum of the foot?",
                        max_length=15,
                        verbose_name="Temperature perception",
                    ),
                ),
                (
                    "dorsalis_pedis_pulse",
                    models.CharField(
                        choices=[("present", "Present"), ("absent", "Absent")],
                        max_length=15,
                        verbose_name="Dorsalis pedis pulse",
                    ),
                ),
                (
                    "posterior_tibial_pulse",
                    models.CharField(
                        choices=[("present", "Present"), ("absent", "Absent")],
                        max_length=15,
                        verbose_name="Posterior tibial pulse",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Presence of Complications",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalBloodResultsRft",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("tracking_identifier", models.CharField(db_index=True, max_length=30)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        help_text="If YES, this value will open Adverse Event Form.<br/><br/>Note: On Day 1 only abnormal bloods should not be reported as adverseevents.",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade III or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "rft_assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result Report Date and Time",
                    ),
                ),
                (
                    "urea",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=6,
                        null=True,
                        verbose_name="Urea (BUN)",
                    ),
                ),
                (
                    "urea_units",
                    models.CharField(
                        blank=True,
                        choices=[("mmol/L", "mmol/L")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "urea_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "urea_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "creatinine",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=6,
                        null=True,
                        verbose_name="Creatinine",
                    ),
                ),
                (
                    "creatinine_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "creatinine_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "creatinine_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "uric_acid",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=6,
                        null=True,
                        verbose_name="Uric Acid",
                    ),
                ),
                (
                    "uric_acid_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "uric_acid_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "uric_acid_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "egfr",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="mL/min/1.73 m2 (system calculated)",
                        max_digits=8,
                        null=True,
                        verbose_name="eGFR",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "rft_requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectRequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Blood Result: RFT",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalBloodResultsLft",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("tracking_identifier", models.CharField(db_index=True, max_length=30)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        help_text="If YES, this value will open Adverse Event Form.<br/><br/>Note: On Day 1 only abnormal bloods should not be reported as adverseevents.",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade III or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "lft_assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result Report Date and Time",
                    ),
                ),
                (
                    "ast",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="AST",
                    ),
                ),
                (
                    "ast_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "ast_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "ast_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "alt",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="ALT",
                    ),
                ),
                (
                    "alt_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "alt_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "alt_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "alp",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="ALP",
                    ),
                ),
                (
                    "alp_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "alp_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "alp_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "amylase",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="Serum Amylase",
                    ),
                ),
                (
                    "amylase_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "amylase_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "amylase_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "ggt",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="GGT",
                    ),
                ),
                (
                    "ggt_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "ggt_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "ggt_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "albumin",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="Serum Albumin",
                    ),
                ),
                (
                    "albumin_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL"), ("g/L", "g/L")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "albumin_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "albumin_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "lft_requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectRequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Blood Result: LFT",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalBloodResultsHba1c",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("tracking_identifier", models.CharField(db_index=True, max_length=30)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        help_text="If YES, this value will open Adverse Event Form.<br/><br/>Note: On Day 1 only abnormal bloods should not be reported as adverseevents.",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade III or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "is_poc",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Was a point-of-care test used?",
                    ),
                ),
                (
                    "hba1c_assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result Report Date and Time",
                    ),
                ),
                (
                    "hba1c",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="HbA1c",
                    ),
                ),
                (
                    "hba1c_units",
                    models.CharField(
                        blank=True,
                        choices=[("%", "%")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "hba1c_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "hba1c_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "hba1c_requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectRequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Blood Result: HbA1c",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalBloodResultsGlu",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("tracking_identifier", models.CharField(db_index=True, max_length=30)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        help_text="If YES, this value will open Adverse Event Form.",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "is_poc",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Was a point-of-care test used?",
                    ),
                ),
                (
                    "glucose_assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result Report Date and Time",
                    ),
                ),
                (
                    "fasting",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("fasting", "Fasting"),
                            ("non_fasting", "Non-fasting"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="Was this fasting or non-fasting?",
                    ),
                ),
                (
                    "glucose",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        verbose_name="Blood Glucose",
                    ),
                ),
                (
                    "glucose_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "glucose_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "glucose_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "glucose_requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectRequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Blood Result: Glucose",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalBloodResultsFbc",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("tracking_identifier", models.CharField(db_index=True, max_length=30)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        help_text="If YES, this value will open Adverse Event Form.<br/><br/>Note: On Day 1 only abnormal bloods should not be reported as adverseevents.",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade III or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "fbc_assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result Report Date and Time",
                    ),
                ),
                (
                    "haemoglobin",
                    models.DecimalField(blank=True, decimal_places=1, max_digits=6, null=True),
                ),
                (
                    "haemoglobin_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "haemoglobin_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "haemoglobin_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "hct",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="Hematocrit",
                    ),
                ),
                (
                    "hct_units",
                    models.CharField(
                        blank=True,
                        choices=[("%", "%")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "hct_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "hct_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "rbc",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=6,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(999999.0),
                        ],
                        verbose_name="Red blood cell count",
                    ),
                ),
                (
                    "rbc_units",
                    models.CharField(
                        blank=True,
                        choices=[("10^9/L", "10^9/L"), ("cells/mm^3", "cells/mm^3")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "rbc_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "rbc_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "wbc",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=6,
                        null=True,
                        verbose_name="WBC",
                    ),
                ),
                (
                    "wbc_units",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("10^9/L", "10^9/L"),
                            ("cells/mm^3", "cells/mm<sup>3</sup>"),
                        ],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "wbc_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "wbc_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "platelets",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999),
                        ],
                    ),
                ),
                (
                    "platelets_units",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("10^9/L", "10^9/L"),
                            ("cells/mm^3", "cells/mm<sup>3</sup>"),
                        ],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "platelets_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "platelets_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "fbc_requisition",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectRequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Blood Result: FBC",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HealthEconomics",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "occupation",
                    models.CharField(
                        max_length=50,
                        verbose_name="What is your occupation/profession?",
                    ),
                ),
                (
                    "education_in_years",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(30),
                        ],
                        verbose_name="How many years of education did you compete?",
                    ),
                ),
                (
                    "education_certificate",
                    models.CharField(
                        max_length=50,
                        verbose_name="What is your highest education certificate?",
                    ),
                ),
                (
                    "primary_school",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you go to primary/elementary school?",
                    ),
                ),
                (
                    "primary_school_in_years",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="If YES, for how many years",
                    ),
                ),
                (
                    "secondary_school",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you go to secondary school?",
                    ),
                ),
                (
                    "secondary_school_in_years",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="If YES, for how many years",
                    ),
                ),
                (
                    "higher_education",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you go to higer education?",
                    ),
                ),
                (
                    "higher_education_in_years",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(10),
                        ],
                        verbose_name="If YES, for how many years",
                    ),
                ),
                (
                    "welfare",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Do you receive any welfare or social service support",
                    ),
                ),
                (
                    "income_per_month",
                    models.IntegerField(
                        help_text="in Shilling",
                        verbose_name="How much do you earn (take home) per month?",
                    ),
                ),
                (
                    "household_income_per_month",
                    models.IntegerField(
                        help_text="in Shilling",
                        verbose_name="What is the total income in your household per month?",
                    ),
                ),
                (
                    "is_highest_earner",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Are you the person who earns the highest income in your household?",
                    ),
                ),
                (
                    "highest_earner",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If NO, what is the profession of the person who earns the highest income?",
                    ),
                ),
                (
                    "food_per_month",
                    models.IntegerField(
                        help_text="in Shilling",
                        verbose_name="How much do you/your family spend on food in a month?",
                    ),
                ),
                (
                    "accomodation_per_month",
                    models.IntegerField(
                        help_text="in Shilling",
                        verbose_name="How much do you/your family spend on rent and utilities in a month?",
                    ),
                ),
                (
                    "large_expenditure_year",
                    models.IntegerField(
                        help_text="e.g. furniture, electrical items, cars (in Shilling)",
                        verbose_name="How much have you spent on large items in the last year",
                    ),
                ),
                (
                    "buy_meds_month",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Over the last month, did you buy any drugs or had drug refill?",
                    ),
                ),
                (
                    "diabetic_expenditure_month",
                    models.IntegerField(
                        blank=True,
                        help_text="in Shilling",
                        null=True,
                        verbose_name="If YES, how much did you spend on Diabetic drugs",
                    ),
                ),
                (
                    "diabetic_payee",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative of others paying"),
                            ("free", "Free drugs from the pharmacy"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="If YES, how did you pay or who paid for these drugs",
                    ),
                ),
                (
                    "hypertensive_expenditure_month",
                    models.IntegerField(
                        blank=True,
                        help_text="in Shilling",
                        null=True,
                        verbose_name="If YES, how much did you spend on Hypertensive drugs",
                    ),
                ),
                (
                    "hypertensive_payee",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative of others paying"),
                            ("free", "Free drugs from the pharmacy"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="If YES, how did you pay or who paid for these drugs",
                    ),
                ),
                (
                    "arv_expenditure_month",
                    models.IntegerField(
                        blank=True,
                        help_text="in Shilling",
                        null=True,
                        verbose_name="If YES, how much did you spend on Antiretroviral drugs",
                    ),
                ),
                (
                    "arv_payee",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative of others paying"),
                            ("free", "Free drugs from the pharmacy"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="If YES, how did you pay or who paid for these drugs",
                    ),
                ),
                (
                    "meds_other_expenditure_month",
                    models.IntegerField(
                        blank=True,
                        help_text="in Shilling",
                        null=True,
                        verbose_name="If YES, how much did you spend on 'other' drugs",
                    ),
                ),
                (
                    "meds_other_payee",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative of others paying"),
                            ("free", "Free drugs from the pharmacy"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="If YES, how did you pay or who paid for these drugs",
                    ),
                ),
                (
                    "expenditure_other_month",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Over the last month, did you spend money on other activities (not drugs) relating to your health?",
                    ),
                ),
                (
                    "expenditure_other_detail",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If YES, what was the activity",
                    ),
                ),
                (
                    "expenditure_other",
                    models.IntegerField(
                        blank=True,
                        help_text="in Shilling",
                        null=True,
                        verbose_name="If YES, how much was spent on other activities (not drugs) relating to your health?",
                    ),
                ),
                (
                    "expenditure_other_payee",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative of others paying"),
                            ("free", "Free drugs from the pharmacy"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="If YES, how did you pay or who paid for these activities?",
                    ),
                ),
                (
                    "healthcare_expenditure_month",
                    models.IntegerField(
                        verbose_name="How much in total has been spent on your healthcare in the last month?"
                    ),
                ),
                (
                    "routine_activities",
                    models.CharField(
                        choices=[
                            ("working", "Working"),
                            ("studying", "Studying"),
                            ("caring_for_children", "Caring for children"),
                            ("OTHER", "Other, please specify"),
                        ],
                        max_length=15,
                        verbose_name="What would you be doing if you had not come to the hospital?",
                    ),
                ),
                (
                    "routine_activities_other",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="If OTHER, please specify",
                    ),
                ),
                (
                    "off_work_days",
                    models.IntegerField(verbose_name="How much time did you take off work?"),
                ),
                (
                    "travel_time",
                    models.CharField(
                        help_text="in hours and minutes (format HH:MM)",
                        max_length=5,
                        verbose_name="How long did it take you to reach here?",
                    ),
                ),
                (
                    "hospital_time",
                    models.CharField(
                        help_text="in hours and minutes (format HH:MM)",
                        max_length=5,
                        verbose_name="How much time did you spend at the hospital?",
                    ),
                ),
                (
                    "lost_income",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you lose earnings as a result? ",
                    ),
                ),
                (
                    "lost_income_amount",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="If Yes, how much did you lose?",
                    ),
                ),
                (
                    "childcare",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=15,
                        verbose_name="Did you ask anyone else, such as your family member, friend to look after your child/children in order to come here?",
                    ),
                ),
                (
                    "childcare_source",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("working", "Working"),
                            ("studying", "Studying"),
                            ("caring_for_children", "Caring for children"),
                            ("house_maintenance", "House maintenance"),
                            ("nothing", "Nothing"),
                            ("OTHER", "Other, specify"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If Yes, what would they have been doing if they had not stayed to look after your child or children?",
                    ),
                ),
                (
                    "childcare_source_timeoff",
                    models.IntegerField(
                        blank=True,
                        help_text="in Days",
                        null=True,
                        verbose_name="How much time did a family member, friend take off work to look after your child or children?",
                    ),
                ),
                (
                    "transport",
                    models.CharField(
                        choices=[
                            ("bus", "Bus"),
                            ("train", "Train"),
                            ("ambulance", "Ambulance"),
                            ("private_taxi", "Private taxi"),
                            ("own_bicycle", "Own bicycle"),
                            ("hired_motorbike", "Hired motorbike"),
                            ("own_car", "Own car"),
                            ("own_motorbike", "Own motorbike"),
                            ("hired_bicycle", "Hired bicycle"),
                            ("foot", "Foot"),
                            ("OTHER", "Other, specify"),
                        ],
                        max_length=25,
                        verbose_name="Which form of transport did you take to get to the hospital today?",
                    ),
                ),
                (
                    "transport_cost",
                    models.IntegerField(
                        help_text="in Shilling",
                        verbose_name="How much did you spend on transport in total?",
                    ),
                ),
                (
                    "transport_barter",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you sell anything to pay for your visit today?",
                    ),
                ),
                (
                    "transport_borrow",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you take any loans to pay for your visit?",
                    ),
                ),
                (
                    "health_insurance",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Do you have private healthcare insurance?",
                    ),
                ),
                (
                    "health_insurance_pay",
                    models.IntegerField(
                        blank=True,
                        help_text="in Shilling",
                        null=True,
                        verbose_name="If Yes, how much do you pay towards your contributions to healthcare insurance every month?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Health Economics",
                "verbose_name_plural": "Health Economics",
                "abstract": False,
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="FollowupVitals",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "weight",
                    models.DecimalField(
                        decimal_places=1,
                        help_text="kg",
                        max_digits=4,
                        validators=[
                            django.core.validators.MinValueValidator(20),
                            django.core.validators.MaxValueValidator(150),
                        ],
                        verbose_name="Weight:",
                    ),
                ),
                (
                    "sys_blood_pressure",
                    models.IntegerField(
                        help_text="in mm. format SYS, e.g. 120",
                        validators=[
                            django.core.validators.MinValueValidator(50),
                            django.core.validators.MaxValueValidator(220),
                        ],
                        verbose_name="Blood pressure: systolic",
                    ),
                ),
                (
                    "dia_blood_pressure",
                    models.IntegerField(
                        help_text="in Hg. format DIA, e.g. 80",
                        validators=[
                            django.core.validators.MinValueValidator(20),
                            django.core.validators.MaxValueValidator(150),
                        ],
                        verbose_name="Blood pressure: diastolic",
                    ),
                ),
                (
                    "heart_rate",
                    models.IntegerField(
                        help_text="BPM",
                        validators=[
                            django.core.validators.MinValueValidator(30),
                            django.core.validators.MaxValueValidator(200),
                        ],
                        verbose_name="Heart rate:",
                    ),
                ),
                (
                    "respiratory_rate",
                    models.IntegerField(
                        help_text="breaths/min",
                        validators=[
                            django.core.validators.MinValueValidator(6),
                            django.core.validators.MaxValueValidator(50),
                        ],
                        verbose_name="Respiratory rate:",
                    ),
                ),
                (
                    "temperature",
                    models.DecimalField(
                        decimal_places=1,
                        help_text="in degrees Celcius",
                        max_digits=3,
                        validators=[
                            django.core.validators.MinValueValidator(30),
                            django.core.validators.MaxValueValidator(45),
                        ],
                        verbose_name="Temperature:",
                    ),
                ),
                (
                    "weight_determination",
                    models.CharField(
                        choices=[("estimated", "Estimated"), ("measured", "Measured")],
                        max_length=15,
                        verbose_name="Is weight estimated or measured?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Clinic follow up: Vitals",
                "verbose_name_plural": "Clinic follow ups: Vitals",
                "abstract": False,
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="Followup",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "followup_reason",
                    models.CharField(
                        choices=[
                            ("appt", "Study appointment"),
                            ("other_routine_appt", "Other routine appointment"),
                        ],
                        max_length=25,
                        verbose_name="Why have you come to the clinic today",
                    ),
                ),
                (
                    "symptoms_detail",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Please provide details on any of the symptoms above.",
                    ),
                ),
                (
                    "attended_clinic",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Includes other routine appointments, e.g. BP check or family planning",
                        max_length=25,
                        verbose_name="Since your last visit did you attend any other clinic or hospital for care for any reason",
                    ),
                ),
                (
                    "admitted_hospital",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="If YES, were you admitted to hospital?",
                    ),
                ),
                (
                    "attended_clinic_detail",
                    models.TextField(
                        blank=True,
                        help_text="If patient was given a referral letter or discharge summary record details here",
                        null=True,
                        verbose_name="If YES, attend other clinic or hospital, please provide details of this visit",
                    ),
                ),
                (
                    "prescribed_medication",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Were you prescribed any other medication at this clinic or hospital visit?",
                    ),
                ),
                (
                    "prescribed_medication_detail",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If YES, prescribed any other medication, please provide details of this visit",
                    ),
                ),
                (
                    "attended_clinic_sae",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If YES, submit a Serious Adverse Event Form",
                        max_length=25,
                        verbose_name="Does the visit described in 5b constitute a Serious Adverse Event",
                    ),
                ),
                (
                    "any_other_problems",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Since your last visit have you experienced any other medical or health problems not listed above",
                    ),
                ),
                (
                    "any_other_problems_detail",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If YES, please provide details",
                    ),
                ),
                (
                    "any_other_problems_sae",
                    models.CharField(
                        choices=[
                            ("3", "Grade 3"),
                            ("4", "Grade 4"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="If YES, grade 3 or 4, submit Serious Adverse Event form",
                        max_length=25,
                        verbose_name="If YES, what grade?",
                    ),
                ),
                (
                    "art_change",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Since your last visit has there been any change in your HIV medication?",
                    ),
                ),
                (
                    "art_change_reason",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="If YES, please provide reason for change",
                    ),
                ),
                (
                    "art_new_regimen_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If Other, specify ...",
                    ),
                ),
                (
                    "abdominal_tenderness",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Abdominal tenderness",
                    ),
                ),
                (
                    "enlarged_liver",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Enlarged liver",
                    ),
                ),
                (
                    "jaundice",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Jaundice",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        verbose_name="Comment on the clinical course, any other symptoms present, assessment and management plan"
                    ),
                ),
                (
                    "lactic_acidosis",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Classical signs of lactic acidosis include: abdominal or stomach discomfort, decreased appetite, diarrhoea, fast or shallow breathing, a general feeling of discomfort, muscle pain or cramping; and unusual sleepiness, fatigue, or weakness.",
                        max_length=25,
                        verbose_name="Do you think this patient has lactic acidosis?",
                    ),
                ),
                (
                    "hepatomegaly",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="This condition often does not have any clinical signs and symptoms, it may present with an enlarge liver on examination, and symptoms of fatigue and right upper abdominal pain. The risk of developing this condition is higher in patients who are obese and who have type 2 diabetes or metabolic syndrome",
                        max_length=25,
                        verbose_name="Do you think this patient has hepatomegaly with steatosis?",
                    ),
                ),
                (
                    "referral",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Is patient being referred",
                    ),
                ),
                (
                    "referral_reason",
                    models.TextField(
                        blank=True,
                        help_text="Note: remind participant that admission or discharge information will be needed at the next follow up visit.",
                        null=True,
                        verbose_name="If YES, where are they being referred to",
                    ),
                ),
                (
                    "art_new_regimen",
                    models.ManyToManyField(
                        related_name="art_new_regimen",
                        to="meta_lists.ArvRegimens",
                        verbose_name="Please indicate new regimen",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.SubjectVisit",
                    ),
                ),
                (
                    "symptoms",
                    models.ManyToManyField(
                        help_text="either at this hospital or at a different clinic",
                        related_name="symptoms",
                        to="meta_lists.Symptoms",
                        verbose_name="Since your last appointment have you experienced any of the following symptoms",
                    ),
                ),
                (
                    "symptoms_g3",
                    models.ManyToManyField(
                        help_text="Refer to DAIDS toxicity table. Please complete Serious Adverse Event form",
                        related_name="symptoms_g3",
                        to="meta_lists.Symptoms",
                        verbose_name="For these symptoms, were any grade 3 events",
                    ),
                ),
                (
                    "symptoms_g4",
                    models.ManyToManyField(
                        help_text="Refer to DAIDS toxicity table. Please complete Serious Adverse Event form",
                        related_name="symptoms_g4",
                        to="meta_lists.Symptoms",
                        verbose_name="For these symptoms, were any grade 4 events",
                    ),
                ),
                (
                    "symptoms_sought_care",
                    models.ManyToManyField(
                        related_name="symptoms_sought_care",
                        to="meta_lists.Symptoms",
                        verbose_name="Did you seek care from any health worker for these symptoms",
                    ),
                ),
            ],
            options={
                "verbose_name": "Clinic follow up: Examination",
                "verbose_name_plural": "Clinic follow up: Examination",
                "abstract": False,
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="Complications",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "cataracts",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Presence of cataracts",
                    ),
                ),
                (
                    "fundoscopy",
                    models.CharField(
                        choices=[
                            ("no_retinopathy", "No retinopathy"),
                            ("background_retinopathy", "Background retinopathy"),
                            (
                                "pre_proliferative_retinopathy",
                                "Pre-proliferative retinopathy",
                            ),
                            ("proliferative_retinopathy", "Proliferative retinopathy"),
                            ("maculopathy", "Maculopathy"),
                        ],
                        max_length=35,
                        verbose_name="Fundoscopy",
                    ),
                ),
                (
                    "achilles_tendon_reflex",
                    models.CharField(
                        choices=[("present", "Present"), ("absent", "Absent")],
                        max_length=15,
                        verbose_name="Achilles tendon reflex",
                    ),
                ),
                (
                    "foot_pin_prick",
                    models.CharField(
                        choices=[("NORMAL", "Normal"), ("ABNORMAL", "Abnormal")],
                        help_text="Can the patient distinguish between sharp and non-sharp?",
                        max_length=15,
                        verbose_name="Pin prick testing on foot",
                    ),
                ),
                (
                    "foot_light_touch",
                    models.CharField(
                        choices=[("NORMAL", "Normal"), ("ABNORMAL", "Abnormal")],
                        help_text="Can the patient feel light pressure on the dorsum of the foot?",
                        max_length=15,
                        verbose_name="Light touch",
                    ),
                ),
                (
                    "temperature_perception",
                    models.CharField(
                        choices=[("NORMAL", "Normal"), ("ABNORMAL", "Abnormal")],
                        help_text="Can the patient distinguish between temperature on the dorsum of the foot?",
                        max_length=15,
                        verbose_name="Temperature perception",
                    ),
                ),
                (
                    "dorsalis_pedis_pulse",
                    models.CharField(
                        choices=[("present", "Present"), ("absent", "Absent")],
                        max_length=15,
                        verbose_name="Dorsalis pedis pulse",
                    ),
                ),
                (
                    "posterior_tibial_pulse",
                    models.CharField(
                        choices=[("present", "Present"), ("absent", "Absent")],
                        max_length=15,
                        verbose_name="Posterior tibial pulse",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Presence of Complications",
                "verbose_name_plural": "Presence of Complications",
                "abstract": False,
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="BloodResultsRft",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("tracking_identifier", models.CharField(max_length=30, unique=True)),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        help_text="If YES, this value will open Adverse Event Form.<br/><br/>Note: On Day 1 only abnormal bloods should not be reported as adverseevents.",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade III or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "rft_assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result Report Date and Time",
                    ),
                ),
                (
                    "urea",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=6,
                        null=True,
                        verbose_name="Urea (BUN)",
                    ),
                ),
                (
                    "urea_units",
                    models.CharField(
                        blank=True,
                        choices=[("mmol/L", "mmol/L")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "urea_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "urea_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "creatinine",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=6,
                        null=True,
                        verbose_name="Creatinine",
                    ),
                ),
                (
                    "creatinine_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "creatinine_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "creatinine_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "uric_acid",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=6,
                        null=True,
                        verbose_name="Uric Acid",
                    ),
                ),
                (
                    "uric_acid_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "uric_acid_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "uric_acid_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "egfr",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        help_text="mL/min/1.73 m2 (system calculated)",
                        max_digits=8,
                        null=True,
                        verbose_name="eGFR",
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "rft_requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="ft",
                        to="meta_subject.SubjectRequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Blood Result: RFT",
                "verbose_name_plural": "Blood Results: RFT",
                "abstract": False,
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="BloodResultsLft",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("tracking_identifier", models.CharField(max_length=30, unique=True)),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        help_text="If YES, this value will open Adverse Event Form.<br/><br/>Note: On Day 1 only abnormal bloods should not be reported as adverseevents.",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade III or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "lft_assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result Report Date and Time",
                    ),
                ),
                (
                    "ast",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="AST",
                    ),
                ),
                (
                    "ast_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "ast_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "ast_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "alt",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="ALT",
                    ),
                ),
                (
                    "alt_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "alt_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "alt_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "alp",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="ALP",
                    ),
                ),
                (
                    "alp_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "alp_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "alp_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "amylase",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="Serum Amylase",
                    ),
                ),
                (
                    "amylase_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "amylase_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "amylase_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "ggt",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="GGT",
                    ),
                ),
                (
                    "ggt_units",
                    models.CharField(
                        blank=True,
                        choices=[("IU/L", "IU/L")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "ggt_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "ggt_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "albumin",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="Serum Albumin",
                    ),
                ),
                (
                    "albumin_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL"), ("g/L", "g/L")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "albumin_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "albumin_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "lft_requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="lft",
                        to="meta_subject.SubjectRequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Blood Result: LFT",
                "verbose_name_plural": "Blood Results: LFT",
                "abstract": False,
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="BloodResultsHba1c",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("tracking_identifier", models.CharField(max_length=30, unique=True)),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        help_text="If YES, this value will open Adverse Event Form.<br/><br/>Note: On Day 1 only abnormal bloods should not be reported as adverseevents.",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade III or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "is_poc",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Was a point-of-care test used?",
                    ),
                ),
                (
                    "hba1c_assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result Report Date and Time",
                    ),
                ),
                (
                    "hba1c",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="HbA1c",
                    ),
                ),
                (
                    "hba1c_units",
                    models.CharField(
                        blank=True,
                        choices=[("%", "%")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "hba1c_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "hba1c_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "hba1c_requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="hba1c",
                        to="meta_subject.SubjectRequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Blood Result: HbA1c",
                "verbose_name_plural": "Blood Results: HbA1c",
                "abstract": False,
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="BloodResultsGlu",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("tracking_identifier", models.CharField(max_length=30, unique=True)),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        help_text="If YES, this value will open Adverse Event Form.",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade 3 or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "is_poc",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Was a point-of-care test used?",
                    ),
                ),
                (
                    "glucose_assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result Report Date and Time",
                    ),
                ),
                (
                    "fasting",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("fasting", "Fasting"),
                            ("non_fasting", "Non-fasting"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="Was this fasting or non-fasting?",
                    ),
                ),
                (
                    "glucose",
                    models.DecimalField(
                        blank=True,
                        decimal_places=4,
                        max_digits=8,
                        null=True,
                        verbose_name="Blood Glucose",
                    ),
                ),
                (
                    "glucose_units",
                    models.CharField(
                        blank=True,
                        choices=[("mg/dL", "mg/dL"), ("mmol/L", "mmol/L")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "glucose_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "glucose_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "glucose_requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="bg",
                        to="meta_subject.SubjectRequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Blood Result: Glucose",
                "verbose_name_plural": "Blood Results: Glucose",
                "abstract": False,
            },
            managers=[
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name="BloodResultsFbc",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("tracking_identifier", models.CharField(max_length=30, unique=True)),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "consent_model",
                    models.CharField(editable=False, max_length=50, null=True),
                ),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "results_abnormal",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Are any of the above results abnormal?",
                    ),
                ),
                (
                    "results_reportable",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        help_text="If YES, this value will open Adverse Event Form.<br/><br/>Note: On Day 1 only abnormal bloods should not be reported as adverseevents.",
                        max_length=25,
                        verbose_name="If any results are abnormal, are results within grade III or above?",
                    ),
                ),
                ("summary", models.TextField(blank=True, null=True)),
                (
                    "fbc_assay_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Result Report Date and Time",
                    ),
                ),
                (
                    "haemoglobin",
                    models.DecimalField(blank=True, decimal_places=1, max_digits=6, null=True),
                ),
                (
                    "haemoglobin_units",
                    models.CharField(
                        blank=True,
                        choices=[("g/dL", "g/dL")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "haemoglobin_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "haemoglobin_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "hct",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(999),
                        ],
                        verbose_name="Hematocrit",
                    ),
                ),
                (
                    "hct_units",
                    models.CharField(
                        blank=True,
                        choices=[("%", "%")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "hct_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "hct_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "rbc",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=6,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1.0),
                            django.core.validators.MaxValueValidator(999999.0),
                        ],
                        verbose_name="Red blood cell count",
                    ),
                ),
                (
                    "rbc_units",
                    models.CharField(
                        blank=True,
                        choices=[("10^9/L", "10^9/L"), ("cells/mm^3", "cells/mm^3")],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "rbc_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "rbc_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "wbc",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        max_digits=6,
                        null=True,
                        verbose_name="WBC",
                    ),
                ),
                (
                    "wbc_units",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("10^9/L", "10^9/L"),
                            ("cells/mm^3", "cells/mm<sup>3</sup>"),
                        ],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "wbc_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "wbc_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "platelets",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(9999),
                        ],
                    ),
                ),
                (
                    "platelets_units",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("10^9/L", "10^9/L"),
                            ("cells/mm^3", "cells/mm<sup>3</sup>"),
                        ],
                        max_length=10,
                        null=True,
                        verbose_name="units",
                    ),
                ),
                (
                    "platelets_abnormal",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        null=True,
                        verbose_name="abnormal",
                    ),
                ),
                (
                    "platelets_reportable",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("N/A", "Not applicable"),
                            ("3", "Yes, grade 3"),
                            ("4", "Yes, grade 4"),
                            ("No", "Not reportable"),
                            ("Already reported", "Already reported"),
                            ("present_at_baseline", "Present at baseline"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="reportable",
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "fbc_requisition",
                    models.ForeignKey(
                        blank=True,
                        help_text="Start typing the requisition identifier or select one from this visit",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="fbc",
                        to="meta_subject.SubjectRequisition",
                        verbose_name="Requisition",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="sites.Site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="meta_subject.SubjectVisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Blood Result: FBC",
                "verbose_name_plural": "Blood Results: FBC",
                "abstract": False,
            },
            managers=[
                ("on_site", edc_visit_tracking.managers.CrfCurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.AddIndex(
            model_name="urinedipsticktest",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="meta_subjec_subject_7cf807_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="subjectvisit",
            index=models.Index(
                fields=[
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "visit_code",
                    "visit_code_sequence",
                    "report_datetime",
                ],
                name="meta_subjec_subject_1ce568_idx",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="subjectvisit",
            unique_together={
                (
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "report_datetime",
                ),
                (
                    "subject_identifier",
                    "visit_schedule_name",
                    "schedule_name",
                    "visit_code",
                    "visit_code_sequence",
                ),
            },
        ),
        migrations.AlterUniqueTogether(
            name="subjectrequisition", unique_together={("panel", "subject_visit")}
        ),
        migrations.AddIndex(
            model_name="patienthistory",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="meta_subjec_subject_ceac36_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="medicationadherence",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="meta_subjec_subject_a06028_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="malariarapidtest",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="meta_subjec_subject_fc82f2_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="healtheconomics",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="meta_subjec_subject_98fe4f_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="followupvitals",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="meta_subjec_subject_832c2d_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="followup",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="meta_subjec_subject_8cd273_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="complications",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="meta_subjec_subject_7ee33b_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="bloodresultsrft",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="meta_subjec_subject_f9cf1d_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="bloodresultslft",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="meta_subjec_subject_63bf05_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="bloodresultshba1c",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="meta_subjec_subject_e39ef5_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="bloodresultsglu",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="meta_subjec_subject_b01b25_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="bloodresultsfbc",
            index=models.Index(
                fields=["subject_visit", "site", "id"],
                name="meta_subjec_subject_1371de_idx",
            ),
        ),
    ]
