import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [cognito-idp](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncognitouserpools.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class CognitoIdp extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [cognito-idp](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncognitouserpools.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Adds additional user attributes to the user pool schema.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AddCustomAttributes.html
     */
    addCustomAttributes(): this;
    /**
     * Adds the specified user to the specified group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminAddUserToGroup.html
     */
    adminAddUserToGroup(): this;
    /**
     * Confirms user registration as an admin without using a confirmation code. Works on any user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminConfirmSignUp.html
     */
    adminConfirmSignUp(): this;
    /**
     * Creates a new user in the specified user pool and sends a welcome message via email or phone (SMS).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminCreateUser.html
     */
    adminCreateUser(): this;
    /**
     * Deletes a user as an administrator. Works on any user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminDeleteUser.html
     */
    adminDeleteUser(): this;
    /**
     * Deletes the user attributes in a user pool as an administrator. Works on any user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminDeleteUserAttributes.html
     */
    adminDeleteUserAttributes(): this;
    /**
     * Disables the user from signing in with the specified external (SAML or social) identity provider.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminDisableProviderForUser.html
     */
    adminDisableProviderForUser(): this;
    /**
     * Disables the specified user as an administrator. Works on any user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminDisableUser.html
     */
    adminDisableUser(): this;
    /**
     * Enables the specified user as an administrator. Works on any user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminEnableUser.html
     */
    adminEnableUser(): this;
    /**
     * Forgets the device, as an administrator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminForgetDevice.html
     */
    adminForgetDevice(): this;
    /**
     * Gets the device, as an administrator.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminGetDevice.html
     */
    adminGetDevice(): this;
    /**
     * Gets the specified user by user name in a user pool as an administrator. Works on any user.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminGetUser.html
     */
    adminGetUser(): this;
    /**
     * Authenticates a user in a user pool as an administrator. Works on any user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html
     */
    adminInitiateAuth(): this;
    /**
     * Links an existing user account in a user pool (DestinationUser) to an identity from an external identity provider (SourceUser) based on a specified attribute name and value from the external identity provider.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminLinkProviderForUser.html
     */
    adminLinkProviderForUser(): this;
    /**
     * Lists devices, as an administrator.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminListDevices.html
     */
    adminListDevices(): this;
    /**
     * Lists the groups that the user belongs to.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminInitiateAuth.html
     */
    adminListGroupsForUser(): this;
    /**
     * Lists the authentication events for the user.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminListUserAuthEvents.html
     */
    adminListUserAuthEvents(): this;
    /**
     * Removes the specified user from the specified group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminRemoveUserFromGroup.html
     */
    adminRemoveUserFromGroup(): this;
    /**
     * Resets the specified user's password in a user pool as an administrator. Works on any user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminResetUserPassword.html
     */
    adminResetUserPassword(): this;
    /**
     * Responds to an authentication challenge, as an administrator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminRespondToAuthChallenge.html
     */
    adminRespondToAuthChallenge(): this;
    /**
     * Sets MFA preference for the user in the userpool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserMFAPreference.html
     */
    adminSetUserMFAPreference(): this;
    /**
     * Sets the specified user's password in a user pool as an administrator. Works on any user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserPassword.html
     */
    adminSetUserPassword(): this;
    /**
     * Sets all the user settings for a specified user name. Works on any user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminSetUserSettings.html
     */
    adminSetUserSettings(): this;
    /**
     * Updates the feedback for the user authentication event
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateAuthEventFeedback.html
     */
    adminUpdateAuthEventFeedback(): this;
    /**
     * Updates the device status as an administrator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateDeviceStatus.html
     */
    adminUpdateDeviceStatus(): this;
    /**
     * Updates the specified user's attributes, including developer attributes, as an administrator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html
     */
    adminUpdateUserAttributes(): this;
    /**
     * Signs out users from all devices, as an administrator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUserGlobalSignOut.html
     */
    adminUserGlobalSignOut(): this;
    /**
     * Returns a unique generated shared secret key code for the user account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AssociateSoftwareToken.html
     */
    associateSoftwareToken(): this;
    /**
     * Changes the password for a specified user in a user pool.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ChangePassword.html
     */
    changePassword(): this;
    /**
     * Confirms tracking of the device. This API call is the call that begins device tracking.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmDevice.html
     */
    confirmDevice(): this;
    /**
     * Allows a user to enter a confirmation code to reset a forgotten password.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmForgotPassword.html
     */
    confirmForgotPassword(): this;
    /**
     * Confirms registration of a user and handles the existing alias from a previous user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmSignUp.html
     */
    confirmSignUp(): this;
    /**
     * Creates a new group in the specified user pool.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateGroup.html
     */
    createGroup(): this;
    /**
     * Creates an identity provider for a user pool.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateIdentityProvider.html
     */
    createIdentityProvider(): this;
    /**
     * Creates a new OAuth2.0 resource server and defines custom scopes in it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateResourceServer.html
     */
    createResourceServer(): this;
    /**
     * Creates the user import job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserImportJob.html
     */
    createUserImportJob(): this;
    /**
     * Creates a new Amazon Cognito user pool and sets the password policy for the pool.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPool.html
     */
    createUserPool(): this;
    /**
     * Creates the user pool client.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPoolClient.html
     */
    createUserPoolClient(): this;
    /**
     * Creates a new domain for a user pool.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPoolDomain.html
     */
    createUserPoolDomain(): this;
    /**
     * Deletes a group. Currently only groups with no members can be deleted.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteGroup.html
     */
    deleteGroup(): this;
    /**
     * Deletes an identity provider for a user pool.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteIdentityProvider.html
     */
    deleteIdentityProvider(): this;
    /**
     * Deletes a resource server.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteResourceServer.html
     */
    deleteResourceServer(): this;
    /**
     * Allows a user to delete one's self.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteUser.html
     */
    deleteUser(): this;
    /**
     * Deletes the attributes for a user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteUserAttributes.html
     */
    deleteUserAttributes(): this;
    /**
     * Deletes the specified Amazon Cognito user pool.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteUserPool.html
     */
    deleteUserPool(): this;
    /**
     * Allows the developer to delete the user pool client.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteUserPoolClient.html
     */
    deleteUserPoolClient(): this;
    /**
     * Deletes a domain for a user pool.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DeleteUserPoolDomain.html
     */
    deleteUserPoolDomain(): this;
    /**
     * Gets information about a specific identity provider.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeIdentityProvider.html
     */
    describeIdentityProvider(): this;
    /**
     * Describes a resource server.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeResourceServer.html
     */
    describeResourceServer(): this;
    /**
     * Describes the risk configuration setting for the userpool / userpool client
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeRiskConfiguration.html
     */
    describeRiskConfiguration(): this;
    /**
     * Describes the user import job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserImportJob.html
     */
    describeUserImportJob(): this;
    /**
     * Returns the configuration information and metadata of the specified user pool.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html
     */
    describeUserPool(): this;
    /**
     * Client method for returning the configuration information and metadata of the specified user pool client.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolClient.html
     */
    describeUserPoolClient(): this;
    /**
     * Gets information about a domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPoolDomain.html
     */
    describeUserPoolDomain(): this;
    /**
     * Forgets the specified device.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ForgetDevice.html
     */
    forgetDevice(): this;
    /**
     * Calling this API causes a message to be sent to the end user with a confirmation code that is required to change the user's password.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ForgotPassword.html
     */
    forgotPassword(): this;
    /**
     * Gets the header information for the .csv file to be used as input for the user import job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetCSVHeader.html
     */
    getCSVHeader(): this;
    /**
     * Gets the device.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetDevice.html
     */
    getDevice(): this;
    /**
     * Gets a group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetGroup.html
     */
    getGroup(): this;
    /**
     * Gets the specified identity provider.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetIdentityProviderByIdentifier.html
     */
    getIdentityProviderByIdentifier(): this;
    /**
     * Returns the signing certificate.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetSigningCertificate.html
     */
    getSigningCertificate(): this;
    /**
     * Gets the UI Customization information for a particular app client's app UI, if there is something set.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUICustomization.html
     */
    getUICustomization(): this;
    /**
     * Gets the user attributes and metadata for a user.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUser.html
     */
    getUser(): this;
    /**
     * Gets the user attribute verification code for the specified attribute name.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUserAttributeVerificationCode.html
     */
    getUserAttributeVerificationCode(): this;
    /**
     * Gets the MFA configuration for the userpool
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUserPoolMfaConfig.html
     */
    getUserPoolMfaConfig(): this;
    /**
     * Signs out users from all devices.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GlobalSignOut.html
     */
    globalSignOut(): this;
    /**
     * Initiates the authentication flow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html
     */
    initiateAuth(): this;
    /**
     * Lists the devices.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListDevices.html
     */
    listDevices(): this;
    /**
     * Lists the groups associated with a user pool.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListGroups.html
     */
    listGroups(): this;
    /**
     * Lists information about all identity providers for a user pool.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListIdentityProviders.html
     */
    listIdentityProviders(): this;
    /**
     * Lists the resource servers for a user pool.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListResourceServers.html
     */
    listResourceServers(): this;
    /**
     * Lists the tags that are assigned to an Amazon Cognito user pool.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListTagsForResource.html
     */
    listTagsForResource(): this;
    /**
     * Lists the user import jobs..
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListUserImportJobs.html
     */
    listUserImportJobs(): this;
    /**
     * Lists the clients that have been created for the specified user pool.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListUserPoolClients.html
     */
    listUserPoolClients(): this;
    /**
     * Lists the user pools associated with an AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListUserPools.html
     */
    listUserPools(): this;
    /**
     * Lists the users in the Amazon Cognito user pool.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListUsers.html
     */
    listUsers(): this;
    /**
     * Lists the users in the specified group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ListUsersInGroup.html
     */
    listUsersInGroup(): this;
    /**
     * Resends the confirmation (for confirmation of registration) to a specific user in the user pool.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ResendConfirmationCode.html
     */
    resendConfirmationCode(): this;
    /**
     * Responds to the authentication challenge.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RespondToAuthChallenge.html
     */
    respondToAuthChallenge(): this;
    /**
     * sets the risk configuration setting for the userpool / userpool client
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetRiskConfiguration.html
     */
    setRiskConfiguration(): this;
    /**
     * Sets the UI customization information for a user pool's built-in app UI.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUICustomization.html
     */
    setUICustomization(): this;
    /**
     * Sets MFA preference for the user in the userpool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserMFAPreference.html
     */
    setUserMFAPreference(): this;
    /**
     * Sets the MFA configuration for the userpool
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserPoolMfaConfig.html
     */
    setUserPoolMfaConfig(): this;
    /**
     * Sets the user settings like multi-factor authentication (MFA).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserSettings.html
     */
    setUserSettings(): this;
    /**
     * Registers the user in the specified user pool and creates a user name, password, and user attributes.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SignUp.html
     */
    signUp(): this;
    /**
     * Starts the user import.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_StartUserImportJob.html
     */
    startUserImportJob(): this;
    /**
     * Stops the user import job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_StopUserImportJob.html
     */
    stopUserImportJob(): this;
    /**
     * Assigns a set of tags to an Amazon Cognito user pool.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_TagResource.html
     */
    tagResource(): this;
    /**
     * Removes the specified tags from an Amazon Cognito user pool.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UntagResource.html
     */
    untagResource(): this;
    /**
     * Updates the feedback for the user authentication event
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateAuthEventFeedback.html
     */
    updateAuthEventFeedback(): this;
    /**
     * Updates the device status.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateDeviceStatus.html
     */
    updateDeviceStatus(): this;
    /**
     * Updates the specified group with the specified attributes.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateGroup.html
     */
    updateGroup(): this;
    /**
     * Updates identity provider information for a user pool.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateIdentityProvider.html
     */
    updateIdentityProvider(): this;
    /**
     * Updates the name and scopes of resource server.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateResourceServer.html
     */
    updateResourceServer(): this;
    /**
     * Allows a user to update a specific attribute (one at a time).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserAttributes.html
     */
    updateUserAttributes(): this;
    /**
     * Updates the specified user pool with the specified attributes.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPool.html
     */
    updateUserPool(): this;
    /**
     * Allows the developer to update the specified user pool client and password policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPoolClient.html
     */
    updateUserPoolClient(): this;
    /**
     * Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPoolDomain.html
     */
    updateUserPoolDomain(): this;
    /**
     * Registers a user's entered TOTP code and mark the user's software token MFA status as verified if successful.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerifySoftwareToken.html
     */
    verifySoftwareToken(): this;
    /**
     * Verifies a user attribute using a one time verification code.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerifyUserAttribute.html
     */
    verifyUserAttribute(): this;
    /**
     * Adds a resource of type userpool to the statement
     *
     * https://docs.aws.amazon.com/cognito/latest/developerguide/resource-permissions.html#amazon-cognito-amazon-resource-names
     *
     * @param userPoolId - Identifier for the userPoolId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onUserpool(userPoolId: string, account?: string, region?: string, partition?: string): this;
}
