"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Inspector = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [inspector](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoninspector.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Inspector extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [inspector](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoninspector.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'inspector';
        this.actionList = {
            "AddAttributesToFindings": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_AddAttributesToFindings.html",
                "description": "Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.",
                "accessLevel": "Write"
            },
            "CreateAssessmentTarget": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTarget.html",
                "description": "Creates a new assessment target using the ARN of the resource group that is generated by CreateResourceGroup.",
                "accessLevel": "Write"
            },
            "CreateAssessmentTemplate": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTemplate.html",
                "description": "Creates an assessment template for the assessment target that is specified by the ARN of the assessment target.",
                "accessLevel": "Write"
            },
            "CreateResourceGroup": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateResourceGroup.html",
                "description": "Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target.",
                "accessLevel": "Write"
            },
            "DeleteAssessmentRun": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentRun.html",
                "description": "Deletes the assessment run that is specified by the ARN of the assessment run.",
                "accessLevel": "Write"
            },
            "DeleteAssessmentTarget": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTarget.html",
                "description": "Deletes the assessment target that is specified by the ARN of the assessment target.",
                "accessLevel": "Write"
            },
            "DeleteAssessmentTemplate": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTemplate.html",
                "description": "Deletes the assessment template that is specified by the ARN of the assessment template.",
                "accessLevel": "Write"
            },
            "DescribeAssessmentRuns": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentRuns.html",
                "description": "Describes the assessment runs that are specified by the ARNs of the assessment runs.",
                "accessLevel": "Read"
            },
            "DescribeAssessmentTargets": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTargets.html",
                "description": "Describes the assessment targets that are specified by the ARNs of the assessment targets.",
                "accessLevel": "Read"
            },
            "DescribeAssessmentTemplates": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTemplates.html",
                "description": "Describes the assessment templates that are specified by the ARNs of the assessment templates.",
                "accessLevel": "Read"
            },
            "DescribeCrossAccountAccessRole": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeCrossAccountAccessRole.html",
                "description": "Describes the IAM role that enables Amazon Inspector to access your AWS account.",
                "accessLevel": "Read"
            },
            "DescribeFindings": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeFindings.html",
                "description": "Describes the findings that are specified by the ARNs of the findings.",
                "accessLevel": "Read"
            },
            "DescribeResourceGroups": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeResourceGroups.html",
                "description": "Describes the resource groups that are specified by the ARNs of the resource groups.",
                "accessLevel": "Read"
            },
            "DescribeRulesPackages": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeRulesPackages.html",
                "description": "Describes the rules packages that are specified by the ARNs of the rules packages.",
                "accessLevel": "Read"
            },
            "GetTelemetryMetadata": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_GetTelemetryMetadata.html",
                "description": "Information about the data that is collected for the specified assessment run.",
                "accessLevel": "Read"
            },
            "ListAssessmentRunAgents": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRunAgents.html",
                "description": "Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.",
                "accessLevel": "List"
            },
            "ListAssessmentRuns": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRuns.html",
                "description": "Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the assessment templates.",
                "accessLevel": "List"
            },
            "ListAssessmentTargets": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTargets.html",
                "description": "Lists the ARNs of the assessment targets within this AWS account.",
                "accessLevel": "List"
            },
            "ListAssessmentTemplates": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTemplates.html",
                "description": "Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets.",
                "accessLevel": "List"
            },
            "ListEventSubscriptions": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListEventSubscriptions.html",
                "description": "Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment template.",
                "accessLevel": "List"
            },
            "ListFindings": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListFindings.html",
                "description": "Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.",
                "accessLevel": "List"
            },
            "ListRulesPackages": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListRulesPackages.html",
                "description": "Lists all available Amazon Inspector rules packages.",
                "accessLevel": "List"
            },
            "ListTagsForResource": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListTagsForResource.html",
                "description": "Lists all tags associated with an assessment template.",
                "accessLevel": "List"
            },
            "PreviewAgents": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_PreviewAgents.html",
                "description": "Previews the agents installed on the EC2 instances that are part of the specified assessment target.",
                "accessLevel": "Read"
            },
            "RegisterCrossAccountAccessRole": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_RegisterCrossAccountAccessRole.html",
                "description": "Registers the IAM role that Amazon Inspector uses to list your EC2 instances at the start of the assessment run or when you call the PreviewAgents action.",
                "accessLevel": "Write"
            },
            "RemoveAttributesFromFindings": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_RemoveAttributesFromFindings.html",
                "description": "Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists.",
                "accessLevel": "Write"
            },
            "SetTagsForResource": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_SetTagsForResource.html",
                "description": "Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template.",
                "accessLevel": "Tagging"
            },
            "StartAssessmentRun": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_StartAssessmentRun.html",
                "description": "Starts the assessment run specified by the ARN of the assessment template.",
                "accessLevel": "Write"
            },
            "StopAssessmentRun": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_StopAssessmentRun.html",
                "description": "Stops the assessment run that is specified by the ARN of the assessment run.",
                "accessLevel": "Write"
            },
            "SubscribeToEvent": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_SubscribeToEvent.html",
                "description": "Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.",
                "accessLevel": "Write"
            },
            "UnsubscribeFromEvent": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_UnsubscribeFromEvent.html",
                "description": "Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.",
                "accessLevel": "Write"
            },
            "UpdateAssessmentTarget": {
                "url": "https://docs.aws.amazon.com/inspector/latest/APIReference/API_UpdateAssessmentTarget.html",
                "description": "Updates the assessment target that is specified by the ARN of the assessment target.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_AddAttributesToFindings.html
     */
    addAttributesToFindings() {
        this.add('inspector:AddAttributesToFindings');
        return this;
    }
    /**
     * Creates a new assessment target using the ARN of the resource group that is generated by CreateResourceGroup.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTarget.html
     */
    createAssessmentTarget() {
        this.add('inspector:CreateAssessmentTarget');
        return this;
    }
    /**
     * Creates an assessment template for the assessment target that is specified by the ARN of the assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateAssessmentTemplate.html
     */
    createAssessmentTemplate() {
        this.add('inspector:CreateAssessmentTemplate');
        return this;
    }
    /**
     * Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_CreateResourceGroup.html
     */
    createResourceGroup() {
        this.add('inspector:CreateResourceGroup');
        return this;
    }
    /**
     * Deletes the assessment run that is specified by the ARN of the assessment run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentRun.html
     */
    deleteAssessmentRun() {
        this.add('inspector:DeleteAssessmentRun');
        return this;
    }
    /**
     * Deletes the assessment target that is specified by the ARN of the assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTarget.html
     */
    deleteAssessmentTarget() {
        this.add('inspector:DeleteAssessmentTarget');
        return this;
    }
    /**
     * Deletes the assessment template that is specified by the ARN of the assessment template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DeleteAssessmentTemplate.html
     */
    deleteAssessmentTemplate() {
        this.add('inspector:DeleteAssessmentTemplate');
        return this;
    }
    /**
     * Describes the assessment runs that are specified by the ARNs of the assessment runs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentRuns.html
     */
    describeAssessmentRuns() {
        this.add('inspector:DescribeAssessmentRuns');
        return this;
    }
    /**
     * Describes the assessment targets that are specified by the ARNs of the assessment targets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTargets.html
     */
    describeAssessmentTargets() {
        this.add('inspector:DescribeAssessmentTargets');
        return this;
    }
    /**
     * Describes the assessment templates that are specified by the ARNs of the assessment templates.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeAssessmentTemplates.html
     */
    describeAssessmentTemplates() {
        this.add('inspector:DescribeAssessmentTemplates');
        return this;
    }
    /**
     * Describes the IAM role that enables Amazon Inspector to access your AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeCrossAccountAccessRole.html
     */
    describeCrossAccountAccessRole() {
        this.add('inspector:DescribeCrossAccountAccessRole');
        return this;
    }
    /**
     * Describes the findings that are specified by the ARNs of the findings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeFindings.html
     */
    describeFindings() {
        this.add('inspector:DescribeFindings');
        return this;
    }
    /**
     * Describes the resource groups that are specified by the ARNs of the resource groups.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeResourceGroups.html
     */
    describeResourceGroups() {
        this.add('inspector:DescribeResourceGroups');
        return this;
    }
    /**
     * Describes the rules packages that are specified by the ARNs of the rules packages.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_DescribeRulesPackages.html
     */
    describeRulesPackages() {
        this.add('inspector:DescribeRulesPackages');
        return this;
    }
    /**
     * Information about the data that is collected for the specified assessment run.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_GetTelemetryMetadata.html
     */
    getTelemetryMetadata() {
        this.add('inspector:GetTelemetryMetadata');
        return this;
    }
    /**
     * Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRunAgents.html
     */
    listAssessmentRunAgents() {
        this.add('inspector:ListAssessmentRunAgents');
        return this;
    }
    /**
     * Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the assessment templates.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentRuns.html
     */
    listAssessmentRuns() {
        this.add('inspector:ListAssessmentRuns');
        return this;
    }
    /**
     * Lists the ARNs of the assessment targets within this AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTargets.html
     */
    listAssessmentTargets() {
        this.add('inspector:ListAssessmentTargets');
        return this;
    }
    /**
     * Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListAssessmentTemplates.html
     */
    listAssessmentTemplates() {
        this.add('inspector:ListAssessmentTemplates');
        return this;
    }
    /**
     * Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment template.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListEventSubscriptions.html
     */
    listEventSubscriptions() {
        this.add('inspector:ListEventSubscriptions');
        return this;
    }
    /**
     * Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListFindings.html
     */
    listFindings() {
        this.add('inspector:ListFindings');
        return this;
    }
    /**
     * Lists all available Amazon Inspector rules packages.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListRulesPackages.html
     */
    listRulesPackages() {
        this.add('inspector:ListRulesPackages');
        return this;
    }
    /**
     * Lists all tags associated with an assessment template.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_ListTagsForResource.html
     */
    listTagsForResource() {
        this.add('inspector:ListTagsForResource');
        return this;
    }
    /**
     * Previews the agents installed on the EC2 instances that are part of the specified assessment target.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_PreviewAgents.html
     */
    previewAgents() {
        this.add('inspector:PreviewAgents');
        return this;
    }
    /**
     * Registers the IAM role that Amazon Inspector uses to list your EC2 instances at the start of the assessment run or when you call the PreviewAgents action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_RegisterCrossAccountAccessRole.html
     */
    registerCrossAccountAccessRole() {
        this.add('inspector:RegisterCrossAccountAccessRole');
        return this;
    }
    /**
     * Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_RemoveAttributesFromFindings.html
     */
    removeAttributesFromFindings() {
        this.add('inspector:RemoveAttributesFromFindings');
        return this;
    }
    /**
     * Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_SetTagsForResource.html
     */
    setTagsForResource() {
        this.add('inspector:SetTagsForResource');
        return this;
    }
    /**
     * Starts the assessment run specified by the ARN of the assessment template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_StartAssessmentRun.html
     */
    startAssessmentRun() {
        this.add('inspector:StartAssessmentRun');
        return this;
    }
    /**
     * Stops the assessment run that is specified by the ARN of the assessment run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_StopAssessmentRun.html
     */
    stopAssessmentRun() {
        this.add('inspector:StopAssessmentRun');
        return this;
    }
    /**
     * Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_SubscribeToEvent.html
     */
    subscribeToEvent() {
        this.add('inspector:SubscribeToEvent');
        return this;
    }
    /**
     * Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_UnsubscribeFromEvent.html
     */
    unsubscribeFromEvent() {
        this.add('inspector:UnsubscribeFromEvent');
        return this;
    }
    /**
     * Updates the assessment target that is specified by the ARN of the assessment target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/inspector/latest/APIReference/API_UpdateAssessmentTarget.html
     */
    updateAssessmentTarget() {
        this.add('inspector:UpdateAssessmentTarget');
        return this;
    }
}
exports.Inspector = Inspector;
//# sourceMappingURL=data:application/json;base64,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