import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [machinelearning](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmachinelearning.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Machinelearning extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [machinelearning](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmachinelearning.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Adds one or more tags to an object, up to a limit of 10. Each tag consists of a key and an optional value
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_AddTags.html
     */
    addTags(): this;
    /**
     * Generates predictions for a group of observations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateBatchPrediction.html
     */
    createBatchPrediction(): this;
    /**
     * Creates a DataSource object from an Amazon RDS
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateDataSourceFromRDS.html
     */
    createDataSourceFromRDS(): this;
    /**
     * Creates a DataSource from a database hosted on an Amazon Redshift cluster
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateDataSourceFromRedshift.html
     */
    createDataSourceFromRedshift(): this;
    /**
     * Creates a DataSource object from S3
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateDataSourceFromS3.html
     */
    createDataSourceFromS3(): this;
    /**
     * Creates a new Evaluation of an MLModel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateEvaluation.html
     */
    createEvaluation(): this;
    /**
     * Creates a new MLModel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateMLModel.html
     */
    createMLModel(): this;
    /**
     * Creates a real-time endpoint for the MLModel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_CreateRealtimeEndpoint.html
     */
    createRealtimeEndpoint(): this;
    /**
     * Assigns the DELETED status to a BatchPrediction, rendering it unusable
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteBatchPrediction.html
     */
    deleteBatchPrediction(): this;
    /**
     * Assigns the DELETED status to a DataSource, rendering it unusable
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteDataSource.html
     */
    deleteDataSource(): this;
    /**
     * Assigns the DELETED status to an Evaluation, rendering it unusable
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteEvaluation.html
     */
    deleteEvaluation(): this;
    /**
     * Assigns the DELETED status to an MLModel, rendering it unusable
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteMLModel.html
     */
    deleteMLModel(): this;
    /**
     * Deletes a real time endpoint of an MLModel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteRealtimeEndpoint.html
     */
    deleteRealtimeEndpoint(): this;
    /**
     * Deletes the specified tags associated with an ML object. After this operation is complete, you can't recover deleted tags
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DeleteTags.html
     */
    deleteTags(): this;
    /**
     * Returns a list of BatchPrediction operations that match the search criteria in the request
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeBatchPredictions.html
     */
    describeBatchPredictions(): this;
    /**
     * Returns a list of DataSource that match the search criteria in the request
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeDataSources.html
     */
    describeDataSources(): this;
    /**
     * Returns a list of DescribeEvaluations that match the search criteria in the request
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeEvaluations.html
     */
    describeEvaluations(): this;
    /**
     * Returns a list of MLModel that match the search criteria in the request
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeMLModels.html
     */
    describeMLModels(): this;
    /**
     * Describes one or more of the tags for your Amazon ML object
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_DescribeTags.html
     */
    describeTags(): this;
    /**
     * Returns a BatchPrediction that includes detailed metadata, status, and data file information
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_GetBatchPrediction.html
     */
    getBatchPrediction(): this;
    /**
     * Returns a DataSource that includes metadata and data file information, as well as the current status of the DataSource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_GetDataSource.html
     */
    getDataSource(): this;
    /**
     * Returns an Evaluation that includes metadata as well as the current status of the Evaluation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_GetEvaluation.html
     */
    getEvaluation(): this;
    /**
     * Returns an MLModel that includes detailed metadata, and data source information as well as the current status of the MLModel
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_GetMLModel.html
     */
    getMLModel(): this;
    /**
     * Generates a prediction for the observation using the specified ML Model
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_Predict.html
     */
    predict(): this;
    /**
     * Updates the BatchPredictionName of a BatchPrediction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_UpdateBatchPrediction.html
     */
    updateBatchPrediction(): this;
    /**
     * Updates the DataSourceName of a DataSource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_UpdateDataSource.html
     */
    updateDataSource(): this;
    /**
     * Updates the EvaluationName of an Evaluation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_UpdateEvaluation.html
     */
    updateEvaluation(): this;
    /**
     * Updates the MLModelName and the ScoreThreshold of an MLModel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/machine-learning/latest/APIReference/API_UpdateMLModel.html
     */
    updateMLModel(): this;
    /**
     * Adds a resource of type batchprediction to the statement
     *
     * https://docs.aws.amazon.com/machine-learning/latest/dg/amazon-machine-learning-key-concepts.html#batch-predictions
     *
     * @param batchPredictionId - Identifier for the batchPredictionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onBatchprediction(batchPredictionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type datasource to the statement
     *
     * https://docs.aws.amazon.com/machine-learning/latest/dg/amazon-machine-learning-key-concepts.html#datasources
     *
     * @param datasourceId - Identifier for the datasourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onDatasource(datasourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type evaluation to the statement
     *
     * https://docs.aws.amazon.com/machine-learning/latest/dg/amazon-machine-learning-key-concepts.html#evaluations
     *
     * @param evaluationId - Identifier for the evaluationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onEvaluation(evaluationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type mlmodel to the statement
     *
     * https://docs.aws.amazon.com/machine-learning/latest/dg/amazon-machine-learning-key-concepts.html#ml-models
     *
     * @param mlModelId - Identifier for the mlModelId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onMlmodel(mlModelId: string, account?: string, region?: string, partition?: string): this;
}
