import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [ec2messages](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmessagedeliveryservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Ec2messages extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [ec2messages](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmessagedeliveryservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Acknowledges a message, ensuring it will not be delivered again
     *
     * Access Level: Write
     */
    acknowledgeMessage(): this;
    /**
     * Deletes a message
     *
     * Access Level: Write
     */
    deleteMessage(): this;
    /**
     * Fails a message, signifying the message could not be processed successfully, ensuring it cannot be replied to or delivered again
     *
     * Access Level: Write
     */
    failMessage(): this;
    /**
     * Routes traffic to the correct endpoint based on the given destination for the messages
     *
     * Access Level: Read
     */
    getEndpoint(): this;
    /**
     * Delivers messages to clients/instances using long polling
     *
     * Access Level: Read
     */
    getMessages(): this;
    /**
     * Sends replies from clients/instances to upstream service
     *
     * Access Level: Write
     */
    sendReply(): this;
}
