"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2messages = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [ec2messages](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmessagedeliveryservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Ec2messages extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [ec2messages](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmessagedeliveryservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'ec2messages';
        this.actionList = {
            "AcknowledgeMessage": {
                "url": "",
                "description": "Acknowledges a message, ensuring it will not be delivered again",
                "accessLevel": "Write"
            },
            "DeleteMessage": {
                "url": "",
                "description": "Deletes a message",
                "accessLevel": "Write"
            },
            "FailMessage": {
                "url": "",
                "description": "Fails a message, signifying the message could not be processed successfully, ensuring it cannot be replied to or delivered again",
                "accessLevel": "Write"
            },
            "GetEndpoint": {
                "url": "",
                "description": "Routes traffic to the correct endpoint based on the given destination for the messages",
                "accessLevel": "Read"
            },
            "GetMessages": {
                "url": "",
                "description": "Delivers messages to clients/instances using long polling",
                "accessLevel": "Read"
            },
            "SendReply": {
                "url": "",
                "description": "Sends replies from clients/instances to upstream service",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Acknowledges a message, ensuring it will not be delivered again
     *
     * Access Level: Write
     */
    acknowledgeMessage() {
        this.add('ec2messages:AcknowledgeMessage');
        return this;
    }
    /**
     * Deletes a message
     *
     * Access Level: Write
     */
    deleteMessage() {
        this.add('ec2messages:DeleteMessage');
        return this;
    }
    /**
     * Fails a message, signifying the message could not be processed successfully, ensuring it cannot be replied to or delivered again
     *
     * Access Level: Write
     */
    failMessage() {
        this.add('ec2messages:FailMessage');
        return this;
    }
    /**
     * Routes traffic to the correct endpoint based on the given destination for the messages
     *
     * Access Level: Read
     */
    getEndpoint() {
        this.add('ec2messages:GetEndpoint');
        return this;
    }
    /**
     * Delivers messages to clients/instances using long polling
     *
     * Access Level: Read
     */
    getMessages() {
        this.add('ec2messages:GetMessages');
        return this;
    }
    /**
     * Sends replies from clients/instances to upstream service
     *
     * Access Level: Write
     */
    sendReply() {
        this.add('ec2messages:SendReply');
        return this;
    }
}
exports.Ec2messages = Ec2messages;
//# sourceMappingURL=data:application/json;base64,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