"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Storagegateway = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [storagegateway](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonstoragegateway.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Storagegateway extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [storagegateway](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonstoragegateway.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'storagegateway';
        this.actionList = {
            "ActivateGateway": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ActivateGateway.html",
                "description": "This operation activates the gateway you previously deployed on your host.",
                "accessLevel": "Write",
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "AddCache": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddCache.html",
                "description": "This operation configures one or more gateway local disks as cache for a cached-volume gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "AddTagsToResource": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddTagsToResource.html",
                "description": "This operation adds one or more tags to the specified resource.",
                "accessLevel": "Tagging",
                "resourceTypes": {
                    "gateway": {
                        "required": false
                    },
                    "share": {
                        "required": false
                    },
                    "tape": {
                        "required": false
                    },
                    "volume": {
                        "required": false
                    }
                },
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "AddUploadBuffer": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddUploadBuffer.html",
                "description": "This operation configures one or more gateway local disks as upload buffer for a specified gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "AddWorkingStorage": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddWorkingStorage.html",
                "description": "This operation configures one or more gateway local disks as working storage for a gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "AttachVolume": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AttachVolume.html",
                "description": "This operation connects a volume to an iSCSI connection and then attaches the volume to the specified gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    },
                    "volume": {
                        "required": true
                    }
                }
            },
            "CancelArchival": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CancelArchival.html",
                "description": "Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after the archiving process is initiated.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    },
                    "tape": {
                        "required": true
                    }
                }
            },
            "CancelRetrieval": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CancelRetrieval.html",
                "description": "Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to a gateway after the retrieval process is initiated.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    },
                    "tape": {
                        "required": true
                    }
                }
            },
            "CreateCachediSCSIVolume": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateCachediSCSIVolume.html",
                "description": "This operation creates a cached volume on a specified cached gateway. This operation is supported only for the gateway-cached volume architecture.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    },
                    "volume": {
                        "required": true
                    }
                },
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "CreateNFSFileShare": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html",
                "description": "This operation creates a NFS file share on an existing file gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                },
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "CreateSMBFileShare": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateSMBFileShare.html",
                "description": "This operation creates a SMB file share on an existing file gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                },
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "CreateSnapshot": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateSnapshot.html",
                "description": "This operation initiates a snapshot of a volume.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "CreateSnapshotFromVolumeRecoveryPoint": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateSnapshotFromVolumeRecoveryPoint.html",
                "description": "This operation initiates a snapshot of a gateway from a volume recovery point.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "CreateStorediSCSIVolume": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateStorediSCSIVolume.html",
                "description": "This operation creates a volume on a specified gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                },
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "CreateTapeWithBarcode": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateTapeWithBarcode.html",
                "description": "Creates a virtual tape by using your own barcode.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                },
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "CreateTapes": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateTapes.html",
                "description": "Creates one or more virtual tapes. You write data to the virtual tapes and then archive the tapes.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                },
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "DeleteBandwidthRateLimit": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteBandwidthRateLimit.html",
                "description": "This operation deletes the bandwidth rate limits of a gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DeleteChapCredentials": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteChapCredentials.html",
                "description": "This operation deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target and initiator pair.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "target": {
                        "required": true
                    }
                }
            },
            "DeleteFileShare": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteFileShare.html",
                "description": "This operation deletes a file share from a file gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "share": {
                        "required": true
                    }
                }
            },
            "DeleteGateway": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteGateway.html",
                "description": "This operation deletes a gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DeleteSnapshotSchedule": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteSnapshotSchedule.html",
                "description": "This operation deletes a snapshot of a volume.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "DeleteTape": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteTape.html",
                "description": "Deletes the specified virtual tape.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    },
                    "tape": {
                        "required": true
                    }
                }
            },
            "DeleteTapeArchive": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteTapeArchive.html",
                "description": "Deletes the specified virtual tape from the virtual tape shelf (VTS).",
                "accessLevel": "Write"
            },
            "DeleteVolume": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteVolume.html",
                "description": "This operation deletes the specified gateway volume that you previously created using the CreateCachediSCSIVolume or CreateStorediSCSIVolume API.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "DescribeBandwidthRateLimit": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeBandwidthRateLimit.html",
                "description": "This operation returns the bandwidth rate limits of a gateway.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DescribeCache": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeCache.html",
                "description": "This operation returns information about the cache of a gateway. This operation is supported only for the gateway-cached volume architecture.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DescribeCachediSCSIVolumes": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeCachediSCSIVolumes.html",
                "description": "This operation returns a description of the gateway volumes specified in the request. This operation is supported only for the gateway-cached volume architecture.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "DescribeChapCredentials": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeChapCredentials.html",
                "description": "This operation returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials information for a specified iSCSI target, one for each target-initiator pair.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "target": {
                        "required": true
                    }
                }
            },
            "DescribeGatewayInformation": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeGatewayInformation.html",
                "description": "This operation returns metadata about a gateway such as its name, network interfaces, configured time zone, and the state (whether the gateway is running or not).",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DescribeMaintenanceStartTime": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeMaintenanceStartTime.html",
                "description": "This operation returns your gateway's weekly maintenance start time including the day and time of the week.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DescribeNFSFileShares": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeNFSFileShares.html",
                "description": "This operation gets a description for one or more file shares from a file gateway.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "share": {
                        "required": true
                    }
                }
            },
            "DescribeSMBFileShares": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeSMBFileShares.html",
                "description": "This operation gets a description for one or more file shares from a file gateway.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "share": {
                        "required": true
                    }
                }
            },
            "DescribeSMBSettings": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeSMBSettings.html",
                "description": "This operation gets a description of a Server Message Block (SMB) file share settings from a file gateway.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DescribeSnapshotSchedule": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeSnapshotSchedule.html",
                "description": "This operation describes the snapshot schedule for the specified gateway volume.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "DescribeStorediSCSIVolumes": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeStorediSCSIVolumes.html",
                "description": "This operation returns the description of the gateway volumes specified in the request.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "DescribeTapeArchives": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeTapeArchives.html",
                "description": "Returns a description of specified virtual tapes in the virtual tape shelf (VTS).",
                "accessLevel": "Read"
            },
            "DescribeTapeRecoveryPoints": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeTapeRecoveryPoints.html",
                "description": "Returns a list of virtual tape recovery points that are available for the specified gateway-VTL.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DescribeTapes": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeTapes.html",
                "description": "Returns a description of the specified Amazon Resource Name (ARN) of virtual tapes.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DescribeUploadBuffer": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeUploadBuffer.html",
                "description": "This operation returns information about the upload buffer of a gateway.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DescribeVTLDevices": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeVTLDevices.html",
                "description": "Returns a description of virtual tape library (VTL) devices for the specified gateway.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DescribeWorkingStorage": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeWorkingStorage.html",
                "description": "This operation returns information about the working storage of a gateway.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "DetachVolume": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DetachVolume.html",
                "description": "This operation disconnects a volume from an iSCSI connection and then detaches the volume from the specified gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "DisableGateway": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DisableGateway.html",
                "description": "Disables a gateway when the gateway is no longer functioning.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "JoinDomain": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_JoinDomain.html",
                "description": "This operation enables you to join an Active Directory Domain.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "ListFileShares": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListFileShares.html",
                "description": "This operation gets a list of the file shares for a specific file gateway, or the list of file shares that belong to the calling user account.",
                "accessLevel": "List",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "ListGateways": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListGateways.html",
                "description": "This operation lists gateways owned by an AWS account in a region specified in the request. The returned list is ordered by gateway Amazon Resource Name (ARN).",
                "accessLevel": "List"
            },
            "ListLocalDisks": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListLocalDisks.html",
                "description": "This operation returns a list of the gateway's local disks.",
                "accessLevel": "List",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "ListTagsForResource": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListTagsForResource.html",
                "description": "This operation lists the tags that have been added to the specified resource.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "gateway": {
                        "required": false
                    },
                    "share": {
                        "required": false
                    },
                    "tape": {
                        "required": false
                    },
                    "volume": {
                        "required": false
                    }
                }
            },
            "ListTapes": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListTapes.html",
                "description": "Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS).",
                "accessLevel": "Read",
                "resourceTypes": {
                    "tape": {
                        "required": true
                    }
                }
            },
            "ListVolumeInitiators": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListVolumeInitiators.html",
                "description": "This operation lists iSCSI initiators that are connected to a volume.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "ListVolumeRecoveryPoints": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListVolumeRecoveryPoints.html",
                "description": "This operation lists the recovery points for a specified gateway.",
                "accessLevel": "List",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "ListVolumes": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListVolumes.html",
                "description": "This operation lists the iSCSI stored volumes of a gateway.",
                "accessLevel": "List",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "NotifyWhenUploaded": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_NotifyWhenUploaded.html",
                "description": "This action sends you a notification through CloudWatch Events when all files written to your NFS file share have been uploaded to Amazon S3.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "share": {
                        "required": true
                    }
                }
            },
            "RefreshCache": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RefreshCache.html",
                "description": "This operation refreshes the cache for the specified file share.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "share": {
                        "required": true
                    }
                }
            },
            "RemoveTagsFromResource": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RemoveTagsFromResource.html",
                "description": "This operation removes one or more tags from the specified resource.",
                "accessLevel": "Tagging",
                "resourceTypes": {
                    "gateway": {
                        "required": false
                    },
                    "share": {
                        "required": false
                    },
                    "tape": {
                        "required": false
                    },
                    "volume": {
                        "required": false
                    }
                },
                "conditions": [
                    "aws:TagKeys"
                ]
            },
            "ResetCache": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ResetCache.html",
                "description": "This operation resets all cache disks that have encountered a error and makes the disks available for reconfiguration as cache storage.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "RetrieveTapeArchive": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RetrieveTapeArchive.html",
                "description": "Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a gateway-VTL.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    },
                    "tape": {
                        "required": true
                    }
                }
            },
            "RetrieveTapeRecoveryPoint": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RetrieveTapeRecoveryPoint.html",
                "description": "Retrieves the recovery point for the specified virtual tape.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    },
                    "tape": {
                        "required": true
                    }
                }
            },
            "SetLocalConsolePassword": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_SetLocalConsolePassword.html",
                "description": "Sets the password for your VM local console.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "SetSMBGuestPassword": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_SetSMBGuestPassword.html",
                "description": "Sets the password for SMB Guest user.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "ShutdownGateway": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ShutdownGateway.html",
                "description": "This operation shuts down a gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "StartGateway": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_StartGateway.html",
                "description": "This operation starts a gateway that you previously shut down.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "UpdateBandwidthRateLimit": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateBandwidthRateLimit.html",
                "description": "This operation updates the bandwidth rate limits of a gateway.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "UpdateChapCredentials": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateChapCredentials.html",
                "description": "This operation updates the Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "target": {
                        "required": true
                    }
                }
            },
            "UpdateGatewayInformation": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateGatewayInformation.html",
                "description": "This operation updates a gateway's metadata, which includes the gateway's name and time zone.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "UpdateGatewaySoftwareNow": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateGatewaySoftwareNow.html",
                "description": "This operation updates the gateway virtual machine (VM) software.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "UpdateMaintenanceStartTime": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateMaintenanceStartTime.html",
                "description": "This operation updates a gateway's weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway's time zone.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "gateway": {
                        "required": true
                    }
                }
            },
            "UpdateNFSFileShare": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateNFSFileShare.html",
                "description": "This operation updates a NFS file share.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "share": {
                        "required": true
                    }
                }
            },
            "UpdateSMBFileShare": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateSMBFileShare.html",
                "description": "This operation updates a SMB file share.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "share": {
                        "required": true
                    }
                }
            },
            "UpdateSnapshotSchedule": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateSnapshotSchedule.html",
                "description": "This operation updates a snapshot schedule configured for a gateway volume.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "volume": {
                        "required": true
                    }
                }
            },
            "UpdateVTLDeviceType": {
                "url": "https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateVTLDeviceType.html",
                "description": "This operation updates the type of medium changer in a gateway-VTL.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "device": {
                        "required": true
                    }
                }
            }
        };
        this.resourceTypes = {
            "device": {
                "name": "device",
                "url": "https://docs.aws.amazon.com/storagegateway/latest/userguide/resource_vtl-devices.html",
                "arn": "arn:${Partition}:storagegateway:${Region}:${Account}:gateway/${GatewayId}/device/${Vtldevice}",
                "conditionKeys": []
            },
            "gateway": {
                "name": "gateway",
                "url": "https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html",
                "arn": "arn:${Partition}:storagegateway:${Region}:${Account}:gateway/${GatewayId}",
                "conditionKeys": [
                    "aws:ResourceTag/${TagKey}"
                ]
            },
            "share": {
                "name": "share",
                "url": "https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateFileShare.html",
                "arn": "arn:${Partition}:storagegateway:${Region}:${Account}:share/${ShareId}",
                "conditionKeys": [
                    "aws:ResourceTag/${TagKey}"
                ]
            },
            "tape": {
                "name": "tape",
                "url": "https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html#storage-gateway-vtl-concepts",
                "arn": "arn:${Partition}:storagegateway:${Region}:${Account}:tape/${TapeBarcode}",
                "conditionKeys": [
                    "aws:ResourceTag/${TagKey}"
                ]
            },
            "target": {
                "name": "target",
                "url": "https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateVolumes.html",
                "arn": "arn:${Partition}:storagegateway:${Region}:${Account}:gateway/${GatewayId}/target/${IscsiTarget}",
                "conditionKeys": []
            },
            "volume": {
                "name": "volume",
                "url": "https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html#volume-gateway-concepts",
                "arn": "arn:${Partition}:storagegateway:${Region}:${Account}:gateway/${GatewayId}/volume/${VolumeId}",
                "conditionKeys": [
                    "aws:ResourceTag/${TagKey}"
                ]
            }
        };
    }
    /**
     * This operation activates the gateway you previously deployed on your host.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ActivateGateway.html
     */
    activateGateway() {
        this.add('storagegateway:ActivateGateway');
        return this;
    }
    /**
     * This operation configures one or more gateway local disks as cache for a cached-volume gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddCache.html
     */
    addCache() {
        this.add('storagegateway:AddCache');
        return this;
    }
    /**
     * This operation adds one or more tags to the specified resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddTagsToResource.html
     */
    addTagsToResource() {
        this.add('storagegateway:AddTagsToResource');
        return this;
    }
    /**
     * This operation configures one or more gateway local disks as upload buffer for a specified gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddUploadBuffer.html
     */
    addUploadBuffer() {
        this.add('storagegateway:AddUploadBuffer');
        return this;
    }
    /**
     * This operation configures one or more gateway local disks as working storage for a gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AddWorkingStorage.html
     */
    addWorkingStorage() {
        this.add('storagegateway:AddWorkingStorage');
        return this;
    }
    /**
     * This operation connects a volume to an iSCSI connection and then attaches the volume to the specified gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_AttachVolume.html
     */
    attachVolume() {
        this.add('storagegateway:AttachVolume');
        return this;
    }
    /**
     * Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after the archiving process is initiated.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CancelArchival.html
     */
    cancelArchival() {
        this.add('storagegateway:CancelArchival');
        return this;
    }
    /**
     * Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to a gateway after the retrieval process is initiated.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CancelRetrieval.html
     */
    cancelRetrieval() {
        this.add('storagegateway:CancelRetrieval');
        return this;
    }
    /**
     * This operation creates a cached volume on a specified cached gateway. This operation is supported only for the gateway-cached volume architecture.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateCachediSCSIVolume.html
     */
    createCachediSCSIVolume() {
        this.add('storagegateway:CreateCachediSCSIVolume');
        return this;
    }
    /**
     * This operation creates a NFS file share on an existing file gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html
     */
    createNFSFileShare() {
        this.add('storagegateway:CreateNFSFileShare');
        return this;
    }
    /**
     * This operation creates a SMB file share on an existing file gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateSMBFileShare.html
     */
    createSMBFileShare() {
        this.add('storagegateway:CreateSMBFileShare');
        return this;
    }
    /**
     * This operation initiates a snapshot of a volume.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateSnapshot.html
     */
    createSnapshot() {
        this.add('storagegateway:CreateSnapshot');
        return this;
    }
    /**
     * This operation initiates a snapshot of a gateway from a volume recovery point.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateSnapshotFromVolumeRecoveryPoint.html
     */
    createSnapshotFromVolumeRecoveryPoint() {
        this.add('storagegateway:CreateSnapshotFromVolumeRecoveryPoint');
        return this;
    }
    /**
     * This operation creates a volume on a specified gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateStorediSCSIVolume.html
     */
    createStorediSCSIVolume() {
        this.add('storagegateway:CreateStorediSCSIVolume');
        return this;
    }
    /**
     * Creates a virtual tape by using your own barcode.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateTapeWithBarcode.html
     */
    createTapeWithBarcode() {
        this.add('storagegateway:CreateTapeWithBarcode');
        return this;
    }
    /**
     * Creates one or more virtual tapes. You write data to the virtual tapes and then archive the tapes.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateTapes.html
     */
    createTapes() {
        this.add('storagegateway:CreateTapes');
        return this;
    }
    /**
     * This operation deletes the bandwidth rate limits of a gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteBandwidthRateLimit.html
     */
    deleteBandwidthRateLimit() {
        this.add('storagegateway:DeleteBandwidthRateLimit');
        return this;
    }
    /**
     * This operation deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target and initiator pair.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteChapCredentials.html
     */
    deleteChapCredentials() {
        this.add('storagegateway:DeleteChapCredentials');
        return this;
    }
    /**
     * This operation deletes a file share from a file gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteFileShare.html
     */
    deleteFileShare() {
        this.add('storagegateway:DeleteFileShare');
        return this;
    }
    /**
     * This operation deletes a gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteGateway.html
     */
    deleteGateway() {
        this.add('storagegateway:DeleteGateway');
        return this;
    }
    /**
     * This operation deletes a snapshot of a volume.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteSnapshotSchedule.html
     */
    deleteSnapshotSchedule() {
        this.add('storagegateway:DeleteSnapshotSchedule');
        return this;
    }
    /**
     * Deletes the specified virtual tape.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteTape.html
     */
    deleteTape() {
        this.add('storagegateway:DeleteTape');
        return this;
    }
    /**
     * Deletes the specified virtual tape from the virtual tape shelf (VTS).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteTapeArchive.html
     */
    deleteTapeArchive() {
        this.add('storagegateway:DeleteTapeArchive');
        return this;
    }
    /**
     * This operation deletes the specified gateway volume that you previously created using the CreateCachediSCSIVolume or CreateStorediSCSIVolume API.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DeleteVolume.html
     */
    deleteVolume() {
        this.add('storagegateway:DeleteVolume');
        return this;
    }
    /**
     * This operation returns the bandwidth rate limits of a gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeBandwidthRateLimit.html
     */
    describeBandwidthRateLimit() {
        this.add('storagegateway:DescribeBandwidthRateLimit');
        return this;
    }
    /**
     * This operation returns information about the cache of a gateway. This operation is supported only for the gateway-cached volume architecture.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeCache.html
     */
    describeCache() {
        this.add('storagegateway:DescribeCache');
        return this;
    }
    /**
     * This operation returns a description of the gateway volumes specified in the request. This operation is supported only for the gateway-cached volume architecture.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeCachediSCSIVolumes.html
     */
    describeCachediSCSIVolumes() {
        this.add('storagegateway:DescribeCachediSCSIVolumes');
        return this;
    }
    /**
     * This operation returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials information for a specified iSCSI target, one for each target-initiator pair.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeChapCredentials.html
     */
    describeChapCredentials() {
        this.add('storagegateway:DescribeChapCredentials');
        return this;
    }
    /**
     * This operation returns metadata about a gateway such as its name, network interfaces, configured time zone, and the state (whether the gateway is running or not).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeGatewayInformation.html
     */
    describeGatewayInformation() {
        this.add('storagegateway:DescribeGatewayInformation');
        return this;
    }
    /**
     * This operation returns your gateway's weekly maintenance start time including the day and time of the week.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeMaintenanceStartTime.html
     */
    describeMaintenanceStartTime() {
        this.add('storagegateway:DescribeMaintenanceStartTime');
        return this;
    }
    /**
     * This operation gets a description for one or more file shares from a file gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeNFSFileShares.html
     */
    describeNFSFileShares() {
        this.add('storagegateway:DescribeNFSFileShares');
        return this;
    }
    /**
     * This operation gets a description for one or more file shares from a file gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeSMBFileShares.html
     */
    describeSMBFileShares() {
        this.add('storagegateway:DescribeSMBFileShares');
        return this;
    }
    /**
     * This operation gets a description of a Server Message Block (SMB) file share settings from a file gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeSMBSettings.html
     */
    describeSMBSettings() {
        this.add('storagegateway:DescribeSMBSettings');
        return this;
    }
    /**
     * This operation describes the snapshot schedule for the specified gateway volume.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeSnapshotSchedule.html
     */
    describeSnapshotSchedule() {
        this.add('storagegateway:DescribeSnapshotSchedule');
        return this;
    }
    /**
     * This operation returns the description of the gateway volumes specified in the request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeStorediSCSIVolumes.html
     */
    describeStorediSCSIVolumes() {
        this.add('storagegateway:DescribeStorediSCSIVolumes');
        return this;
    }
    /**
     * Returns a description of specified virtual tapes in the virtual tape shelf (VTS).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeTapeArchives.html
     */
    describeTapeArchives() {
        this.add('storagegateway:DescribeTapeArchives');
        return this;
    }
    /**
     * Returns a list of virtual tape recovery points that are available for the specified gateway-VTL.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeTapeRecoveryPoints.html
     */
    describeTapeRecoveryPoints() {
        this.add('storagegateway:DescribeTapeRecoveryPoints');
        return this;
    }
    /**
     * Returns a description of the specified Amazon Resource Name (ARN) of virtual tapes.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeTapes.html
     */
    describeTapes() {
        this.add('storagegateway:DescribeTapes');
        return this;
    }
    /**
     * This operation returns information about the upload buffer of a gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeUploadBuffer.html
     */
    describeUploadBuffer() {
        this.add('storagegateway:DescribeUploadBuffer');
        return this;
    }
    /**
     * Returns a description of virtual tape library (VTL) devices for the specified gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeVTLDevices.html
     */
    describeVTLDevices() {
        this.add('storagegateway:DescribeVTLDevices');
        return this;
    }
    /**
     * This operation returns information about the working storage of a gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DescribeWorkingStorage.html
     */
    describeWorkingStorage() {
        this.add('storagegateway:DescribeWorkingStorage');
        return this;
    }
    /**
     * This operation disconnects a volume from an iSCSI connection and then detaches the volume from the specified gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DetachVolume.html
     */
    detachVolume() {
        this.add('storagegateway:DetachVolume');
        return this;
    }
    /**
     * Disables a gateway when the gateway is no longer functioning.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_DisableGateway.html
     */
    disableGateway() {
        this.add('storagegateway:DisableGateway');
        return this;
    }
    /**
     * This operation enables you to join an Active Directory Domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_JoinDomain.html
     */
    joinDomain() {
        this.add('storagegateway:JoinDomain');
        return this;
    }
    /**
     * This operation gets a list of the file shares for a specific file gateway, or the list of file shares that belong to the calling user account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListFileShares.html
     */
    listFileShares() {
        this.add('storagegateway:ListFileShares');
        return this;
    }
    /**
     * This operation lists gateways owned by an AWS account in a region specified in the request. The returned list is ordered by gateway Amazon Resource Name (ARN).
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListGateways.html
     */
    listGateways() {
        this.add('storagegateway:ListGateways');
        return this;
    }
    /**
     * This operation returns a list of the gateway's local disks.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListLocalDisks.html
     */
    listLocalDisks() {
        this.add('storagegateway:ListLocalDisks');
        return this;
    }
    /**
     * This operation lists the tags that have been added to the specified resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListTagsForResource.html
     */
    listTagsForResource() {
        this.add('storagegateway:ListTagsForResource');
        return this;
    }
    /**
     * Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListTapes.html
     */
    listTapes() {
        this.add('storagegateway:ListTapes');
        return this;
    }
    /**
     * This operation lists iSCSI initiators that are connected to a volume.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListVolumeInitiators.html
     */
    listVolumeInitiators() {
        this.add('storagegateway:ListVolumeInitiators');
        return this;
    }
    /**
     * This operation lists the recovery points for a specified gateway.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListVolumeRecoveryPoints.html
     */
    listVolumeRecoveryPoints() {
        this.add('storagegateway:ListVolumeRecoveryPoints');
        return this;
    }
    /**
     * This operation lists the iSCSI stored volumes of a gateway.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ListVolumes.html
     */
    listVolumes() {
        this.add('storagegateway:ListVolumes');
        return this;
    }
    /**
     * This action sends you a notification through CloudWatch Events when all files written to your NFS file share have been uploaded to Amazon S3.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_NotifyWhenUploaded.html
     */
    notifyWhenUploaded() {
        this.add('storagegateway:NotifyWhenUploaded');
        return this;
    }
    /**
     * This operation refreshes the cache for the specified file share.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RefreshCache.html
     */
    refreshCache() {
        this.add('storagegateway:RefreshCache');
        return this;
    }
    /**
     * This operation removes one or more tags from the specified resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RemoveTagsFromResource.html
     */
    removeTagsFromResource() {
        this.add('storagegateway:RemoveTagsFromResource');
        return this;
    }
    /**
     * This operation resets all cache disks that have encountered a error and makes the disks available for reconfiguration as cache storage.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ResetCache.html
     */
    resetCache() {
        this.add('storagegateway:ResetCache');
        return this;
    }
    /**
     * Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a gateway-VTL.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RetrieveTapeArchive.html
     */
    retrieveTapeArchive() {
        this.add('storagegateway:RetrieveTapeArchive');
        return this;
    }
    /**
     * Retrieves the recovery point for the specified virtual tape.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_RetrieveTapeRecoveryPoint.html
     */
    retrieveTapeRecoveryPoint() {
        this.add('storagegateway:RetrieveTapeRecoveryPoint');
        return this;
    }
    /**
     * Sets the password for your VM local console.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_SetLocalConsolePassword.html
     */
    setLocalConsolePassword() {
        this.add('storagegateway:SetLocalConsolePassword');
        return this;
    }
    /**
     * Sets the password for SMB Guest user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_SetSMBGuestPassword.html
     */
    setSMBGuestPassword() {
        this.add('storagegateway:SetSMBGuestPassword');
        return this;
    }
    /**
     * This operation shuts down a gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_ShutdownGateway.html
     */
    shutdownGateway() {
        this.add('storagegateway:ShutdownGateway');
        return this;
    }
    /**
     * This operation starts a gateway that you previously shut down.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_StartGateway.html
     */
    startGateway() {
        this.add('storagegateway:StartGateway');
        return this;
    }
    /**
     * This operation updates the bandwidth rate limits of a gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateBandwidthRateLimit.html
     */
    updateBandwidthRateLimit() {
        this.add('storagegateway:UpdateBandwidthRateLimit');
        return this;
    }
    /**
     * This operation updates the Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateChapCredentials.html
     */
    updateChapCredentials() {
        this.add('storagegateway:UpdateChapCredentials');
        return this;
    }
    /**
     * This operation updates a gateway's metadata, which includes the gateway's name and time zone.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateGatewayInformation.html
     */
    updateGatewayInformation() {
        this.add('storagegateway:UpdateGatewayInformation');
        return this;
    }
    /**
     * This operation updates the gateway virtual machine (VM) software.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateGatewaySoftwareNow.html
     */
    updateGatewaySoftwareNow() {
        this.add('storagegateway:UpdateGatewaySoftwareNow');
        return this;
    }
    /**
     * This operation updates a gateway's weekly maintenance start time information, including day and time of the week. The maintenance time is the time in your gateway's time zone.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateMaintenanceStartTime.html
     */
    updateMaintenanceStartTime() {
        this.add('storagegateway:UpdateMaintenanceStartTime');
        return this;
    }
    /**
     * This operation updates a NFS file share.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateNFSFileShare.html
     */
    updateNFSFileShare() {
        this.add('storagegateway:UpdateNFSFileShare');
        return this;
    }
    /**
     * This operation updates a SMB file share.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateSMBFileShare.html
     */
    updateSMBFileShare() {
        this.add('storagegateway:UpdateSMBFileShare');
        return this;
    }
    /**
     * This operation updates a snapshot schedule configured for a gateway volume.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateSnapshotSchedule.html
     */
    updateSnapshotSchedule() {
        this.add('storagegateway:UpdateSnapshotSchedule');
        return this;
    }
    /**
     * This operation updates the type of medium changer in a gateway-VTL.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_UpdateVTLDeviceType.html
     */
    updateVTLDeviceType() {
        this.add('storagegateway:UpdateVTLDeviceType');
        return this;
    }
    /**
     * Adds a resource of type device to the statement
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/resource_vtl-devices.html
     *
     * @param gatewayId - Identifier for the gatewayId.
     * @param vtldevice - Identifier for the vtldevice.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onDevice(gatewayId, vtldevice, account, region, partition) {
        var arn = 'arn:${Partition}:storagegateway:${Region}:${Account}:gateway/${GatewayId}/device/${Vtldevice}';
        arn = arn.replace('${GatewayId}', gatewayId);
        arn = arn.replace('${Vtldevice}', vtldevice);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type gateway to the statement
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html
     *
     * @param gatewayId - Identifier for the gatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onGateway(gatewayId, account, region, partition) {
        var arn = 'arn:${Partition}:storagegateway:${Region}:${Account}:gateway/${GatewayId}';
        arn = arn.replace('${GatewayId}', gatewayId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type share to the statement
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateFileShare.html
     *
     * @param shareId - Identifier for the shareId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onShare(shareId, account, region, partition) {
        var arn = 'arn:${Partition}:storagegateway:${Region}:${Account}:share/${ShareId}';
        arn = arn.replace('${ShareId}', shareId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type tape to the statement
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html#storage-gateway-vtl-concepts
     *
     * @param tapeBarcode - Identifier for the tapeBarcode.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onTape(tapeBarcode, account, region, partition) {
        var arn = 'arn:${Partition}:storagegateway:${Region}:${Account}:tape/${TapeBarcode}';
        arn = arn.replace('${TapeBarcode}', tapeBarcode);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type target to the statement
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedCreateVolumes.html
     *
     * @param gatewayId - Identifier for the gatewayId.
     * @param iscsiTarget - Identifier for the iscsiTarget.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onTarget(gatewayId, iscsiTarget, account, region, partition) {
        var arn = 'arn:${Partition}:storagegateway:${Region}:${Account}:gateway/${GatewayId}/target/${IscsiTarget}';
        arn = arn.replace('${GatewayId}', gatewayId);
        arn = arn.replace('${IscsiTarget}', iscsiTarget);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type volume to the statement
     *
     * https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html#volume-gateway-concepts
     *
     * @param gatewayId - Identifier for the gatewayId.
     * @param volumeId - Identifier for the volumeId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onVolume(gatewayId, volumeId, account, region, partition) {
        var arn = 'arn:${Partition}:storagegateway:${Region}:${Account}:gateway/${GatewayId}/volume/${VolumeId}';
        arn = arn.replace('${GatewayId}', gatewayId);
        arn = arn.replace('${VolumeId}', volumeId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
}
exports.Storagegateway = Storagegateway;
//# sourceMappingURL=data:application/json;base64,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