import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [dataexchange](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsdataexchange.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Dataexchange extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [dataexchange](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsdataexchange.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permissions to cancel a job.
     *
     * Access Level: Write
     */
    cancelJob(): this;
    /**
     * Grants permission to create an asset (for example, in a Job).
     *
     * Access Level: Write
     */
    createAsset(): this;
    /**
     * Grants permission to create a data set.
     *
     * Access Level: Write
     */
    createDataSet(): this;
    /**
     * Grants permissions to create a job to import or export assets.
     *
     * Access Level: Write
     */
    createJob(): this;
    /**
     * Grants permission to create a revision.
     *
     * Access Level: Write
     */
    createRevision(): this;
    /**
     * Grants permissions to delete an asset.
     *
     * Access Level: Write
     */
    deleteAsset(): this;
    /**
     * Grants permissions to delete a data set.
     *
     * Access Level: Write
     */
    deleteDataSet(): this;
    /**
     * Grants permissions to delete a revision.
     *
     * Access Level: Write
     */
    deleteRevision(): this;
    /**
     * Grants permissions to get information about an asset and to export it (for example, in a Job).
     *
     * Access Level: Read
     */
    getAsset(): this;
    /**
     * Grants permission to get information about a data set.
     *
     * Access Level: Read
     */
    getDataSet(): this;
    /**
     * Grants permissions to get information about a job.
     *
     * Access Level: Write
     */
    getJob(): this;
    /**
     * Grants permission to get information about a revision.
     *
     * Access Level: Read
     */
    getRevision(): this;
    /**
     * Grants permissions to list the revisions of a data set.
     *
     * Access Level: List
     */
    listDataSetRevisions(): this;
    /**
     * Grants permission to list data sets for the account.
     *
     * Access Level: List
     */
    listDataSets(): this;
    /**
     * Grants permissions to list jobs for the account.
     *
     * Access Level: List
     */
    listJobs(): this;
    /**
     * Grants permissions to get list the assets of a revision.
     *
     * Access Level: List
     */
    listRevisionAssets(): this;
    /**
     * Grants permission to list the tags that you associated with the specified resource.
     *
     * Access Level: Read
     */
    listTagsForResource(): this;
    /**
     * Grants permissions to start a job.
     *
     * Access Level: Write
     */
    startJob(): this;
    /**
     * Grants permission to add one or more tags to a specified resource.
     *
     * Access Level: Tagging
     */
    tagResource(): this;
    /**
     * Grants permission to remove one or more tags from a specified resource.
     *
     * Access Level: Tagging
     */
    untagResource(): this;
    /**
     * Grants permissions to get update information about an asset.
     *
     * Access Level: Write
     */
    updateAsset(): this;
    /**
     * Grants permissions to update information about a data set.
     *
     * Access Level: Write
     */
    updateDataSet(): this;
    /**
     * Grants permissions to update information about a revision.
     *
     * Access Level: Write
     */
    updateRevision(): this;
    /**
     * Adds a resource of type jobs to the statement
     *
     * https://docs.aws.amazon.com/data-exchange/latest/userguide/jobs.html
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - dataexchange:JobType
     */
    onJobs(jobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type data-sets to the statement
     *
     * https://docs.aws.amazon.com/data-exchange/latest/userguide/data-sets.html
     *
     * @param dataSetId - Identifier for the dataSetId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onDataSets(dataSetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type revisions to the statement
     *
     * https://docs.aws.amazon.com/data-exchange/latest/userguide/data-sets.html#revisions
     *
     * @param dataSetId - Identifier for the dataSetId.
     * @param revisionId - Identifier for the revisionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onRevisions(dataSetId: string, revisionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type assets to the statement
     *
     * https://docs.aws.amazon.com/data-exchange/latest/userguide/data-sets.html#assets
     *
     * @param dataSetId - Identifier for the dataSetId.
     * @param revisionId - Identifier for the revisionId.
     * @param assetId - Identifier for the assetId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onAssets(dataSetId: string, revisionId: string, assetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Indicates that the action can only be performed on the specified job type.
     *
     * https://docs.aws.amazon.com/data-exchange/latest/userguide/access-control.html
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifJobType(value: string | string[], operator?: string): this;
}
