"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Iotthingsgraph = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [iotthingsgraph](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsiotthingsgraph.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Iotthingsgraph extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [iotthingsgraph](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsiotthingsgraph.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'iotthingsgraph';
        this.actionList = {
            "AssociateEntityToThing": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_AssociateEntityToThing.html",
                "description": "Associates a device with a concrete thing that is in the user's registry. A thing can be associated with only one device at a time. If you associate a thing with a new device id, its previous association will be removed.",
                "accessLevel": "Write"
            },
            "CreateFlowTemplate": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_CreateFlowTemplate.html",
                "description": "Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.",
                "accessLevel": "Write"
            },
            "CreateSystemInstance": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_CreateSystemInstance.html",
                "description": "Creates an instance of a system with specified configurations and Things.",
                "accessLevel": "Tagging",
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "CreateSystemTemplate": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_CreateSystemTemplate.html",
                "description": "Creates a system. The system is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.",
                "accessLevel": "Write"
            },
            "DeleteFlowTemplate": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeleteFlowTemplate.html",
                "description": "Deletes a workflow. Any new system or system instance that contains this workflow will fail to update or deploy. Existing system instances that contain the workflow will continue to run (since they use a snapshot of the workflow taken at the time of deploying the system instance).",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Workflow": {
                        "required": true
                    }
                }
            },
            "DeleteNamespace": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeleteNamespace.html",
                "description": "Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and flows in the namespace before performing this action.",
                "accessLevel": "Write"
            },
            "DeleteSystemInstance": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeleteSystemInstance.html",
                "description": "Deletes a system instance. Only instances that have never been deployed, or that have been undeployed from the target can be deleted. Users can create a new system instance that has the same ID as a deleted system instance.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "SystemInstance": {
                        "required": true
                    }
                }
            },
            "DeleteSystemTemplate": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeleteSystemTemplate.html",
                "description": "Deletes a system. New system instances can't contain the system after its deletion. Existing system instances that contain the system will continue to work because they use a snapshot of the system that is taken when it is deployed.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "System": {
                        "required": true
                    }
                }
            },
            "DeploySystemInstance": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeploySystemInstance.html",
                "description": "Deploys the system instance to the target specified in CreateSystemInstance.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "SystemInstance": {
                        "required": true
                    }
                }
            },
            "DeprecateFlowTemplate": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeprecateFlowTemplate.html",
                "description": "Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be deployed, but existing system instances that use the flow will continue to run.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Workflow": {
                        "required": true
                    }
                }
            },
            "DeprecateSystemTemplate": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeprecateSystemTemplate.html",
                "description": "Deprecates the specified system.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "System": {
                        "required": true
                    }
                }
            },
            "DescribeNamespace": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DescribeNamespace.html",
                "description": "Gets the latest version of the user's namespace and the public version that it is tracking.",
                "accessLevel": "Read"
            },
            "DissociateEntityFromThing": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DissociateEntityFromThing.html",
                "description": "Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to dissociate because only one entity of a particular type can be associated with a thing.",
                "accessLevel": "Write"
            },
            "GetEntities": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetEntities.html",
                "description": "Gets descriptions of the specified entities. Uses the latest version of the user's namespace by default.",
                "accessLevel": "Read"
            },
            "GetFlowTemplate": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetFlowTemplate.html",
                "description": "Gets the latest version of the DefinitionDocument and FlowTemplateSummary for the specified workflow.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "Workflow": {
                        "required": true
                    }
                }
            },
            "GetFlowTemplateRevisions": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetFlowTemplateRevisions.html",
                "description": "Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been deprecated, this action will return revisions that occurred before the deprecation. This action won't work for workflows that have been deleted.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "Workflow": {
                        "required": true
                    }
                }
            },
            "GetNamespaceDeletionStatus": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetNamespaceDeletionStatus.html",
                "description": "Gets the status of a namespace deletion task.",
                "accessLevel": "Read"
            },
            "GetSystemInstance": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetSystemInstance.html",
                "description": "Gets a system instance.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "SystemInstance": {
                        "required": true
                    }
                }
            },
            "GetSystemTemplate": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetSystemTemplate.html",
                "description": "Gets a system.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "System": {
                        "required": true
                    }
                }
            },
            "GetSystemTemplateRevisions": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetSystemTemplateRevisions.html",
                "description": "Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system has been deprecated, this action will return the revisions that occurred before its deprecation. This action won't work with systems that have been deleted.",
                "accessLevel": "Read",
                "resourceTypes": {
                    "System": {
                        "required": true
                    }
                }
            },
            "GetUploadStatus": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetUploadStatus.html",
                "description": "Gets the status of the specified upload.",
                "accessLevel": "Read"
            },
            "ListFlowExecutionMessages": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_ListFlowExecutionMessages.html",
                "description": "Lists details of a single workflow execution",
                "accessLevel": "List"
            },
            "ListTagsForResource": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_ListTagsForResource.html",
                "description": "Lists all tags for a given resource",
                "accessLevel": "List",
                "resourceTypes": {
                    "SystemInstance": {
                        "required": false
                    }
                }
            },
            "SearchEntities": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchEntities.html",
                "description": "Searches for entities of the specified type. You can search for entities in your namespace and the public namespace that you're tracking.",
                "accessLevel": "Read"
            },
            "SearchFlowExecutions": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchFlowExecutions.html",
                "description": "Searches for workflow executions of a system instance",
                "accessLevel": "Read",
                "resourceTypes": {
                    "SystemInstance": {
                        "required": true
                    }
                }
            },
            "SearchFlowTemplates": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchFlowTemplates.html",
                "description": "Searches for summary information about workflows.",
                "accessLevel": "Read"
            },
            "SearchSystemInstances": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchSystemInstances.html",
                "description": "Searches for system instances in the user's account.",
                "accessLevel": "Read"
            },
            "SearchSystemTemplates": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchSystemTemplates.html",
                "description": "Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to return only systems that use the specified workflow.",
                "accessLevel": "Read"
            },
            "SearchThings": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchThings.html",
                "description": "Searches for things associated with the specified entity. You can search by both device and device model.",
                "accessLevel": "Read"
            },
            "TagResource": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_TagResource.html",
                "description": "Tag a specified resource",
                "accessLevel": "Tagging",
                "resourceTypes": {
                    "SystemInstance": {
                        "required": false
                    }
                },
                "conditions": [
                    "aws:RequestTag/${TagKey}",
                    "aws:TagKeys"
                ]
            },
            "UndeploySystemInstance": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UndeploySystemInstance.html",
                "description": "Removes the system instance and associated triggers from the target.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "SystemInstance": {
                        "required": true
                    }
                }
            },
            "UntagResource": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UntagResource.html",
                "description": "Untag a specified resource",
                "accessLevel": "Tagging",
                "resourceTypes": {
                    "SystemInstance": {
                        "required": false
                    }
                },
                "conditions": [
                    "aws:TagKeys"
                ]
            },
            "UpdateFlowTemplate": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UpdateFlowTemplate.html",
                "description": "Updates the specified workflow. All deployed systems and system instances that use the workflow will see the changes in the flow when it is redeployed. The workflow can contain only entities in the specified namespace.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "Workflow": {
                        "required": true
                    }
                }
            },
            "UpdateSystemTemplate": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UpdateSystemTemplate.html",
                "description": "Updates the specified system. You don't need to run this action after updating a workflow. Any system instance that uses the system will see the changes in the system when it is redeployed.",
                "accessLevel": "Write",
                "resourceTypes": {
                    "System": {
                        "required": true
                    }
                }
            },
            "UploadEntityDefinitions": {
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UploadEntityDefinitions.html",
                "description": "Asynchronously uploads one or more entity definitions to the user's namespace.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {
            "Workflow": {
                "name": "Workflow",
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-models-tdm-iot-workflow.html",
                "arn": "arn:${Partition}:iotthingsgraph:${Region}:${Account}:Workflow/${NamespacePath}",
                "conditionKeys": []
            },
            "System": {
                "name": "System",
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-models-tdm-iot-system.html",
                "arn": "arn:${Partition}:iotthingsgraph:${Region}:${Account}:System/${NamespacePath}",
                "conditionKeys": []
            },
            "SystemInstance": {
                "name": "SystemInstance",
                "url": "https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-models-tdm-iot-sdc-deployconfig.html",
                "arn": "arn:${Partition}:iotthingsgraph:${Region}:${Account}:Deployment/${NamespacePath}",
                "conditionKeys": [
                    "aws:ResourceTag/${TagKey}"
                ]
            }
        };
    }
    /**
     * Associates a device with a concrete thing that is in the user's registry. A thing can be associated with only one device at a time. If you associate a thing with a new device id, its previous association will be removed.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_AssociateEntityToThing.html
     */
    associateEntityToThing() {
        this.add('iotthingsgraph:AssociateEntityToThing');
        return this;
    }
    /**
     * Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_CreateFlowTemplate.html
     */
    createFlowTemplate() {
        this.add('iotthingsgraph:CreateFlowTemplate');
        return this;
    }
    /**
     * Creates an instance of a system with specified configurations and Things.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_CreateSystemInstance.html
     */
    createSystemInstance() {
        this.add('iotthingsgraph:CreateSystemInstance');
        return this;
    }
    /**
     * Creates a system. The system is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_CreateSystemTemplate.html
     */
    createSystemTemplate() {
        this.add('iotthingsgraph:CreateSystemTemplate');
        return this;
    }
    /**
     * Deletes a workflow. Any new system or system instance that contains this workflow will fail to update or deploy. Existing system instances that contain the workflow will continue to run (since they use a snapshot of the workflow taken at the time of deploying the system instance).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeleteFlowTemplate.html
     */
    deleteFlowTemplate() {
        this.add('iotthingsgraph:DeleteFlowTemplate');
        return this;
    }
    /**
     * Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and flows in the namespace before performing this action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeleteNamespace.html
     */
    deleteNamespace() {
        this.add('iotthingsgraph:DeleteNamespace');
        return this;
    }
    /**
     * Deletes a system instance. Only instances that have never been deployed, or that have been undeployed from the target can be deleted. Users can create a new system instance that has the same ID as a deleted system instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeleteSystemInstance.html
     */
    deleteSystemInstance() {
        this.add('iotthingsgraph:DeleteSystemInstance');
        return this;
    }
    /**
     * Deletes a system. New system instances can't contain the system after its deletion. Existing system instances that contain the system will continue to work because they use a snapshot of the system that is taken when it is deployed.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeleteSystemTemplate.html
     */
    deleteSystemTemplate() {
        this.add('iotthingsgraph:DeleteSystemTemplate');
        return this;
    }
    /**
     * Deploys the system instance to the target specified in CreateSystemInstance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeploySystemInstance.html
     */
    deploySystemInstance() {
        this.add('iotthingsgraph:DeploySystemInstance');
        return this;
    }
    /**
     * Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be deployed, but existing system instances that use the flow will continue to run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeprecateFlowTemplate.html
     */
    deprecateFlowTemplate() {
        this.add('iotthingsgraph:DeprecateFlowTemplate');
        return this;
    }
    /**
     * Deprecates the specified system.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DeprecateSystemTemplate.html
     */
    deprecateSystemTemplate() {
        this.add('iotthingsgraph:DeprecateSystemTemplate');
        return this;
    }
    /**
     * Gets the latest version of the user's namespace and the public version that it is tracking.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DescribeNamespace.html
     */
    describeNamespace() {
        this.add('iotthingsgraph:DescribeNamespace');
        return this;
    }
    /**
     * Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to dissociate because only one entity of a particular type can be associated with a thing.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_DissociateEntityFromThing.html
     */
    dissociateEntityFromThing() {
        this.add('iotthingsgraph:DissociateEntityFromThing');
        return this;
    }
    /**
     * Gets descriptions of the specified entities. Uses the latest version of the user's namespace by default.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetEntities.html
     */
    getEntities() {
        this.add('iotthingsgraph:GetEntities');
        return this;
    }
    /**
     * Gets the latest version of the DefinitionDocument and FlowTemplateSummary for the specified workflow.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetFlowTemplate.html
     */
    getFlowTemplate() {
        this.add('iotthingsgraph:GetFlowTemplate');
        return this;
    }
    /**
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been deprecated, this action will return revisions that occurred before the deprecation. This action won't work for workflows that have been deleted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetFlowTemplateRevisions.html
     */
    getFlowTemplateRevisions() {
        this.add('iotthingsgraph:GetFlowTemplateRevisions');
        return this;
    }
    /**
     * Gets the status of a namespace deletion task.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetNamespaceDeletionStatus.html
     */
    getNamespaceDeletionStatus() {
        this.add('iotthingsgraph:GetNamespaceDeletionStatus');
        return this;
    }
    /**
     * Gets a system instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetSystemInstance.html
     */
    getSystemInstance() {
        this.add('iotthingsgraph:GetSystemInstance');
        return this;
    }
    /**
     * Gets a system.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetSystemTemplate.html
     */
    getSystemTemplate() {
        this.add('iotthingsgraph:GetSystemTemplate');
        return this;
    }
    /**
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system has been deprecated, this action will return the revisions that occurred before its deprecation. This action won't work with systems that have been deleted.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetSystemTemplateRevisions.html
     */
    getSystemTemplateRevisions() {
        this.add('iotthingsgraph:GetSystemTemplateRevisions');
        return this;
    }
    /**
     * Gets the status of the specified upload.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_GetUploadStatus.html
     */
    getUploadStatus() {
        this.add('iotthingsgraph:GetUploadStatus');
        return this;
    }
    /**
     * Lists details of a single workflow execution
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_ListFlowExecutionMessages.html
     */
    listFlowExecutionMessages() {
        this.add('iotthingsgraph:ListFlowExecutionMessages');
        return this;
    }
    /**
     * Lists all tags for a given resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_ListTagsForResource.html
     */
    listTagsForResource() {
        this.add('iotthingsgraph:ListTagsForResource');
        return this;
    }
    /**
     * Searches for entities of the specified type. You can search for entities in your namespace and the public namespace that you're tracking.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchEntities.html
     */
    searchEntities() {
        this.add('iotthingsgraph:SearchEntities');
        return this;
    }
    /**
     * Searches for workflow executions of a system instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchFlowExecutions.html
     */
    searchFlowExecutions() {
        this.add('iotthingsgraph:SearchFlowExecutions');
        return this;
    }
    /**
     * Searches for summary information about workflows.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchFlowTemplates.html
     */
    searchFlowTemplates() {
        this.add('iotthingsgraph:SearchFlowTemplates');
        return this;
    }
    /**
     * Searches for system instances in the user's account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchSystemInstances.html
     */
    searchSystemInstances() {
        this.add('iotthingsgraph:SearchSystemInstances');
        return this;
    }
    /**
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to return only systems that use the specified workflow.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchSystemTemplates.html
     */
    searchSystemTemplates() {
        this.add('iotthingsgraph:SearchSystemTemplates');
        return this;
    }
    /**
     * Searches for things associated with the specified entity. You can search by both device and device model.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_SearchThings.html
     */
    searchThings() {
        this.add('iotthingsgraph:SearchThings');
        return this;
    }
    /**
     * Tag a specified resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_TagResource.html
     */
    tagResource() {
        this.add('iotthingsgraph:TagResource');
        return this;
    }
    /**
     * Removes the system instance and associated triggers from the target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UndeploySystemInstance.html
     */
    undeploySystemInstance() {
        this.add('iotthingsgraph:UndeploySystemInstance');
        return this;
    }
    /**
     * Untag a specified resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UntagResource.html
     */
    untagResource() {
        this.add('iotthingsgraph:UntagResource');
        return this;
    }
    /**
     * Updates the specified workflow. All deployed systems and system instances that use the workflow will see the changes in the flow when it is redeployed. The workflow can contain only entities in the specified namespace.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UpdateFlowTemplate.html
     */
    updateFlowTemplate() {
        this.add('iotthingsgraph:UpdateFlowTemplate');
        return this;
    }
    /**
     * Updates the specified system. You don't need to run this action after updating a workflow. Any system instance that uses the system will see the changes in the system when it is redeployed.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UpdateSystemTemplate.html
     */
    updateSystemTemplate() {
        this.add('iotthingsgraph:UpdateSystemTemplate');
        return this;
    }
    /**
     * Asynchronously uploads one or more entity definitions to the user's namespace.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/APIReference/{APIReferenceDocPage}API_UploadEntityDefinitions.html
     */
    uploadEntityDefinitions() {
        this.add('iotthingsgraph:UploadEntityDefinitions');
        return this;
    }
    /**
     * Adds a resource of type Workflow to the statement
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-models-tdm-iot-workflow.html
     *
     * @param namespacePath - Identifier for the namespacePath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onWorkflow(namespacePath, account, region, partition) {
        var arn = 'arn:${Partition}:iotthingsgraph:${Region}:${Account}:Workflow/${NamespacePath}';
        arn = arn.replace('${NamespacePath}', namespacePath);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type System to the statement
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-models-tdm-iot-system.html
     *
     * @param namespacePath - Identifier for the namespacePath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSystem(namespacePath, account, region, partition) {
        var arn = 'arn:${Partition}:iotthingsgraph:${Region}:${Account}:System/${NamespacePath}';
        arn = arn.replace('${NamespacePath}', namespacePath);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type SystemInstance to the statement
     *
     * https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-models-tdm-iot-sdc-deployconfig.html
     *
     * @param namespacePath - Identifier for the namespacePath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible condition keys:
     *  - aws:ResourceTag/${TagKey}
     */
    onSystemInstance(namespacePath, account, region, partition) {
        var arn = 'arn:${Partition}:iotthingsgraph:${Region}:${Account}:Deployment/${NamespacePath}';
        arn = arn.replace('${NamespacePath}', namespacePath);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
}
exports.Iotthingsgraph = Iotthingsgraph;
//# sourceMappingURL=data:application/json;base64,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