import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [iq](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsiq.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Iq extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [iq](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsiq.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to submit new project requests
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    createProject(): this;
}
