import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [pi](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsperformanceinsights.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Pi extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [pi](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsperformanceinsights.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * For a specific time period, retrieve the top N dimension keys for a metric.
     *
     * Access Level: Read
     */
    describeDimensionKeys(): this;
    /**
     * Retrieve PI metrics for a set of data sources, over a time period.
     *
     * Access Level: Read
     */
    getResourceMetrics(): this;
    /**
     * Adds a resource of type metric-resource to the statement
     *
     * @param serviceType - Identifier for the serviceType.
     * @param identifier - Identifier for the identifier.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onMetricResource(serviceType: string, identifier: string, account?: string, region?: string, partition?: string): this;
}
