"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Sms = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [sms](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsservermigrationservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Sms extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [sms](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsservermigrationservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'sms';
        this.actionList = {
            "CreateApp": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_CreateApp.html",
                "description": "Create an application configuration to migrate on-premise application onto AWS..",
                "accessLevel": "Write"
            },
            "CreateReplicationJob": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_CreateReplicationJob.html",
                "description": "Create a job to migrate on-premise server onto AWS.",
                "accessLevel": "Write"
            },
            "DeleteApp": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteApp.html",
                "description": "Delete an existing application configuration.",
                "accessLevel": "Write"
            },
            "DeleteAppLaunchConfiguration": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteAppLaunchConfiguration.html",
                "description": "Delete launch configuration for an existing application.",
                "accessLevel": "Write"
            },
            "DeleteAppReplicationConfiguration": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteAppReplicationConfiguration.html",
                "description": "Delete replication configuration for an existing application..",
                "accessLevel": "Write"
            },
            "DeleteReplicationJob": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteReplicationJob.html",
                "description": "Delete an existing job to migrate on-premise server onto AWS.",
                "accessLevel": "Write"
            },
            "DeleteServerCatalog": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteServerCatalog.html",
                "description": "Delete the complete list of on-premise servers gathered into AWS.",
                "accessLevel": "Write"
            },
            "DisassociateConnector": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DisassociateConnector.html",
                "description": "Disassociate a connector that has been associated.",
                "accessLevel": "Write"
            },
            "GenerateChangeSet": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GenerateChangeSet.html",
                "description": "Generate a changeSet for the CloudFormation stack of an application.",
                "accessLevel": "Write"
            },
            "GenerateTemplate": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GenerateTemplate.html",
                "description": "Generate a CloudFormation template for an existing application.",
                "accessLevel": "Write"
            },
            "GetApp": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetApp.html",
                "description": "Get the configuration and statuses for an existing application.",
                "accessLevel": "Read"
            },
            "GetAppLaunchConfiguration": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppLaunchConfiguration.html",
                "description": "Get launch configuration for an existing application.",
                "accessLevel": "Read"
            },
            "GetAppReplicationConfiguration": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppReplicationConfiguration.html",
                "description": "Get replication configuration for an existing application.",
                "accessLevel": "Read"
            },
            "GetConnectors": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetConnectors.html",
                "description": "Get all connectors that have been associated.",
                "accessLevel": "Read"
            },
            "GetMessages": {
                "url": "",
                "description": "Gets messages from AWS Server Migration Service to Server Migration Connector.",
                "accessLevel": "Read"
            },
            "GetReplicationJobs": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetReplicationJobs.html",
                "description": "Get all existing jobs to migrate on-premise servers onto AWS.",
                "accessLevel": "Read"
            },
            "GetReplicationRuns": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetReplicationRuns.html",
                "description": "Get all runs for an existing job.",
                "accessLevel": "Read"
            },
            "GetServers": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetServers.html",
                "description": "Get all servers that have been imported.",
                "accessLevel": "Read"
            },
            "ImportServerCatalog": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_ImportServerCatalog.html",
                "description": "Gathers a complete list of on-premise servers.",
                "accessLevel": "Write"
            },
            "LaunchApp": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_LaunchApp.html",
                "description": "Create and launch a CloudFormation stack for an existing application.",
                "accessLevel": "Write"
            },
            "ListApps": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_ListAppss.html",
                "description": "Get a list of summaries for existing applications.",
                "accessLevel": "List"
            },
            "PutAppLaunchConfiguration": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_PutAppLaunchConfiguration.html",
                "description": "Create or update launch configuration for an existing application.",
                "accessLevel": "Write"
            },
            "PutAppReplicationConfiguration": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_PutAppReplicationConfiguration.html",
                "description": "Create or update replication configuration for an existing application.",
                "accessLevel": "Write"
            },
            "SendMessage": {
                "url": "",
                "description": "Send message from Server Migration Connector to AWS Server Migration Service.",
                "accessLevel": "Write"
            },
            "StartAppReplication": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StartAppReplication.html",
                "description": "Create and start replication jobs for an existing application.",
                "accessLevel": "Write"
            },
            "StartOnDemandReplicationRun": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StartOnDemandReplicationRun.html",
                "description": "Start a replication run for an existing replication job.",
                "accessLevel": "Write"
            },
            "StopAppReplication": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StopAppReplication.html",
                "description": "Stop and delete replication jobs for an existing application.",
                "accessLevel": "Write"
            },
            "TerminateApp": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_TerminateApp.html",
                "description": "Terminate the CloudFormation stack for an existing application.",
                "accessLevel": "Write"
            },
            "UpdateApp": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_UpdateApp.html",
                "description": "Update an existing application configuration",
                "accessLevel": "Write"
            },
            "UpdateReplicationJob": {
                "url": "https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_UpdateReplicationJob.html",
                "description": "Update an existing job to migrate on-premise server onto AWS.",
                "accessLevel": "Write"
            }
        };
        this.resourceTypes = {};
    }
    /**
     * Create an application configuration to migrate on-premise application onto AWS..
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_CreateApp.html
     */
    createApp() {
        this.add('sms:CreateApp');
        return this;
    }
    /**
     * Create a job to migrate on-premise server onto AWS.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_CreateReplicationJob.html
     */
    createReplicationJob() {
        this.add('sms:CreateReplicationJob');
        return this;
    }
    /**
     * Delete an existing application configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteApp.html
     */
    deleteApp() {
        this.add('sms:DeleteApp');
        return this;
    }
    /**
     * Delete launch configuration for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteAppLaunchConfiguration.html
     */
    deleteAppLaunchConfiguration() {
        this.add('sms:DeleteAppLaunchConfiguration');
        return this;
    }
    /**
     * Delete replication configuration for an existing application..
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteAppReplicationConfiguration.html
     */
    deleteAppReplicationConfiguration() {
        this.add('sms:DeleteAppReplicationConfiguration');
        return this;
    }
    /**
     * Delete an existing job to migrate on-premise server onto AWS.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteReplicationJob.html
     */
    deleteReplicationJob() {
        this.add('sms:DeleteReplicationJob');
        return this;
    }
    /**
     * Delete the complete list of on-premise servers gathered into AWS.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteServerCatalog.html
     */
    deleteServerCatalog() {
        this.add('sms:DeleteServerCatalog');
        return this;
    }
    /**
     * Disassociate a connector that has been associated.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DisassociateConnector.html
     */
    disassociateConnector() {
        this.add('sms:DisassociateConnector');
        return this;
    }
    /**
     * Generate a changeSet for the CloudFormation stack of an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GenerateChangeSet.html
     */
    generateChangeSet() {
        this.add('sms:GenerateChangeSet');
        return this;
    }
    /**
     * Generate a CloudFormation template for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GenerateTemplate.html
     */
    generateTemplate() {
        this.add('sms:GenerateTemplate');
        return this;
    }
    /**
     * Get the configuration and statuses for an existing application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetApp.html
     */
    getApp() {
        this.add('sms:GetApp');
        return this;
    }
    /**
     * Get launch configuration for an existing application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppLaunchConfiguration.html
     */
    getAppLaunchConfiguration() {
        this.add('sms:GetAppLaunchConfiguration');
        return this;
    }
    /**
     * Get replication configuration for an existing application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppReplicationConfiguration.html
     */
    getAppReplicationConfiguration() {
        this.add('sms:GetAppReplicationConfiguration');
        return this;
    }
    /**
     * Get all connectors that have been associated.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetConnectors.html
     */
    getConnectors() {
        this.add('sms:GetConnectors');
        return this;
    }
    /**
     * Gets messages from AWS Server Migration Service to Server Migration Connector.
     *
     * Access Level: Read
     */
    getMessages() {
        this.add('sms:GetMessages');
        return this;
    }
    /**
     * Get all existing jobs to migrate on-premise servers onto AWS.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetReplicationJobs.html
     */
    getReplicationJobs() {
        this.add('sms:GetReplicationJobs');
        return this;
    }
    /**
     * Get all runs for an existing job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetReplicationRuns.html
     */
    getReplicationRuns() {
        this.add('sms:GetReplicationRuns');
        return this;
    }
    /**
     * Get all servers that have been imported.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetServers.html
     */
    getServers() {
        this.add('sms:GetServers');
        return this;
    }
    /**
     * Gathers a complete list of on-premise servers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_ImportServerCatalog.html
     */
    importServerCatalog() {
        this.add('sms:ImportServerCatalog');
        return this;
    }
    /**
     * Create and launch a CloudFormation stack for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_LaunchApp.html
     */
    launchApp() {
        this.add('sms:LaunchApp');
        return this;
    }
    /**
     * Get a list of summaries for existing applications.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_ListAppss.html
     */
    listApps() {
        this.add('sms:ListApps');
        return this;
    }
    /**
     * Create or update launch configuration for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_PutAppLaunchConfiguration.html
     */
    putAppLaunchConfiguration() {
        this.add('sms:PutAppLaunchConfiguration');
        return this;
    }
    /**
     * Create or update replication configuration for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_PutAppReplicationConfiguration.html
     */
    putAppReplicationConfiguration() {
        this.add('sms:PutAppReplicationConfiguration');
        return this;
    }
    /**
     * Send message from Server Migration Connector to AWS Server Migration Service.
     *
     * Access Level: Write
     */
    sendMessage() {
        this.add('sms:SendMessage');
        return this;
    }
    /**
     * Create and start replication jobs for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StartAppReplication.html
     */
    startAppReplication() {
        this.add('sms:StartAppReplication');
        return this;
    }
    /**
     * Start a replication run for an existing replication job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StartOnDemandReplicationRun.html
     */
    startOnDemandReplicationRun() {
        this.add('sms:StartOnDemandReplicationRun');
        return this;
    }
    /**
     * Stop and delete replication jobs for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StopAppReplication.html
     */
    stopAppReplication() {
        this.add('sms:StopAppReplication');
        return this;
    }
    /**
     * Terminate the CloudFormation stack for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_TerminateApp.html
     */
    terminateApp() {
        this.add('sms:TerminateApp');
        return this;
    }
    /**
     * Update an existing application configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_UpdateApp.html
     */
    updateApp() {
        this.add('sms:UpdateApp');
        return this;
    }
    /**
     * Update an existing job to migrate on-premise server onto AWS.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_UpdateReplicationJob.html
     */
    updateReplicationJob() {
        this.add('sms:UpdateReplicationJob');
        return this;
    }
}
exports.Sms = Sms;
//# sourceMappingURL=data:application/json;base64,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