import { Actions, PolicyStatement, ResourceTypes } from "../shared";
/**
 * Statement provider for service [sso-directory](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsssodirectory.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class SsoDirectory extends PolicyStatement {
    servicePrefix: string;
    protected actionList: Actions;
    resourceTypes: ResourceTypes;
    /**
     * Statement provider for service [sso-directory](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsssodirectory.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Adds member to the group in the directory that AWS SSO provides by default
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    addMemberToGroup(): this;
    /**
     * Completes the creation process of a virtual MFA device
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    completeVirtualMfaDeviceRegistration(): this;
    /**
     * Creates an alias for the directory that AWS SSO provides by default
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    createAlias(): this;
    /**
     * Creates a bearer token for a given provisioning tenant.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    createBearerToken(): this;
    /**
     * Create an External Identity Provider configuration for the directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    createExternalIdPConfigurationForDirectory(): this;
    /**
     * Creates a group in the directory that AWS SSO provides by default
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    createGroup(): this;
    /**
     * Creates a provisioning tenant for a given directory.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    createProvisioningTenant(): this;
    /**
     * Creates a user in the directory that AWS SSO provides by default
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    createUser(): this;
    /**
     * Deletes the bearer token.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    deleteBearerToken(): this;
    /**
     * Delete an External Identity Provider configuration associated with the directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    deleteExternalIdPConfigurationForDirectory(): this;
    /**
     * Deletes a group from the directory that AWS SSO provides by default
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    deleteGroup(): this;
    /**
     * Deletes a MFA device by device name for a given user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    deleteMfaDeviceForUser(): this;
    /**
     * Deletes the provisioning tenant.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    deleteProvisioningTenant(): this;
    /**
     * Deletes a user from the directory that AWS SSO provides by default
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    deleteUser(): this;
    /**
     * Retrieve information about the directory that AWS SSO provides by default
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    describeDirectory(): this;
    /**
     * Retrieves information about group from the directory that AWS SSO provides by default
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    describeGroups(): this;
    /**
     * Retrieves information about user from the directory that AWS SSO provides by default
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    describeUsers(): this;
    /**
     * Disable authentication of end users with an External Identity Provider
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    disableExternalIdPConfigurationForDirectory(): this;
    /**
     * Deactivates user in the directory that AWS SSO provides by default
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    disableUser(): this;
    /**
     * Enable authentication of end users with an External Identity Provider
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    enableExternalIdPConfigurationForDirectory(): this;
    /**
     * Activates user in the directory that AWS SSO provides by default
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    enableUser(): this;
    /**
     * Retrieve the AWS SSO Service Provider configurations for the directory
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    getAWSSPConfigurationForDirectory(): this;
    /**
     * Lists bearer tokens for a given provisioning tenant.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    listBearerTokens(): this;
    /**
     * List all the External Identity Provider configurations created for the directory
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    listExternalIdPConfigurationsForDirectory(): this;
    /**
     * Lists groups for a user from the directory that AWS SSO provides by default
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    listGroupsForUser(): this;
    /**
     * Retrieves all members that are part of the group in the directory that AWS SSO provides by default
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    listMembersInGroup(): this;
    /**
     * Lists all active MFA devices and their MFA device metadata for a user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    listMfaDevicesForUser(): this;
    /**
     * Lists provisioning tenants for a given directory.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    listProvisioningTenants(): this;
    /**
     * Removes member that are part of the group in the directory that AWS SSO provides by default
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    removeMemberFromGroup(): this;
    /**
     * Search for groups within the associated directory
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    searchGroups(): this;
    /**
     * Search for users within the associated directory
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    searchUsers(): this;
    /**
     * Begins the creation process of virtual mfa device
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    startVirtualMfaDeviceRegistration(): this;
    /**
     * Update an External Identity Provider configuration associated with the directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    updateExternalIdPConfigurationForDirectory(): this;
    /**
     * Updates information about group in the directory that AWS SSO provides by default
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    updateGroup(): this;
    /**
     * Updates password by sending password reset link via email or generating one time password for a user in the directory that AWS SSO provides by default
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    updatePassword(): this;
    /**
     * Updates user information in the directory that AWS SSO provides by default
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    updateUser(): this;
    /**
     * Verify email address of an User
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/singlesignon/latest/userguide/iam-auth-access-using-id-policies.html#policyexample
     */
    verifyEmail(): this;
}
