# !/usr/bin/env python

import os
import re
from setuptools import setup


def resource(*args):
    return os.path.join(os.path.abspath(os.path.join(__file__, os.pardir)),
                        *args)


with open(resource('hciplot', '__init__.py')) as version_file:
    version_file = version_file.read()
    VERSION = re.search(r"""^__version__ = ['"]([^'"]*)['"]""",
                        version_file, re.M)
    VERSION = VERSION.group(1)

with open(resource('README.md')) as readme_file:
    README = readme_file.read()

setup(
    name='hciplot',
    packages=['hciplot'],
    version=VERSION,
    description='High-contrast Imaging Plotting library',
    long_description=README,
    long_description_content_type='text/markdown',
    author='Carlos Alberto Gomez Gonzalez, Valentin Christiaens',
    license='MIT',
    author_email='valentinchrist@hotmail.com',
    url='https://github.com/carlgogo/hciplot',
    download_url='https://github.com/carlgogo/hciplot/archive/refs/tags/v0.1.8.tar.gz',
    keywords=['plotting', 'hci', 'package'],
    install_requires=['numpy >= 1.16',
                      'matplotlib >= 2.2',
                      'bokeh >=1.0',
                      'holoviews >= 1.11'],
    classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Console',
        'Intended Audience :: Science/Research',
        'Operating System :: MacOS :: MacOS X',
        'Operating System :: POSIX :: Linux',
        'Natural Language :: English',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Topic :: Scientific/Engineering :: Astronomy'],
)
