"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisPutRecordAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const role_1 = require("./private/role");
/**
 * The action to put the record from an MQTT message to the Kinesis Data stream.
 */
class KinesisPutRecordAction {
    /**
     * @param stream The Kinesis Data stream to which to put records.
     * @param props Optional properties to not use default
     */
    constructor(stream, props) {
        this.stream = stream;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_KinesisPutRecordActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, KinesisPutRecordAction);
            }
            throw error;
        }
        this.partitionKey = props.partitionKey;
        this.role = props.role;
    }
    bind(rule) {
        const role = this.role ?? role_1.singletonActionRole(rule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['kinesis:PutRecord'],
            resources: [this.stream.streamArn],
        }));
        return {
            configuration: {
                kinesis: {
                    streamName: this.stream.streamName,
                    partitionKey: this.partitionKey || undefined,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.KinesisPutRecordAction = KinesisPutRecordAction;
_a = JSII_RTTI_SYMBOL_1;
KinesisPutRecordAction[_a] = { fqn: "@aws-cdk/aws-iot-actions.KinesisPutRecordAction", version: "1.190.0" };
//# sourceMappingURL=data:application/json;base64,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