"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsQueueAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const role_1 = require("./private/role");
/**
 * The action to write the data from an MQTT message to an Amazon SQS queue.
 */
class SqsQueueAction {
    /**
     * @param queue The Amazon SQS queue to which to write data.
     * @param props Optional properties to not use default
     */
    constructor(queue, props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_SqsQueueActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SqsQueueAction);
            }
            throw error;
        }
        this.queue = queue;
        this.role = props.role;
        this.useBase64 = props.useBase64;
    }
    bind(rule) {
        const role = this.role ?? role_1.singletonActionRole(rule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['sqs:SendMessage'],
            resources: [this.queue.queueArn],
        }));
        return {
            configuration: {
                sqs: {
                    queueUrl: this.queue.queueUrl,
                    useBase64: this.useBase64,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.SqsQueueAction = SqsQueueAction;
_a = JSII_RTTI_SYMBOL_1;
SqsQueueAction[_a] = { fqn: "@aws-cdk/aws-iot-actions.SqsQueueAction", version: "1.190.0" };
//# sourceMappingURL=data:application/json;base64,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