# Generated by Django 2.1.7 on 2019-03-11 13:56

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [("invoices", "0006_auto_20190309_2143")]

    operations = [
        migrations.RemoveField(model_name="cost", name="service"),
        migrations.RemoveField(model_name="effort", name="service"),
        migrations.RemoveField(model_name="effort", name="service_type"),
        migrations.AddField(
            model_name="service",
            name="effort_rate",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                max_digits=10,
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="hourly rate",
            ),
        ),
        migrations.AddField(
            model_name="service",
            name="effort_type",
            field=models.CharField(
                blank=True, max_length=50, verbose_name="effort type"
            ),
        ),
        migrations.AddField(
            model_name="service",
            name="service_cost",
            field=models.DecimalField(
                decimal_places=2,
                default=0,
                max_digits=10,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="service cost",
            ),
        ),
        migrations.AddField(
            model_name="service",
            name="service_hours",
            field=models.DecimalField(
                decimal_places=1,
                default=0,
                max_digits=4,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="service hours",
            ),
        ),
        migrations.AddField(
            model_name="service",
            name="third_party_costs",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                default=None,
                help_text="Total incl. tax for third-party services.",
                max_digits=10,
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="third party costs",
            ),
        ),
        migrations.AlterField(
            model_name="service",
            name="cost",
            field=models.DecimalField(
                blank=True,
                decimal_places=2,
                max_digits=10,
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="cost",
            ),
        ),
        migrations.AlterField(
            model_name="service",
            name="effort_hours",
            field=models.DecimalField(
                blank=True,
                decimal_places=1,
                max_digits=4,
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="hours",
            ),
        ),
        migrations.DeleteModel(name="Cost"),
        migrations.DeleteModel(name="Effort"),
    ]
